/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AggregationSolve;
import oracle.AWXML.AllocationSolve;
import oracle.AWXML.BaseObject;
import oracle.AWXML.Cube;
import oracle.AWXML.Dimension;
import oracle.AWXML.ForecastSolve;
import oracle.AWXML.Solve;

public class SolveGroup
extends BaseObject {
    private Vector m_solves = new Vector(0);

    public String getId() {
        if (this.m_id != null) {
            return this.m_id.toUpperCase();
        }
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.toUpperCase();
        return this.m_name.toUpperCase() + "." + string.toUpperCase();
    }

    public String getParentId() {
        return this.m_name.toUpperCase();
    }

    public String WriteToXML() {
        String string = null;
        string = SolveGroup.TAB() + this.WriteElementStart("SolveGroup");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + SolveGroup.TAB() + this.WriteElementEndTag("SolveGroup") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        return string;
    }

    public String WriteContentsToXML() {
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_solves.iterator();
        while (iterator.hasNext()) {
            Solve solve = (Solve)iterator.next();
            if (string == null) {
                string = SolveGroup.TAB() + this.WriteElementStart("Solve") + s_EndTag + s_NEWLINE;
                ++s_Indent;
                string = string + solve.WriteToXML();
                --s_Indent;
                string = string + SolveGroup.TAB() + this.WriteElementEndTag("Solve") + s_NEWLINE;
                continue;
            }
            string = string + SolveGroup.TAB() + this.WriteElementStart("Solve") + s_EndTag + s_NEWLINE;
            ++s_Indent;
            string = string + solve.WriteToXML();
            --s_Indent;
            string = string + SolveGroup.TAB() + this.WriteElementEndTag("Solve") + s_NEWLINE;
        }
        return string;
    }

    public String Create(AWConnection aWConnection) {
        aWConnection.executeCommand("call create_solvegroup(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-300000", new Object[]{this.getId(), this.m_commandResultText});
        }
        Iterator iterator = this.getSolves().iterator();
        while (iterator.hasNext()) {
            Solve solve = (Solve)iterator.next();
            solve.Create(aWConnection);
        }
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        String string = "success";
        string = aWConnection.executeCommand("call DELETE_SOLVEGROUP(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-300001", new Object[]{this.getId(), this.m_commandResultText});
        }
        return string;
    }

    public void readAWDefinitions(AWConnection aWConnection, AW aW) {
        if (!this.m_dataRead) {
            BaseObject baseObject;
            Object object = aW.getDimensions().iterator();
            while (object.hasNext()) {
                baseObject = (Dimension)object.next();
                ((Dimension)baseObject).readAWDefinitions(aWConnection, true);
            }
            object = aW.getCubes().iterator();
            while (object.hasNext()) {
                baseObject = (Cube)object.next();
                ((Cube)baseObject).readAWDefinitions(aWConnection, true);
            }
            this.m_dataRead = true;
            object = new Vector(0);
            if (AW.s_allSolvesObj != null) {
                aWConnection.limitDimension(AW.s_allSolveGroupsObj, "TO", this.getId());
                aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_allSolvesObj + " TO " + AW.getCurAW().getName() + "!" + AW.s_allSolvesOrderObj);
                object = aWConnection.getDimensionValues(AW.s_allSolvesObj);
            }
            baseObject = null;
            String string = null;
            Iterator iterator = ((Vector)object).iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                aWConnection.limitDimension(AW.s_allSolvesObj, "TO", string2);
                aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_solveDfnObj + " TO " + AW.getCurAW().getName() + "!" + AW.s_allSolvesObj);
                Vector vector = aWConnection.getDimensionValues(AW.s_solveDfnObj);
                String string3 = (String)vector.elementAt(0);
                if (string2.indexOf(".AGGREGATIONSOLVE") > -1) {
                    baseObject = this.createAggregationSolve();
                    string = this.getNamePart(1, string3);
                    ((AggregationSolve)baseObject).setAggregationDefinition(aW.findCube(string).findAggregationDefinition(string3));
                }
                if (string2.indexOf(".ALLOCATIONSOLVE") > -1) {
                    baseObject = this.createAllocationSolve();
                    string = this.getNamePart(1, string3);
                    ((AllocationSolve)baseObject).setAllocationDefinition(aW.findCube(string).findAllocationDefinition(string3));
                }
                if (string2.indexOf(".FORECASTSOLVE") > -1) {
                    baseObject = this.createForecastSolve();
                    string = this.getNamePart(1, string3);
                    ((ForecastSolve)baseObject).setForecastDefinition(aW.findCube(string).findForecastDefinition(string3));
                }
                baseObject.setName(baseObject.getLogicalNamePart(string2));
                aWConnection.getDescriptors(baseObject);
                ((Solve)baseObject).readAWDefinitions(aWConnection, true);
            }
        }
    }

    public AggregationSolve createAggregationSolve() {
        AggregationSolve aggregationSolve = new AggregationSolve(this);
        this.addSolve(aggregationSolve);
        aggregationSolve.setName("Solve" + this.m_solves.size());
        aggregationSolve.setSolveOrder(this.m_solves.size());
        return aggregationSolve;
    }

    public AggregationSolve createAggregationSolveAfter(Solve solve) {
        AggregationSolve aggregationSolve = new AggregationSolve(this);
        this.addSolveAfter(aggregationSolve, solve);
        aggregationSolve.setName("Solve" + this.m_solves.size());
        aggregationSolve.setSolveOrder(this.m_solves.size());
        return aggregationSolve;
    }

    public AggregationSolve createAggregationSolveBefore(Solve solve) {
        AggregationSolve aggregationSolve = new AggregationSolve(this);
        this.addSolveBefore(aggregationSolve, solve);
        aggregationSolve.setName("Solve" + this.m_solves.size());
        aggregationSolve.setSolveOrder(this.m_solves.size());
        return aggregationSolve;
    }

    public AggregationSolve createAggregationSolveFirst() {
        AggregationSolve aggregationSolve = new AggregationSolve(this);
        this.addSolveFirst(aggregationSolve);
        aggregationSolve.setName("Solve" + this.m_solves.size());
        aggregationSolve.setSolveOrder(this.m_solves.size());
        return aggregationSolve;
    }

    public AllocationSolve createAllocationSolve() {
        AllocationSolve allocationSolve = new AllocationSolve(this);
        this.addSolve(allocationSolve);
        allocationSolve.setName("Solve" + this.m_solves.size());
        allocationSolve.setSolveOrder(this.m_solves.size());
        return allocationSolve;
    }

    public AllocationSolve createAllocationSolveAfter(Solve solve) {
        AllocationSolve allocationSolve = new AllocationSolve(this);
        this.addSolveAfter(allocationSolve, solve);
        allocationSolve.setName("Solve" + this.m_solves.size());
        allocationSolve.setSolveOrder(this.m_solves.size());
        return allocationSolve;
    }

    public AllocationSolve createAllocationSolveBefore(Solve solve) {
        AllocationSolve allocationSolve = new AllocationSolve(this);
        this.addSolveBefore(allocationSolve, solve);
        allocationSolve.setName("Solve" + this.m_solves.size());
        allocationSolve.setSolveOrder(this.m_solves.size());
        return allocationSolve;
    }

    public AllocationSolve createAllocationSolveFirst() {
        AllocationSolve allocationSolve = new AllocationSolve(this);
        this.addSolveFirst(allocationSolve);
        allocationSolve.setName("Solve" + this.m_solves.size());
        allocationSolve.setSolveOrder(this.m_solves.size());
        return allocationSolve;
    }

    public ForecastSolve createForecastSolve() {
        ForecastSolve forecastSolve = new ForecastSolve(this);
        this.addSolve(forecastSolve);
        forecastSolve.setName("Solve" + this.m_solves.size());
        forecastSolve.setSolveOrder(this.m_solves.size());
        return forecastSolve;
    }

    public ForecastSolve createForecastSolveAfter(Solve solve) {
        ForecastSolve forecastSolve = new ForecastSolve(this);
        this.addSolveAfter(forecastSolve, solve);
        forecastSolve.setName("Solve" + this.m_solves.size());
        forecastSolve.setSolveOrder(this.m_solves.size());
        return forecastSolve;
    }

    public ForecastSolve createForecastSolveBefore(Solve solve) {
        ForecastSolve forecastSolve = new ForecastSolve(this);
        this.addSolveBefore(forecastSolve, solve);
        forecastSolve.setName("Solve" + this.m_solves.size());
        forecastSolve.setSolveOrder(this.m_solves.size());
        return forecastSolve;
    }

    public ForecastSolve createForecastSolveFirst() {
        ForecastSolve forecastSolve = new ForecastSolve(this);
        this.addSolveFirst(forecastSolve);
        forecastSolve.setName("Solve" + this.m_solves.size());
        forecastSolve.setSolveOrder(this.m_solves.size());
        return forecastSolve;
    }

    public void addSolve(Solve solve) {
        this.m_solves.add(solve);
    }

    public void addSolveBefore(Solve solve, BaseObject baseObject) {
        int n;
        if (baseObject instanceof Solve) {
            n = this.m_solves.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "SOLVES"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{solve.getId(), "SOLVE"});
        }
        this.m_solves.add(n, solve);
    }

    public void addSolveAfter(Solve solve, BaseObject baseObject) {
        int n;
        if (baseObject instanceof Solve) {
            n = this.m_solves.indexOf(baseObject);
            if (n <= -1) {
                throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "SOLVES"});
            }
        } else {
            throw new AWException("AWXML-ERR-NUM-900001", new Object[]{solve.getId(), "SOLVE"});
        }
        this.m_solves.add(n + 1, solve);
    }

    public void addSolveFirst(Solve solve) {
        this.m_solves.add(0, solve);
    }

    public void removeSolve(Solve solve) {
        this.m_solves.remove(solve);
    }

    public Vector getSolves() {
        return this.m_solves;
    }

    public String Alter(AWConnection aWConnection) {
        aWConnection.executeCommand("call alter_solvegroup(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("Alter failed: " + this.m_commandResultText);
        }
        return "success";
    }
}

