/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.AWObject;
import oracle.AWXML.AggregationDefinition;
import oracle.AWXML.AggregationHierarchySpecification;
import oracle.AWXML.AllocationDefinition;
import oracle.AWXML.BaseObject;
import oracle.AWXML.CalculationSpecification;
import oracle.AWXML.CubeDimRef;
import oracle.AWXML.CubeDimensionSourceExpression;
import oracle.AWXML.CubeMapGroup;
import oracle.AWXML.DerivedMeasure;
import oracle.AWXML.Dimension;
import oracle.AWXML.ExternalSourceExpression;
import oracle.AWXML.ForecastDefinition;
import oracle.AWXML.Hierarchy;
import oracle.AWXML.Level;
import oracle.AWXML.Measure;
import oracle.AWXML.MeasureFolder;
import oracle.AWXML.OlapMeasure;
import oracle.AWXML.OlapMeasureInput;
import oracle.AWXML.RestrictedSourceExpression;
import oracle.AWXML.SolveDefinition;
import oracle.AWXML.SourceColumn;
import oracle.AWXML.WhereClause;

public class Cube
extends AWObject {
    private Vector m_dimensions = new Vector(0);
    private Vector m_measures = new Vector(0);
    private Vector m_derivedMeasures = new Vector(0);
    private Vector m_solveDefinitions = new Vector(0);
    private AggregationDefinition m_defaultAggregation;
    private Hierarchy m_partitionHierarchy;
    private Level m_partitionLevel;
    private Boolean m_useGlobalIndex = new Boolean(false);
    private String m_sparseType = "STANDARD";
    private String m_defaultDatatype = null;
    private String m_autoSolve = "YES";
    private boolean m_persisted = false;

    public Cube() {
        this.m_schema = "AW$DEFAULT";
    }

    public Cube(BaseObject baseObject) {
        super(baseObject);
        this.m_schema = "AW$DEFAULT";
    }

    public String getId() {
        if (this.m_id != null) {
            return this.m_id.toUpperCase();
        }
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1);
        string = string.toUpperCase();
        return this.m_name.toUpperCase() + "." + string.toUpperCase();
    }

    public String getParentId() {
        return this.m_name.toUpperCase();
    }

    public void setDefaultAggregationDefinition(AggregationDefinition aggregationDefinition) {
        this.m_defaultAggregation = aggregationDefinition;
    }

    public AggregationDefinition getDefaultAggregationDefinition() {
        return this.m_defaultAggregation;
    }

    public String getDefaultDataType() {
        return this.m_defaultDatatype;
    }

    public void setDefaultDataType(String string) {
        this.m_defaultDatatype = string;
    }

    public void setAutoSolve(String string) {
        if (!string.equalsIgnoreCase("YES") && !string.equalsIgnoreCase("NO")) {
            throw new AWException("AWXML-ERR-NUM-900003");
        }
        this.m_autoSolve = string;
    }

    public String getAutoSolve() {
        return this.m_autoSolve;
    }

    public String WriteToXML() {
        String string = null;
        string = Cube.TAB() + this.WriteElementStart("Cube");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + Cube.TAB() + this.WriteElementEndTag("Cube") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = super.WriteAttributesToXML();
        if (this.m_useGlobalIndex != null) {
            string = string == null ? this.WriteAsAttribute("UseGlobalIndex", this.m_useGlobalIndex.toString()) : string + this.WriteAsAttribute("UseGlobalIndex", this.m_useGlobalIndex.toString());
        }
        if (this.m_sparseType != null) {
            string = string == null ? this.WriteAsAttribute("SparseType", this.m_sparseType) : string + this.WriteAsAttribute("SparseType", this.m_sparseType);
        }
        if (this.m_defaultDatatype != null) {
            string = string == null ? this.WriteAsAttribute("DefaultDataType", this.m_defaultDatatype) : string + this.WriteAsAttribute("DefaultDataType", this.m_defaultDatatype);
        }
        if (this.m_autoSolve != null) {
            string = string == null ? this.WriteAsAttribute("AutoSolve", this.m_autoSolve) : string + this.WriteAsAttribute("AutoSolve", this.m_autoSolve);
        }
        return string;
    }

    public String WriteContentsToXML() {
        BaseObject baseObject;
        String string = super.WriteContentsToXML();
        Iterator iterator = this.m_solveDefinitions.iterator();
        while (iterator.hasNext()) {
            baseObject = (SolveDefinition)iterator.next();
            if (string == null) {
                string = Cube.TAB() + this.WriteElementStart("SolveDefinition") + s_EndTag + s_NEWLINE;
                ++s_Indent;
                string = string + ((SolveDefinition)baseObject).WriteToXML();
                --s_Indent;
                string = string + Cube.TAB() + this.WriteElementEndTag("SolveDefinition") + s_NEWLINE;
                continue;
            }
            string = string + Cube.TAB() + this.WriteElementStart("SolveDefinition") + s_EndTag + s_NEWLINE;
            ++s_Indent;
            string = string + ((SolveDefinition)baseObject).WriteToXML();
            --s_Indent;
            string = string + Cube.TAB() + this.WriteElementEndTag("SolveDefinition") + s_NEWLINE;
        }
        if (this.m_defaultAggregation != null) {
            string = string == null ? this.WriteAsIDRef("DefaultAggregationDefinition", this.m_defaultAggregation) : string + this.WriteAsIDRef("DefaultAggregationDefinition", this.m_defaultAggregation);
        }
        iterator = this.m_dimensions.iterator();
        while (iterator.hasNext()) {
            baseObject = (CubeDimRef)iterator.next();
            if (string == null) {
                string = ((CubeDimRef)baseObject).WriteToXML();
                continue;
            }
            string = string + ((CubeDimRef)baseObject).WriteToXML();
        }
        iterator = this.m_measures.iterator();
        while (iterator.hasNext()) {
            baseObject = (Measure)iterator.next();
            if (string == null) {
                string = ((Measure)baseObject).WriteToXML();
                continue;
            }
            string = string + ((Measure)baseObject).WriteToXML();
        }
        iterator = this.m_derivedMeasures.iterator();
        while (iterator.hasNext()) {
            Measure measure;
            baseObject = (BaseObject)iterator.next();
            if (baseObject instanceof DerivedMeasure) {
                measure = (DerivedMeasure)baseObject;
                if (string == null) {
                    string = ((DerivedMeasure)measure).WriteToXML();
                    continue;
                }
                string = string + ((DerivedMeasure)measure).WriteToXML();
                continue;
            }
            if (!(baseObject instanceof OlapMeasure)) continue;
            measure = (OlapMeasure)baseObject;
            if (string == null) {
                string = ((OlapMeasure)measure).WriteToXML();
                continue;
            }
            string = string + ((OlapMeasure)measure).WriteToXML();
        }
        if (this.m_partitionHierarchy != null) {
            string = string == null ? this.WriteAsIDRef("PartitionHierarchy", this.m_partitionHierarchy) : string + this.WriteAsIDRef("PartitionHierarchy", this.m_partitionHierarchy);
        }
        if (this.m_partitionLevel != null) {
            string = string == null ? this.WriteAsIDRef("PartitionLevel", this.m_partitionLevel) : string + this.WriteAsIDRef("PartitionLevel", this.m_partitionLevel);
        }
        return string;
    }

    protected boolean validateDim(CubeDimRef cubeDimRef) {
        if (cubeDimRef.getDimension() != null) {
            Iterator iterator = this.m_dimensions.iterator();
            while (iterator.hasNext()) {
                CubeDimRef cubeDimRef2 = (CubeDimRef)iterator.next();
                if (cubeDimRef2.getDimension() == null || cubeDimRef2.getDimension() != cubeDimRef.getDimension()) continue;
                throw new AWException("AWXML-ERR-NUM-100006", new Object[]{this.getId(), cubeDimRef.getId()});
            }
        }
        return true;
    }

    public void addCubeDimRef(CubeDimRef cubeDimRef) {
        if (this.validateDim(cubeDimRef)) {
            this.m_dimensions.add(cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCubeDimRefAfter(CubeDimRef cubeDimRef, BaseObject baseObject) {
        if (!(baseObject instanceof CubeDimRef)) throw new AWException("AWXML-ERR-NUM-900001", new Object[]{cubeDimRef.getId(), "CUBEDIMREF"});
        int n = this.m_dimensions.indexOf(baseObject);
        if (n <= -1) throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "CUBEDIMENSIONS"});
        if (this.validateDim(cubeDimRef)) {
            this.m_dimensions.add(n + 1, cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addCubeDimRefBefore(CubeDimRef cubeDimRef, BaseObject baseObject) {
        if (!(baseObject instanceof CubeDimRef)) throw new AWException("AWXML-ERR-NUM-900001", new Object[]{cubeDimRef.getId(), "CUBEDIMREF"});
        int n = this.m_dimensions.indexOf(baseObject);
        if (n <= -1) throw new AWException("AWXML-ERR-NUM-900000", new Object[]{baseObject.getId(), "CUBEDIMENSIONS"});
        if (this.validateDim(cubeDimRef)) {
            this.m_dimensions.add(n, cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    public void addCubeDimRefFirst(CubeDimRef cubeDimRef) {
        if (this.validateDim(cubeDimRef)) {
            this.m_dimensions.add(0, cubeDimRef);
        }
        cubeDimRef.setOwner(this);
    }

    public void removeCubeDimRef(CubeDimRef cubeDimRef) {
        this.m_dimensions.remove(cubeDimRef);
    }

    public Vector getCubeDimRefs() {
        return this.m_dimensions;
    }

    public void addMeasure(Measure measure) {
        if (measure.getOwner() != null && measure.getOwner() != this) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), measure.getId()});
        }
        this.m_measures.add(measure);
        measure.setOwner(this);
    }

    public void removeMeasure(Measure measure) {
        this.m_measures.remove(measure);
    }

    public Vector getMeasures() {
        return this.m_measures;
    }

    public void addOlapMeasure(OlapMeasure olapMeasure) {
        if (olapMeasure.getOwner() != null && olapMeasure.getOwner() != this) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), olapMeasure.getId()});
        }
        this.m_derivedMeasures.add(olapMeasure);
        olapMeasure.setOwner(this);
    }

    public void removeOlapMeasure(OlapMeasure olapMeasure) {
        this.m_derivedMeasures.remove(olapMeasure);
    }

    public void addDerivedMeasure(DerivedMeasure derivedMeasure) {
        if (derivedMeasure.getOwner() != null && derivedMeasure.getOwner() != this) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.getId(), derivedMeasure.getId()});
        }
        this.m_derivedMeasures.add(derivedMeasure);
        derivedMeasure.setOwner(this);
    }

    public void removeDerivedMeasure(DerivedMeasure derivedMeasure) {
        this.m_derivedMeasures.remove(derivedMeasure);
    }

    public Vector getDerivedMeasures() {
        return this.m_derivedMeasures;
    }

    public void setSparseType(String string) {
        if (!string.equalsIgnoreCase("STANDARD") && !string.equalsIgnoreCase("COMPRESSED")) {
            throw new AWException("AWXML-ERR-NUM-100002");
        }
        this.m_sparseType = string;
    }

    public String getSparseType() {
        return this.m_sparseType;
    }

    public Measure createMeasure() {
        Measure measure = new Measure(this);
        this.addMeasure(measure);
        return measure;
    }

    public DerivedMeasure createDerivedMeasure() {
        DerivedMeasure derivedMeasure = new DerivedMeasure(this);
        this.addDerivedMeasure(derivedMeasure);
        return derivedMeasure;
    }

    public OlapMeasure createOlapMeasure() {
        OlapMeasure olapMeasure = new OlapMeasure(this);
        this.addOlapMeasure(olapMeasure);
        return olapMeasure;
    }

    public CubeDimRef createCubeDimRef() {
        CubeDimRef cubeDimRef = new CubeDimRef(this);
        this.addCubeDimRef(cubeDimRef);
        return cubeDimRef;
    }

    public CubeDimRef createCubeDimRefAfter(CubeDimRef cubeDimRef) {
        CubeDimRef cubeDimRef2 = new CubeDimRef(this);
        this.addCubeDimRefAfter(cubeDimRef2, cubeDimRef);
        return cubeDimRef2;
    }

    public CubeDimRef createCubeDimRefBefore(CubeDimRef cubeDimRef) {
        CubeDimRef cubeDimRef2 = new CubeDimRef(this);
        this.addCubeDimRefBefore(cubeDimRef2, cubeDimRef);
        return cubeDimRef2;
    }

    public CubeDimRef createCubeDimRefFirst() {
        CubeDimRef cubeDimRef = new CubeDimRef(this);
        this.addCubeDimRefFirst(cubeDimRef);
        return cubeDimRef;
    }

    public String Create(AWConnection aWConnection) {
        BaseObject baseObject;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        if (this.m_dimensions.size() <= 0) {
            throw new AWException("AWXML-ERR-NUM-100003");
        }
        if (this.m_defaultAggregation == null) {
            throw new AWException("AWXML-ERR-NUM-100004");
        }
        String string = AWNULL;
        String string2 = AWNULL;
        Object object6 = this.m_dimensions.iterator();
        while (object6.hasNext()) {
            object5 = (CubeDimRef)object6.next();
            if (((CubeDimRef)object5).getDimension() == null) {
                throw new AWException("AWXML-ERR-NUM-100005", new Object[]{((BaseObject)object5).getId()});
            }
            string = string.equals(AWNULL) ? ((CubeDimRef)object5).getDimension().getId() : string + "\\n" + ((CubeDimRef)object5).getDimension().getId();
            if (!((CubeDimRef)object5).isSparse().booleanValue()) continue;
            if (string2.equals(AWNULL)) {
                string2 = ((CubeDimRef)object5).getDimension().getId();
                continue;
            }
            string2 = string2 + "\\n" + ((CubeDimRef)object5).getDimension().getId();
        }
        if (!string.equals(AWNULL)) {
            string = "'" + string + "'";
        }
        if (!string2.equals(AWNULL)) {
            string2 = "'" + string2 + "'";
        }
        if (this.m_partitionLevel != null && this.m_partitionHierarchy != null) {
            object6 = this.quoteValue(this.m_partitionLevel.getId());
            object5 = this.quoteValue(this.m_partitionHierarchy.getId());
        } else {
            object6 = AWNULL;
            object5 = AWNULL;
        }
        String string3 = "GLOBAL";
        if (!this.m_useGlobalIndex.booleanValue()) {
            string3 = "LOCAL";
        }
        Object object7 = this.m_dimensions.iterator();
        while (object7.hasNext()) {
            object4 = (CubeDimRef)object7.next();
            object3 = ((CubeDimRef)object4).getDimension();
            boolean bl = true;
            object2 = this.m_defaultAggregation.getCalculationSpecification().iterator();
            while (object2.hasNext()) {
                object = (CalculationSpecification)object2.next();
                if (!(object instanceof AggregationHierarchySpecification) || ((AggregationHierarchySpecification)object).getDimension() != object3) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object2 = this.m_defaultAggregation.createAggregationHierarchySpecification();
            ((AggregationHierarchySpecification)object2).setDimension((Dimension)object3);
        }
        this.m_defaultAggregation.Create(aWConnection, true);
        object7 = this.m_defaultAggregation != null ? this.quoteValue(this.m_defaultAggregation.getId()) : AWNULL;
        object4 = AWNULL;
        if (this.m_sparseType != null) {
            object4 = this.quoteValue(this.m_sparseType);
        }
        object3 = AWNULL;
        if (this.m_defaultDatatype != null) {
            object3 = this.quoteValue(this.m_defaultDatatype);
        }
        String string4 = "NO";
        if (this.m_autoSolve.equalsIgnoreCase("YES")) {
            string4 = "AUTO_SOLVE";
        }
        object2 = aWConnection.executeCommand("call create_cube(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + (String)object3 + "," + (String)object4 + "," + string + "," + string2 + "," + (String)object6 + "," + (String)object5 + "," + this.quoteValue(string3) + "," + (String)object7 + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-100000", new Object[]{this.getId(), this.m_commandResultText});
        }
        object = this.m_solveDefinitions.iterator();
        while (object.hasNext()) {
            baseObject = (SolveDefinition)object.next();
            if (baseObject == this.m_defaultAggregation) continue;
            baseObject.Create(aWConnection);
        }
        object = this.m_measures.iterator();
        while (object.hasNext()) {
            baseObject = (Measure)object.next();
            ((Measure)baseObject).Create(aWConnection);
        }
        object = this.m_derivedMeasures.iterator();
        while (object.hasNext()) {
            Measure measure;
            baseObject = (BaseObject)object.next();
            if (baseObject instanceof DerivedMeasure) {
                measure = (DerivedMeasure)baseObject;
                ((DerivedMeasure)measure).Create(aWConnection);
                continue;
            }
            if (!(baseObject instanceof OlapMeasure)) continue;
            measure = (OlapMeasure)baseObject;
            ((OlapMeasure)measure).Create(aWConnection);
        }
        object = this.getSourceMapGroup().iterator();
        while (object.hasNext()) {
            baseObject = (CubeMapGroup)object.next();
            ((CubeMapGroup)baseObject).Create(aWConnection);
        }
        return "success";
    }

    public String Alter(AWConnection aWConnection) {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        if (this.m_dimensions.size() <= 0) {
            throw new AWException("AWXML-ERR-NUM-100003");
        }
        if (this.m_defaultAggregation == null) {
            throw new AWException("AWXML-ERR-NUM-100004");
        }
        String string = AWNULL;
        String string2 = AWNULL;
        Object object5 = this.m_dimensions.iterator();
        while (object5.hasNext()) {
            object4 = (CubeDimRef)object5.next();
            if (((CubeDimRef)object4).getDimension() == null) {
                throw new AWException("AWXML-ERR-NUM-100005", new Object[]{((BaseObject)object4).getId()});
            }
            string = string.equals(AWNULL) ? ((CubeDimRef)object4).getDimension().getId() : string + "\\n" + ((CubeDimRef)object4).getDimension().getId();
            if (!((CubeDimRef)object4).isSparse().booleanValue()) continue;
            if (string2.equals(AWNULL)) {
                string2 = ((CubeDimRef)object4).getDimension().getId();
                continue;
            }
            string2 = string2 + "\\n" + ((CubeDimRef)object4).getDimension().getId();
        }
        if (!string.equals(AWNULL)) {
            string = "'" + string + "'";
        }
        if (!string2.equals(AWNULL)) {
            string2 = "'" + string2 + "'";
        }
        if (this.m_partitionLevel != null && this.m_partitionHierarchy != null) {
            object5 = this.quoteValue(this.m_partitionLevel.getId());
            object4 = this.quoteValue(this.m_partitionHierarchy.getId());
        } else {
            object5 = AWNULL;
            object4 = AWNULL;
        }
        String string3 = "GLOBAL";
        if (!this.m_useGlobalIndex.booleanValue()) {
            string3 = "LOCAL";
        }
        Object object6 = this.m_dimensions.iterator();
        while (object6.hasNext()) {
            object3 = (CubeDimRef)object6.next();
            object2 = ((CubeDimRef)object3).getDimension();
            boolean bl = true;
            object = this.m_defaultAggregation.getCalculationSpecification().iterator();
            while (object.hasNext()) {
                AggregationHierarchySpecification aggregationHierarchySpecification = (AggregationHierarchySpecification)object.next();
                if (aggregationHierarchySpecification.getDimension() != object2) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            object = this.m_defaultAggregation.createAggregationHierarchySpecification();
            ((AggregationHierarchySpecification)object).setDimension((Dimension)object2);
        }
        object6 = this.m_defaultAggregation != null ? this.quoteValue(this.m_defaultAggregation.getId()) : AWNULL;
        object3 = AWNULL;
        if (this.m_sparseType != null) {
            object3 = this.quoteValue(this.m_sparseType);
        }
        object2 = AWNULL;
        if (this.m_defaultDatatype != null) {
            object2 = this.quoteValue(this.m_defaultDatatype);
        }
        String string4 = "NO";
        if (this.m_autoSolve.equalsIgnoreCase("YES")) {
            string4 = "AUTO_SOLVE";
        }
        object = aWConnection.executeCommand("call alter_cube(" + this.quoteValue(this.getId()) + "," + this.quoteValue(this.m_shortName) + "," + this.quoteValue(this.m_longName) + "," + this.quoteValue(this.m_pluralName) + "," + (String)object2 + "," + (String)object3 + "," + string + "," + string2 + "," + (String)object5 + "," + (String)object4 + "," + this.quoteValue(string3) + "," + (String)object6 + "," + this.quoteValue(string4) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-100007", new Object[]{this.getId(), this.m_commandResultText});
        }
        return "success";
    }

    public String Delete(AWConnection aWConnection) {
        String string = "success";
        string = aWConnection.executeCommand("call delete_cube(" + this.quoteValue(this.getId()) + "," + AWConnection.CommitMode + ")");
        this.m_listResults = aWConnection.getResults();
        this.m_commandResults = this.m_listResults[0];
        this.m_commandResultText = this.m_listResults[1];
        if (new Integer(this.m_commandResults) < 0) {
            throw new AWException("AWXML-ERR-NUM-100001", new Object[]{this.getId(), this.m_commandResultText});
        }
        AW aW = AW.getCurAW();
        if (aW != null) {
            MeasureFolder measureFolder;
            Iterator iterator;
            Vector vector;
            Measure measure;
            Iterator iterator2 = this.m_measures.iterator();
            while (iterator2.hasNext()) {
                measure = (Measure)iterator2.next();
                vector = aW.getMeasureFolders();
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    measureFolder = (MeasureFolder)iterator.next();
                    if (measureFolder.getMeasures().indexOf(measure) < 0) continue;
                    measureFolder.removeMeasure(measure);
                }
            }
            iterator2 = this.m_derivedMeasures.iterator();
            while (iterator2.hasNext()) {
                measure = (Measure)iterator2.next();
                vector = aW.getMeasureFolders();
                iterator = vector.iterator();
                while (iterator.hasNext()) {
                    measureFolder = (MeasureFolder)iterator.next();
                    if (measureFolder.getMeasures().indexOf(measure) < 0) continue;
                    measureFolder.removeMeasure(measure);
                }
            }
        }
        return string;
    }

    public String Rename(AWConnection aWConnection, String string) {
        try {
            String string2 = aWConnection.getPhysicalObjectName("CUBEDEF", this.getName());
            aWConnection.executeCommand("rename " + string2 + " " + string);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return "success";
    }

    public Measure findMeasure(String string) {
        Measure measure = null;
        Iterator iterator = this.m_measures.iterator();
        while (iterator.hasNext()) {
            Measure measure2 = (Measure)iterator.next();
            if (!measure2.getName().equals(string)) continue;
            measure = measure2;
            break;
        }
        return measure;
    }

    public Measure findDerivedMeasure(String string) {
        Measure measure = null;
        Iterator iterator = this.m_derivedMeasures.iterator();
        while (iterator.hasNext()) {
            Measure measure2 = (Measure)iterator.next();
            if (!measure2.getName().equals(string)) continue;
            measure = measure2;
            break;
        }
        return measure;
    }

    public void setPartitionHierarchy(Hierarchy hierarchy) {
        if (this.m_partitionLevel != null && this.m_partitionLevel.getOwner() != hierarchy.getOwner()) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.m_partitionLevel.getId(), hierarchy.getId()});
        }
        this.m_partitionHierarchy = hierarchy;
    }

    public Hierarchy getPartitionHierarchy() {
        return this.m_partitionHierarchy;
    }

    public void setPartitionLevel(Level level) {
        if (this.m_partitionHierarchy != null && this.m_partitionHierarchy.getOwner() != level.getOwner()) {
            throw new AWException("AWXML-ERR-NUM-900002", new Object[]{this.m_partitionHierarchy.getId(), level.getId()});
        }
        this.m_partitionLevel = level;
    }

    public Level getPartitionLevel() {
        return this.m_partitionLevel;
    }

    public void setUseGlobalIndex(Boolean bl) {
        this.m_useGlobalIndex = bl;
    }

    public Boolean getUseGlobalIndex() {
        return this.m_useGlobalIndex;
    }

    public void readAWDefinitions(AWConnection aWConnection, boolean bl) {
        if (!this.m_dataRead) {
            Object object;
            Object object2;
            Object object3;
            Iterator iterator;
            Object object4;
            String string;
            Object object5;
            Object object6;
            Object object7;
            Object object8;
            Object object9;
            Object object10;
            Object object11;
            Object object12;
            Object object13;
            Object object14;
            Object object15;
            Object object16;
            Object object17;
            this.m_dataRead = true;
            Vector vector = null;
            try {
                object17 = aWConnection.getPhysicalObjectName("CUBEDEF", this.getName());
                vector = aWConnection.getDimensionValues((String)object17);
                object16 = vector.iterator();
                while (object16.hasNext()) {
                    object15 = (String)object16.next();
                    object14 = AW.s_curAW.findDimension((String)object15);
                    if (object14 == null) continue;
                    object13 = this.createCubeDimRef();
                    ((CubeDimRef)object13).setDimension((Dimension)object14);
                }
            }
            catch (Exception exception) {
                System.out.println("No Dimensions specified for the cube");
            }
            object17 = this.m_dimensions.iterator();
            while (object17.hasNext()) {
                object16 = (CubeDimRef)object17.next();
                object15 = ((CubeDimRef)object16).getDimension();
                if (((BaseObject)object15).DataRead()) continue;
                ((Dimension)object15).readAWDefinitions(aWConnection, true);
            }
            aWConnection.limitDimension(AW.s_cubeListObject, "TO", this.getId());
            if (AW.s_cubeDfltHierPartObj != null && !((String)(object17 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_cubeDfltHierPartObj))).toUpperCase().equals("NA")) {
                object16 = AW.s_curAW.findDimension(this.getNamePart(1, (String)object17));
                object15 = ((Dimension)object16).FindHierarchy(this.getLogicalNamePart((String)object17));
                this.setPartitionHierarchy((Hierarchy)object15);
            }
            if (AW.s_cubeDfltLvlPartObj != null && !((String)(object17 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_cubeDfltLvlPartObj))).toUpperCase().equals("NA")) {
                object16 = AW.s_curAW.findDimension(this.getNamePart(1, (String)object17));
                object15 = ((Dimension)object16).FindLevel(this.getLogicalNamePart((String)object17));
                this.setPartitionLevel((Level)object15);
            }
            object17 = new Vector(0);
            if (AW.s_cubeSparseDimsObj != null) {
                object17 = aWConnection.getDimensionValues(AW.s_cubeSparseDimsObj);
            }
            object16 = ((Vector)object17).iterator();
            block6: while (object16.hasNext()) {
                object15 = (String)object16.next();
                object14 = AW.s_curAW.findDimension(this.getLogicalNamePart((String)object15));
                object13 = this.getCubeDimRefs().iterator();
                while (object13.hasNext()) {
                    object12 = (CubeDimRef)object13.next();
                    if (((CubeDimRef)object12).getDimension() != object14) continue;
                    ((CubeDimRef)object12).setSparse(new Boolean("TRUE"));
                    continue block6;
                }
            }
            object16 = new Vector(0);
            if (AW.s_solveDfnObj != null) {
                aWConnection.limitDimensionBasedOnData(AW.s_solveDfnObj, "TO", AW.s_solveDfnTypeObj, "EQ", "'AGGREGATIONDEFINITION'");
                object16 = aWConnection.getDimensionValues(AW.s_solveDfnObj);
            }
            object15 = ((Vector)object16).iterator();
            while (object15.hasNext()) {
                object14 = (String)object15.next();
                if (!this.m_name.equals(this.getNamePart(1, (String)object14))) continue;
                aWConnection.limitDimension(AW.s_solveDfnObj, "TO", (String)object14);
                object13 = this.createAggregationDefinition();
                ((BaseObject)object13).setId((String)object14);
                ((BaseObject)object13).setName(((BaseObject)object13).getLogicalNamePart((String)object14));
                aWConnection.getDescriptors((BaseObject)object13);
                ((BaseObject)object13).setDataRead(false);
                if (bl) {
                    ((AggregationDefinition)object13).readAWDefinitions(aWConnection, true);
                    continue;
                }
                ((BaseObject)object13).setDataRead(false);
            }
            if (AW.s_solveDfnObj != null) {
                aWConnection.limitDimensionBasedOnData(AW.s_solveDfnObj, "TO", AW.s_solveDfnTypeObj, "EQ", "'ALLOCATIONDEFINITION'");
                object16 = aWConnection.getDimensionValues(AW.s_solveDfnObj);
            } else {
                object16 = new Vector(0);
            }
            object15 = ((Vector)object16).iterator();
            while (object15.hasNext()) {
                object14 = (String)object15.next();
                if (!this.m_name.equals(this.getNamePart(1, (String)object14))) continue;
                object13 = this.createAllocationDefinition();
                ((BaseObject)object13).setId((String)object14);
                ((BaseObject)object13).setName(((BaseObject)object13).getLogicalNamePart((String)object14));
                aWConnection.getDescriptors((BaseObject)object13);
                ((BaseObject)object13).setDataRead(false);
                if (bl) {
                    ((AllocationDefinition)object13).readAWDefinitions(aWConnection, true);
                    continue;
                }
                ((BaseObject)object13).setDataRead(false);
            }
            object15 = new Vector(0);
            if (AW.s_solveDfnObj != null) {
                aWConnection.limitDimensionBasedOnData(AW.s_solveDfnObj, "TO", AW.s_solveDfnTypeObj, "EQ", "'FORECASTDEFINITION'");
                object15 = aWConnection.getDimensionValues(AW.s_solveDfnObj);
            }
            object14 = ((Vector)object15).iterator();
            while (object14.hasNext()) {
                object13 = (String)object14.next();
                if (!this.m_name.equals(this.getNamePart(1, (String)object13))) continue;
                object12 = this.createForecastDefinition();
                ((BaseObject)object12).setId((String)object13);
                ((BaseObject)object12).setName(((BaseObject)object12).getLogicalNamePart((String)object13));
                aWConnection.getDescriptors((BaseObject)object12);
                ((BaseObject)object12).setDataRead(false);
                if (bl) {
                    ((ForecastDefinition)object12).readAWDefinitions(aWConnection, true);
                    continue;
                }
                ((BaseObject)object12).setDataRead(false);
            }
            aWConnection.executeCommand("limit " + AW.getCurAW().getName() + "!" + AW.s_measureListObject + " TO " + AW.getCurAW().getName() + "!" + AW.s_cubeListObject);
            object14 = aWConnection.getDimensionValues(AW.s_measureListObject);
            object13 = ((Vector)object14).iterator();
            while (object13.hasNext()) {
                Object object18;
                Object object19;
                Object object20;
                Object object21;
                Object object22;
                Object object23;
                Object object24;
                object12 = (String)object13.next();
                aWConnection.limitDimension(AW.s_measureListObject, "TO", (String)object12);
                object11 = "BASE";
                object10 = "NA";
                object9 = "NA";
                object8 = "NA";
                Object object25 = "NA";
                object7 = "NA";
                object6 = null;
                if (AW.s_measCatalogObj != null) {
                    object5 = "limit " + AW.getCurAW().getName() + "!" + AW.s_measPropObj + " to 'DATATYPE' 'MEASTYPE' 'COMP_DFLT' 'AGGR_DFLT' 'PRT_DFLT' 'FORCECALC' 'FORCEORDER'";
                    aWConnection.executeCommand((String)object5);
                    string = aWConnection.getValue("charlist(joincols(" + AW.getCurAW().getName() + "!" + AW.s_measPropObj + " ':' " + AW.getCurAW().getName() + "!" + AW.s_measCatalogObj + "))");
                    object24 = new StringTokenizer(string, "\n");
                    while (((StringTokenizer)object24).hasMoreTokens()) {
                        object4 = ((StringTokenizer)object24).nextToken();
                        iterator = ((String)object4).substring(0, ((String)object4).indexOf(":"));
                        object3 = ((String)object4).substring(((String)object4).indexOf(":") + 1);
                        if (((String)((Object)iterator)).equalsIgnoreCase("MEASTYPE")) {
                            object11 = object3;
                        }
                        if (((String)((Object)iterator)).equalsIgnoreCase("COMP_DFLT")) {
                            object10 = object3;
                        }
                        if (((String)((Object)iterator)).equalsIgnoreCase("AGGR_DFLT")) {
                            object8 = object3;
                        }
                        if (((String)((Object)iterator)).equalsIgnoreCase("PRT_DFLT")) {
                            object9 = object3;
                        }
                        if (((String)((Object)iterator)).equalsIgnoreCase("DATATYPE")) {
                            object6 = object3;
                        }
                        if (((String)((Object)iterator)).equalsIgnoreCase("FORCECALC")) {
                            object25 = object3;
                        }
                        if (!((String)((Object)iterator)).equalsIgnoreCase("FORCEORDER")) continue;
                        object7 = object3;
                    }
                }
                if (((String)object11).toUpperCase().equals("BASE")) {
                    object5 = this.createMeasure();
                    ((BaseObject)object5).setId((String)object12);
                    ((BaseObject)object5).setName(((BaseObject)object5).getLogicalNamePart((String)object12));
                    aWConnection.getDescriptors((BaseObject)object5);
                    ((Measure)object5).setDataType((String)object6);
                    string = aWConnection.getPhysicalObjectName("MEASUREDEF", ((BaseObject)object5).getName(), this.getName());
                    ((BaseObject)object5).setColumnName(aWConnection.executeCommand("show obj(PROPERTY 'COLUMN_NAME' '" + string + "')"));
                    if (!((String)object8).equalsIgnoreCase("YES") && !((String)(object24 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_measAggregationObj))).equalsIgnoreCase("NA")) {
                        iterator = this.findAggregationDefinition((String)object24);
                        ((Measure)object5).setSolveDefinition((SolveDefinition)((Object)iterator));
                        if (!((String)object25).equalsIgnoreCase("NA")) {
                            ((Measure)object5).setForceCalc(new Boolean((String)object25));
                        }
                        if (!((String)object7).equalsIgnoreCase("NA")) {
                            ((Measure)object5).setForceOrder(new Boolean((String)object7));
                        }
                    }
                    if (((String)object10).equalsIgnoreCase("NA")) {
                        object24 = ((Cube)((BaseObject)object5).getOwner()).getCubeDimRefs().iterator();
                        while (object24.hasNext()) {
                            iterator = (CubeDimRef)object24.next();
                            object3 = ((Measure)object5).createCubeDimRef();
                            ((CubeDimRef)object3).setDimension(((CubeDimRef)((Object)iterator)).getDimension());
                        }
                        object24 = aWConnection.getDimensionValues(AW.s_measSparseDimsObj);
                        if (((Vector)object24).size() > 0) {
                            iterator = ((Vector)object24).iterator();
                            block14: while (iterator.hasNext()) {
                                object3 = (String)iterator.next();
                                object4 = AW.s_curAW.findDimension(this.getLogicalNamePart((String)object3));
                                object2 = ((Measure)object5).getCubeDimRef().iterator();
                                while (object2.hasNext()) {
                                    object = (CubeDimRef)object2.next();
                                    if (((CubeDimRef)object).getDimension() != object4) continue;
                                    ((CubeDimRef)object).setSparse(new Boolean("TRUE"));
                                    continue block14;
                                }
                            }
                        }
                    }
                    if (AW.s_mapGroupListObject == null) continue;
                    try {
                        aWConnection.limitDimension(AW.s_measureListObject, "TO", ((BaseObject)object5).getId());
                        aWConnection.limitDimensionBasedOnData(AW.s_mapGroupListObject, "TO", AW.s_mapMeasureObject, "NE", "NA");
                        object24 = aWConnection.getDimensionValues(AW.s_mapGroupListObject);
                        iterator = ((Vector)object24).iterator();
                        while (iterator.hasNext()) {
                            object3 = (String)iterator.next();
                            object4 = this.findCubeMapGroup(this.getLogicalNamePart((String)object3));
                            if (object4 == null) {
                                object4 = this.createSourceCubeMapGroup();
                            }
                            ((BaseObject)object4).setName(((BaseObject)object4).getLogicalNamePart((String)object3));
                            aWConnection.limitDimension(AW.s_mapGroupListObject, "TO", ((BaseObject)object4).getId());
                            object2 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_mapMeasureObject);
                            if (((String)object2).equalsIgnoreCase("NA")) continue;
                            object = ((CubeMapGroup)object4).CreateAttributeMap();
                            if (((String)object2).indexOf("?") > 0) {
                                object23 = ((String)object2).substring(((String)object2).indexOf("?") + 1);
                                object2 = ((String)object2).substring(0, ((String)object2).indexOf("?"));
                                object22 = ((RestrictedSourceExpression)object).createRestriction();
                                ((WhereClause)object22).setWhereClause((String)object23);
                            }
                            if (((String)object2).indexOf(",") > 0) {
                                object23 = new StringTokenizer((String)object2, ",");
                                while (((StringTokenizer)object23).hasMoreTokens()) {
                                    object22 = ((StringTokenizer)object23).nextToken();
                                    object21 = ((ExternalSourceExpression)object).CreateSourceColumn();
                                    ((SourceColumn)object21).setColumn((String)object22);
                                }
                            } else {
                                object23 = ((ExternalSourceExpression)object).CreateSourceColumn();
                                ((SourceColumn)object23).setColumn((String)object2);
                            }
                            ((ExternalSourceExpression)object).setTargetObject((BaseObject)object5);
                        }
                        continue;
                    }
                    catch (Exception exception) {
                        continue;
                    }
                }
                string = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_measCatalogObj + "(" + AW.s_measPropObj + " 'KEYWORD')");
                object24 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_measCatalogObj + "(" + AW.s_measPropObj + " 'VALUE')");
                iterator = new StringTokenizer(string, "\n");
                object3 = new StringTokenizer((String)object24, "\n");
                object4 = null;
                object2 = null;
                object = null;
                object23 = null;
                object22 = null;
                object21 = null;
                Object object26 = null;
                Object object27 = null;
                Object object28 = null;
                Object object29 = null;
                Object object30 = null;
                Object object31 = null;
                Object object32 = null;
                while (((StringTokenizer)((Object)iterator)).hasMoreTokens()) {
                    object20 = ((StringTokenizer)((Object)iterator)).nextToken();
                    object19 = ((StringTokenizer)object3).nextToken();
                    if (((String)object20).toUpperCase().equals("BEANSTEXT")) {
                        object4 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("BEANSINPUT") && ((String)(object2 = object19)).indexOf("'") > 0) {
                        object2 = object18 = ((String)object2).replaceAll("'", "\\\\'");
                    }
                    if (((String)object20).toUpperCase().equals("EXPRESSION")) {
                        object = object19;
                    }
                    if (((String)object20).toUpperCase().equals("DATATYPE")) {
                        object23 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("DIMENSION")) {
                        object22 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("MEASURE")) {
                        object27 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("HIERARCHY")) {
                        object26 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("LEVEL")) {
                        object21 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("OFFSET")) {
                        object28 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("START")) {
                        object29 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("STOP")) {
                        object30 = object19;
                    }
                    if (((String)object20).toUpperCase().equals("STEP")) {
                        object31 = object19;
                    }
                    if (!((String)object20).toUpperCase().equals("OPERATION")) continue;
                    object32 = object19;
                }
                object20 = object11;
                if (((String)object20).toUpperCase().equals("GENERIC") || object4 != null) {
                    object5 = this.createDerivedMeasure();
                    if (object4 != null) {
                        ((Measure)object5).setBIBeansDefinition((String)object4);
                    }
                    if (object2 != null) {
                        ((DerivedMeasure)object5).setBeanInput((String)object2);
                    }
                    if (object != null) {
                        ((DerivedMeasure)object5).setExpressionText((String)object);
                    }
                    if (object23 != null) {
                        ((DerivedMeasure)object5).setDataType((String)object23);
                    }
                } else {
                    BaseObject baseObject;
                    object5 = this.createOlapMeasure();
                    ((OlapMeasure)object5).setOlapOperator(((String)object20).toUpperCase());
                    if (object22 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("DIMENSION");
                        object18 = AW.s_curAW.findDimension(this.getLogicalNamePart((String)object22));
                        ((OlapMeasureInput)object19).setReferencedObj((BaseObject)object18);
                    }
                    if (object27 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("MEASURE");
                        object18 = AW.s_curAW.findCube(this.getNamePart(1, (String)object27));
                        baseObject = ((Cube)object18).findMeasure(((BaseObject)object18).getLogicalNamePart((String)object27));
                        if (baseObject == null) {
                            baseObject = ((Cube)object18).findDerivedMeasure(((BaseObject)object18).getLogicalNamePart((String)object27));
                        }
                        ((OlapMeasureInput)object19).setReferencedObj(baseObject);
                    }
                    if (object26 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("HIERARCHY");
                        object18 = AW.s_curAW.findDimension(this.getNamePart(1, (String)object26));
                        baseObject = ((Dimension)object18).FindHierarchy(((BaseObject)object18).getLogicalNamePart((String)object26));
                        ((OlapMeasureInput)object19).setReferencedObj(baseObject);
                    }
                    if (object21 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("LEVEL");
                        object18 = AW.s_curAW.findDimension(this.getNamePart(1, (String)object21));
                        baseObject = ((Dimension)object18).FindLevel(((BaseObject)object18).getLogicalNamePart((String)object21));
                        ((OlapMeasureInput)object19).setReferencedObj(baseObject);
                    }
                    if (object28 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("OFFSET");
                        ((OlapMeasureInput)object19).setScalarValue((String)object28);
                    }
                    if (object29 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("START");
                        ((OlapMeasureInput)object19).setScalarValue((String)object29);
                    }
                    if (object30 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("STOP");
                        ((OlapMeasureInput)object19).setScalarValue((String)object30);
                    }
                    if (object31 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("STEP");
                        ((OlapMeasureInput)object19).setScalarValue((String)object31);
                    }
                    if (object32 != null) {
                        object19 = ((OlapMeasure)object5).createOlapMeasureInput();
                        ((OlapMeasureInput)object19).setKeyWord("OPERATION");
                        ((OlapMeasureInput)object19).setScalarValue((String)object32);
                    }
                }
                ((BaseObject)object5).setId((String)object12);
                ((BaseObject)object5).setName(((BaseObject)object5).getLogicalNamePart((String)object12));
                aWConnection.getDescriptors((BaseObject)object5);
                if (AW.s_visibleObj == null) continue;
                aWConnection.limitDimension(AW.s_allObjectsObj, "TO", (String)object12);
                object19 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_visibleObj);
                object18 = "TRUE";
                if (((String)object19).equalsIgnoreCase("NO")) {
                    object18 = "FALSE";
                }
                if (object5 instanceof DerivedMeasure) {
                    ((DerivedMeasure)object5).setIsValid((String)object18);
                    continue;
                }
                ((OlapMeasure)object5).setIsValid((String)object18);
            }
            object13 = this.getSourceMapGroup().iterator();
            while (object13.hasNext()) {
                object12 = (CubeMapGroup)object13.next();
                aWConnection.limitDimension(AW.s_mapGroupListObject, "TO", ((BaseObject)object12).getId());
                object11 = AW.s_allLevelsObject;
                object10 = aWConnection.getUsageBasedObjectName("EXTENSIONS", null, "MEAS_KEY_MAP");
                aWConnection.limitDimensionBasedOnData((String)object11, "TO", (String)object10, "NE", "NA");
                object9 = aWConnection.getDimensionValues((String)object11);
                object8 = aWConnection.getValues((String)object10);
                for (int i = 0; i < ((Vector)object9).size(); ++i) {
                    object7 = (String)((Vector)object8).elementAt(i);
                    object6 = (String)((Vector)object9).elementAt(i);
                    object5 = ((BaseObject)object12).getNamePart(1, (String)object6);
                    string = ((BaseObject)object12).getLogicalNamePart((String)object6);
                    boolean bl2 = false;
                    iterator = ((CubeMapGroup)object12).getKeyMaps().iterator();
                    while (iterator.hasNext()) {
                        object3 = (CubeDimensionSourceExpression)iterator.next();
                        object4 = null;
                        object2 = ((ExternalSourceExpression)object3).getSourceColumns().iterator();
                        while (object2.hasNext()) {
                            object = (SourceColumn)object2.next();
                            if (((SourceColumn)object).getColumn() == null) continue;
                            if (object4 != null) {
                                object4 = "," + ((SourceColumn)object).getColumn();
                                continue;
                            }
                            object4 = ((SourceColumn)object).getColumn();
                        }
                        if (object4 == null || !((String)object4).equalsIgnoreCase((String)object7)) continue;
                        bl2 = true;
                        object2 = AW.s_curAW.findDimension((String)object5).FindLevel(string);
                        if (object2 != null) {
                            ((CubeDimensionSourceExpression)object3).addLevel((Level)object2);
                            break;
                        }
                        ((CubeDimensionSourceExpression)object3).setDimension(AW.s_curAW.findDimension((String)object5));
                        break;
                    }
                    if (bl2) continue;
                    iterator = ((CubeMapGroup)object12).CreateKeyMap();
                    if (((String)object7).indexOf("?") > 0) {
                        object3 = ((String)object7).substring(((String)object7).indexOf("?") + 1);
                        object7 = ((String)object7).substring(0, ((String)object7).indexOf("?"));
                        object4 = ((RestrictedSourceExpression)((Object)iterator)).createRestriction();
                        ((WhereClause)object4).setWhereClause((String)object3);
                    }
                    if (((String)object7).indexOf(",") > 0) {
                        object3 = new StringTokenizer((String)object7, ",");
                        while (((StringTokenizer)object3).hasMoreTokens()) {
                            object4 = ((StringTokenizer)object3).nextToken();
                            object2 = ((ExternalSourceExpression)((Object)iterator)).CreateSourceColumn();
                            ((SourceColumn)object2).setColumn((String)object4);
                        }
                    } else {
                        object3 = ((ExternalSourceExpression)((Object)iterator)).CreateSourceColumn();
                        ((SourceColumn)object3).setColumn((String)object7);
                    }
                    if ((object3 = AW.s_curAW.findDimension((String)object5).FindLevel(string)) != null) {
                        ((CubeDimensionSourceExpression)((Object)iterator)).addLevel((Level)object3);
                        continue;
                    }
                    ((CubeDimensionSourceExpression)((Object)iterator)).setDimension(AW.s_curAW.findDimension((String)object5));
                }
            }
            if (AW.s_cubeDfltAggregationObj != null && !((String)(object13 = aWConnection.getValue(AW.getCurAW().getName() + "!" + AW.s_cubeDfltAggregationObj))).toUpperCase().equals("NA")) {
                object12 = this.findAggregationDefinition((String)object13);
                this.setDefaultAggregationDefinition((AggregationDefinition)object12);
            }
        }
    }

    public ForecastDefinition createForecastDefinition() {
        ForecastDefinition forecastDefinition = new ForecastDefinition(this);
        this.addSolveDefinition(forecastDefinition);
        return forecastDefinition;
    }

    public AllocationDefinition createAllocationDefinition() {
        AllocationDefinition allocationDefinition = new AllocationDefinition(this);
        this.addSolveDefinition(allocationDefinition);
        return allocationDefinition;
    }

    public AggregationDefinition createAggregationDefinition() {
        AggregationDefinition aggregationDefinition = new AggregationDefinition(this);
        this.addSolveDefinition(aggregationDefinition);
        return aggregationDefinition;
    }

    public void addSolveDefinition(SolveDefinition solveDefinition) {
        this.m_solveDefinitions.add(solveDefinition);
        solveDefinition.setOwner(this);
    }

    public void removeSolveDefinition(SolveDefinition solveDefinition) {
        this.m_solveDefinitions.remove(solveDefinition);
    }

    public Vector getSolveDefinitions() {
        return this.m_solveDefinitions;
    }

    public AggregationDefinition findAggregationDefinition(String string) {
        AggregationDefinition aggregationDefinition = null;
        Iterator iterator = this.m_solveDefinitions.iterator();
        while (iterator.hasNext()) {
            SolveDefinition solveDefinition = (SolveDefinition)iterator.next();
            if (!solveDefinition.getName().equals(this.getLogicalNamePart(string))) continue;
            aggregationDefinition = (AggregationDefinition)solveDefinition;
            break;
        }
        return aggregationDefinition;
    }

    public AllocationDefinition findAllocationDefinition(String string) {
        AllocationDefinition allocationDefinition = null;
        Iterator iterator = this.m_solveDefinitions.iterator();
        while (iterator.hasNext()) {
            SolveDefinition solveDefinition = (SolveDefinition)iterator.next();
            if (!solveDefinition.getName().equals(this.getLogicalNamePart(string))) continue;
            allocationDefinition = (AllocationDefinition)solveDefinition;
            break;
        }
        return allocationDefinition;
    }

    public ForecastDefinition findForecastDefinition(String string) {
        ForecastDefinition forecastDefinition = null;
        Iterator iterator = this.m_solveDefinitions.iterator();
        while (iterator.hasNext()) {
            SolveDefinition solveDefinition = (SolveDefinition)iterator.next();
            if (!solveDefinition.getName().equals(this.getLogicalNamePart(string))) continue;
            forecastDefinition = (ForecastDefinition)solveDefinition;
            break;
        }
        return forecastDefinition;
    }

    public boolean validateName(String string, BaseObject baseObject) {
        boolean bl = true;
        Iterator iterator = null;
        if (baseObject instanceof Measure) {
            iterator = this.m_measures.iterator();
        }
        if (baseObject instanceof DerivedMeasure) {
            iterator = this.m_derivedMeasures.iterator();
        }
        if (baseObject instanceof SolveDefinition) {
            iterator = this.m_solveDefinitions.iterator();
        }
        if (iterator != null) {
            Iterator iterator2 = iterator;
            while (iterator2.hasNext()) {
                BaseObject baseObject2 = (BaseObject)iterator2.next();
                if (!baseObject2.getName().equalsIgnoreCase(string)) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    public void setPersisted(boolean bl) {
        this.m_persisted = bl;
    }

    public boolean isPersisted() {
        return this.m_persisted;
    }
}

