/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWXML;

import java.io.Writer;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.AWXML.AW;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.express.spl.NAValueException;
import oracle.express.spl.SPLExecutor;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OracleDriver;
import oracle.sql.CLOB;

public class AWConnection {
    private String m_user = null;
    private String m_pwd = null;
    private String m_connectString = null;
    private OracleConnection m_Connection;
    private SPLExecutor m_splExecutor;
    private String[] m_listResults;
    private String m_stringResults;
    private String m_expressCommand;
    private String m_commandResults;
    private String m_commandResultText;
    private int m_intResults;
    private boolean m_bIsUsingLongArgs;
    public static String CommitMode = "FALSE";
    public static long m_timeInReadDescriptions = 0L;
    public static long m_timeIngetUsageBasedObjectName = 0L;
    public static long m_timeInGetRoleBaseObjectName = 0L;

    public AWConnection() {
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            this.m_Connection = (OracleConnection)DriverManager.getConnection("jdbc:default:connection");
            this.m_splExecutor = new SPLExecutor(this.m_Connection);
            this.m_splExecutor.initialize();
            this.m_commandResults = this.m_splExecutor.executeCommand("aw attach sys.awxml last");
            this.m_bIsUsingLongArgs = this.bLongArgExists();
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public AWConnection(String string, String string2, String string3) {
        this.m_user = string;
        this.m_connectString = string3;
        try {
            DriverManager.registerDriver((Driver)new OracleDriver());
            String string4 = string3.indexOf(":") < 0 ? "jdbc:oracle:oci:@" + string3 : "jdbc:oracle:thin:@" + string3;
            this.m_Connection = (OracleConnection)DriverManager.getConnection(string4, string, string2);
            this.m_splExecutor = new SPLExecutor(this.m_Connection);
            this.m_splExecutor.initialize();
            this.m_commandResults = this.m_splExecutor.executeCommand("aw attach sys.awxml last");
            this.m_bIsUsingLongArgs = this.bLongArgExists();
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public AWConnection(OracleConnection oracleConnection) {
        try {
            this.m_Connection = oracleConnection;
            this.m_splExecutor = new SPLExecutor(this.m_Connection);
            this.m_splExecutor.initialize();
            this.m_commandResults = this.m_splExecutor.executeCommand("aw attach sys.awxml last");
            this.m_bIsUsingLongArgs = this.bLongArgExists();
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public String getUserId() {
        String string = null;
        try {
            string = this.m_Connection.getUserName();
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string;
    }

    public String executeCommand(String string) {
        try {
            this.m_expressCommand = string;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            if (this.m_commandResults != null && this.m_commandResults.indexOf("\n") > 0 && this.m_commandResults.indexOf("\n") == this.m_commandResults.length() - 1) {
                this.m_commandResults = this.m_commandResults.substring(0, this.m_commandResults.indexOf("\n"));
            }
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return this.m_commandResults;
    }

    public String deleteObj(String string) {
        try {
            this.m_expressCommand = "delete " + AW.getCurAW().getName() + "!" + string;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            System.out.println("delete command failed: " + this.m_expressCommand);
        }
        return this.m_commandResults;
    }

    public String attachDatabase(String string, String string2) {
        if (string2 == null) {
            string2 = "ro";
        }
        try {
            this.m_expressCommand = "aw attach " + string + string2;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return this.m_commandResults;
    }

    public Vector getDimensionValues(String string) {
        Vector<Object> vector = null;
        try {
            this.m_listResults = null;
            try {
                this.m_listResults = this.m_splExecutor.evaluateStringListExpression("values(" + AW.getCurAW().getName() + "!" + string + ")");
            }
            catch (Exception exception) {
                this.m_listResults = null;
            }
            vector = this.m_listResults == null ? new Vector(0) : new Vector<String>(Arrays.asList(this.m_listResults));
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return vector;
    }

    public Vector getIntegerDimensionValues(String string) {
        Vector<Object> vector = null;
        try {
            this.m_listResults = null;
            try {
                this.m_listResults = this.m_splExecutor.evaluateStringListExpression("charlist(" + AW.getCurAW().getName() + "!" + string + ")");
            }
            catch (Exception exception) {
                this.m_listResults = null;
            }
            vector = this.m_listResults == null ? new Vector(0) : new Vector<String>(Arrays.asList(this.m_listResults));
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return vector;
    }

    public String getRoleBasedObjectName(String string, String string2) {
        Date date = new Date();
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$ROLE') eq '" + string + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$PARENT_NAME') eq '" + string2.toUpperCase() + "'";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            this.m_stringResults = this.m_splExecutor.evaluateStringExpression("name");
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        Date date2 = new Date();
        m_timeInGetRoleBaseObjectName += date2.getTime() - date.getTime();
        return this.m_stringResults;
    }

    public String getUsageBasedObjectName(String string, String string2, String string3) {
        Date date = new Date();
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$CLASS') eq '" + string + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$ROLE') eq '" + string3 + "'";
            if (string2 != null) {
                this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$PARENT_NAME') eq '" + string2.toUpperCase() + "'";
            }
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            this.m_stringResults = this.m_splExecutor.evaluateStringExpression("name");
        }
        catch (Exception exception) {
            System.out.println("Error occured: " + exception.getMessage());
            try {
                if (string.equals("CATALOGS")) {
                    string = "CATALOG";
                }
                if (string.equals("EXTENSIONS")) {
                    string = "EXTENSION";
                }
                this.m_expressCommand = "limit name to obj(property 'AW$CLASS') eq '" + string + "'";
                this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
                this.m_expressCommand = "limit name keep obj(property 'AW$ROLE') eq '" + string3 + "'";
                this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
                if (string2 != null) {
                    this.m_expressCommand = "limit name keep obj(property 'AW$PARENT_NAME') eq '" + string2.toUpperCase() + "'";
                    this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
                }
                this.m_stringResults = this.m_splExecutor.evaluateStringExpression("name");
            }
            catch (Exception exception2) {
                this.m_stringResults = null;
            }
        }
        Date date2 = new Date();
        m_timeIngetUsageBasedObjectName += date2.getTime() - date.getTime();
        return this.m_stringResults;
    }

    public void addDimensionValue(String string, String string2) {
        try {
            this.m_expressCommand = "maintain " + AW.getCurAW().getName() + "!" + string + " merge " + this.quoteValue(string2);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void deleteDimensionValue(String string, String string2) {
        try {
            this.m_expressCommand = "maintain " + AW.getCurAW().getName() + "!" + string + " delete " + this.quoteValue(string2);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void limitDimension(String string, String string2, Vector vector) {
        try {
            this.m_expressCommand = "limit " + AW.getCurAW().getName() + "!" + string + " " + string2 + " ";
            Iterator iterator = vector.iterator();
            while (iterator.hasNext()) {
                String string3 = (String)iterator.next();
                this.m_expressCommand = this.m_expressCommand + " " + this.quoteValue(string3);
            }
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void limitDimension(String string, String string2, String string3) {
        try {
            this.m_expressCommand = "limit " + AW.getCurAW().getName() + "!" + string + " " + string2 + " ";
            this.m_expressCommand = this.m_expressCommand + " " + this.quoteValue(string3);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void limitDimension(String string, String string2, int n) {
        try {
            this.m_expressCommand = "limit " + AW.getCurAW().getName() + "!" + string + " " + string2 + " ";
            this.m_expressCommand = this.m_expressCommand + " " + n;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void limitDimensionBasedOnData(String string, String string2, String string3, String string4, String string5) {
        try {
            this.m_expressCommand = "limit " + AW.getCurAW().getName() + "!" + string + " " + string2 + " ";
            this.m_expressCommand = this.m_expressCommand + " " + AW.getCurAW().getName() + "!" + string3;
            this.m_expressCommand = this.m_expressCommand + " " + string4 + " " + string5;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            System.out.println("no values found for dimension: " + string);
        }
    }

    public void limitDimensionBasedOnStringData(String string, String string2, String string3, String string4, String string5) {
        try {
            this.m_expressCommand = "limit " + AW.getCurAW().getName() + "!" + string + " " + string2 + " ";
            this.m_expressCommand = this.m_expressCommand + " " + AW.getCurAW().getName() + "!" + string3;
            this.m_expressCommand = this.m_expressCommand + " " + string4 + " " + this.quoteValue(string5);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void limitValueSet(String string, String string2) {
        try {
            this.m_expressCommand = "limit " + AW.getCurAW().getName() + "!" + string + " to " + AW.getCurAW().getName() + "!" + string2;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void setValue(String string, String string2) {
        try {
            this.m_expressCommand = string2.equals("NA") ? AW.getCurAW().getName() + "!" + string + " = " + string2 : AW.getCurAW().getName() + "!" + string + " = " + this.quoteValue(string2);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void setCatalogValue(String string, String string2) {
        try {
            this.m_expressCommand = AW.getCurAW().getName() + "!" + string + " = " + string2;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void setValue(String string, int n) {
        String string2 = new Integer(n).toString();
        try {
            this.m_expressCommand = AW.getCurAW().getName() + "!" + string + " = " + this.quoteValue(string2);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public void setValue(String string, boolean bl) {
        String string2 = new Boolean(bl).toString();
        try {
            this.m_expressCommand = AW.getCurAW().getName() + "!" + string + " = " + string2;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public String getValue(String string) {
        try {
            this.m_expressCommand = "show " + string;
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            if (this.m_commandResults.indexOf("\n") > 0 && this.m_commandResults.indexOf("\n") == this.m_commandResults.length() - 1) {
                this.m_commandResults = this.m_commandResults.substring(0, this.m_commandResults.indexOf("\n"));
            }
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return this.m_commandResults;
    }

    public String getCatalogValue(String string, String string2, String string3) {
        try {
            this.m_expressCommand = "show " + AW.getCurAW().getName() + "!" + string + "(" + AW.getCurAW().getName() + "!" + string2 + " '" + string3 + "')";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return this.m_commandResults;
    }

    public Vector getValues(String string) {
        try {
            this.m_expressCommand = "charlist(" + AW.getCurAW().getName() + "!" + string + ")";
            this.m_listResults = this.m_splExecutor.evaluateStringListExpression(this.m_expressCommand);
        }
        catch (NAValueException nAValueException) {
            this.m_listResults = null;
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        Vector<Object> vector = this.m_listResults == null ? new Vector(0) : new Vector<String>(Arrays.asList(this.m_listResults));
        return vector;
    }

    private String quoteValue(String string) {
        return "'" + string + "'";
    }

    public void close() {
        try {
            this.m_Connection.close();
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public String ExecuteInteraction(String string) {
        String string2 = null;
        try {
            CLOB cLOB = CLOB.createTemporary((Connection)this.m_Connection, (boolean)true, (int)10);
            Writer writer = cLOB.getCharacterOutputStream();
            writer.write(string);
            writer.flush();
            CallableStatement callableStatement = this.m_Connection.prepareCall("{? = call sys.InteractionExecute(?)}");
            callableStatement.setClob(2, (Clob)cLOB);
            callableStatement.registerOutParameter(1, 12);
            callableStatement.executeUpdate();
            string2 = callableStatement.getString(1);
        }
        catch (SQLException sQLException) {
            throw new AWException(sQLException);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string2;
    }

    public void renameDimensionValue(String string, String string2, String string3) {
        try {
            this.m_expressCommand = "maintain " + AW.getCurAW().getName() + "!" + string + " rename " + this.quoteValue(string2) + " " + this.quoteValue(string3);
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public String getLogicalObjectName(String string) {
        String string2 = null;
        try {
            this.m_expressCommand = "obj(property 'AW$LOGICAL_NAME' '" + string + "')";
            string2 = this.m_commandResults = this.m_splExecutor.evaluateStringExpression(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string2;
    }

    public String getLogicalParentObjectName(String string) {
        String string2 = null;
        try {
            this.m_expressCommand = "show obj(property 'AW$PARENT_NAME' '" + string + "')";
            string2 = this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string2;
    }

    public String getPhysicalObjectName(String string, String string2) {
        String string3 = null;
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$ROLE') eq '" + string + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$LOGICAL_NAME') eq '" + string2.toUpperCase() + "'";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            string3 = this.m_stringResults = this.m_splExecutor.evaluateStringExpression("name");
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string3;
    }

    public String getPhysicalObjectName(String string, String string2, String string3) {
        String string4 = null;
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$ROLE') eq '" + string + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$PARENT_NAME') eq '" + string3 + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$LOGICAL_NAME') eq '" + string2.toUpperCase() + "'";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            string4 = this.m_stringResults = this.m_splExecutor.evaluateStringExpression("name");
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string4;
    }

    public Vector getRoleBasedObjects(String string) {
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$ROLE') eq '" + string + "'";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            this.m_listResults = this.m_splExecutor.evaluateStringListExpression("values(name)");
        }
        catch (Exception exception) {
            this.m_listResults = null;
        }
        Vector<Object> vector = this.m_listResults != null ? new Vector<String>(Arrays.asList(this.m_listResults)) : new Vector(0);
        return vector;
    }

    public Vector getRoleBasedObjects(String string, String string2) {
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$ROLE') eq '" + string + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$PARENT_NAME') eq '" + string2 + "'";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            this.m_listResults = this.m_splExecutor.evaluateStringListExpression("values(name)");
        }
        catch (Exception exception) {
            this.m_listResults = null;
        }
        Vector<Object> vector = this.m_listResults != null ? new Vector<String>(Arrays.asList(this.m_listResults)) : new Vector(0);
        return vector;
    }

    public Vector getRoleBasedDimVals(String string, String string2) {
        this.m_listResults = null;
        try {
            this.m_expressCommand = "limit name to obj(property 'AW$ROLE') eq '" + string + "'";
            this.m_expressCommand = this.m_expressCommand + ";limit name keep obj(property 'AW$PARENT_NAME') eq '" + string2 + "'";
            this.m_commandResults = this.m_splExecutor.executeCommand(this.m_expressCommand);
            this.m_stringResults = this.m_splExecutor.evaluateStringExpression("name");
            this.m_listResults = this.m_splExecutor.evaluateStringListExpression("values( " + this.m_stringResults + ")");
        }
        catch (Exception exception) {
            this.m_listResults = null;
        }
        Vector<Object> vector = this.m_listResults == null ? new Vector(0) : new Vector<String>(Arrays.asList(this.m_listResults));
        return vector;
    }

    public String evaluateStringExpression(String string) {
        String string2 = null;
        try {
            string2 = this.m_commandResults = this.m_splExecutor.evaluateStringExpression(string);
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return string2;
    }

    public String[] getResults() {
        try {
            this.m_listResults = this.m_splExecutor.evaluateStringListExpression("joinlines(nafill(convert(___xml_retcode text), '0') nafill(___xml_errortext, '0'))");
        }
        catch (Exception exception) {
            throw new AWException("AWXML-ERR-NUM-900008", exception);
        }
        return this.m_listResults;
    }

    public void getDescriptors(BaseObject baseObject) {
        try {
            if (AW.getCurAW().getMetaDataFormat() <= 10.1) {
                Date date = new Date();
                String string = AW.getCurAW().getName() + "!" + AW.s_allObjectsObj;
                String string2 = AW.getCurAW().getName() + "!" + AW.s_allDescTypes;
                String string3 = AW.getCurAW().getName() + "!" + AW.s_allDescriptions;
                this.m_expressCommand = "joinlines(nafill(" + string3 + "(" + string + " '" + baseObject.getId() + "'" + " " + string2 + " 'SHORT'),'NA') " + "nafill(" + string3 + "(" + string + " '" + baseObject.getId() + "'" + " " + string2 + " 'LONG'),'NA') " + "nafill(" + string3 + "(" + string + " '" + baseObject.getId() + "'" + " " + string2 + " 'PLURAL'),'NA'))";
                this.m_listResults = this.m_splExecutor.evaluateStringListExpression(this.m_expressCommand);
                if (!this.m_listResults[0].equalsIgnoreCase("NA")) {
                    baseObject.setShortName(this.m_listResults[0]);
                }
                if (!this.m_listResults[1].equalsIgnoreCase("NA")) {
                    baseObject.setLongName(this.m_listResults[1]);
                }
                if (!this.m_listResults[2].equalsIgnoreCase("NA")) {
                    baseObject.setPluralName(this.m_listResults[2]);
                }
                Date date2 = new Date();
                m_timeInReadDescriptions += date2.getTime() - date.getTime();
            } else {
                String string = this.executeCommand("show get_lng_property('" + baseObject.getId() + "')");
                StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
                String string4 = stringTokenizer.nextToken();
                String string5 = stringTokenizer.nextToken();
                String string6 = stringTokenizer.nextToken();
                baseObject.setShortName(string4.substring(2));
                baseObject.setLongName(string5.substring(2));
                baseObject.setPluralName(string6.substring(2));
            }
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
    }

    public AWConnection getNewConnection() {
        return new AWConnection(this.m_user, this.m_pwd, this.m_connectString);
    }

    public boolean isConnectionParallelizable() {
        boolean bl = false;
        if (this.m_user != null && this.m_pwd != null && this.m_connectString != null) {
            bl = true;
        }
        return bl;
    }

    public Vector getLoadCatalogEntries() {
        Vector<Object> vector = null;
        try {
            this.m_listResults = null;
            try {
                this.m_listResults = this.m_splExecutor.evaluateStringListExpression("values(___XML_LD_ENT)");
            }
            catch (Exception exception) {
                this.m_listResults = null;
            }
            vector = this.m_listResults == null ? new Vector(0) : new Vector<String>(Arrays.asList(this.m_listResults));
        }
        catch (Exception exception) {
            throw new AWException(exception);
        }
        return vector;
    }

    public Connection getSQLConnection() {
        return this.m_Connection;
    }

    private boolean bLongArgExists() {
        this.m_commandResults = this.m_splExecutor.executeCommand("show exists('sys.awxml!___xml_long_arg_value')");
        return this.m_commandResults.trim().equalsIgnoreCase("YES");
    }

    public boolean isUsingLongArgProcessing() {
        return this.m_bIsUsingLongArgs;
    }
}

