/*
 * Decompiled with CFR 0.152.
 */
package oracle.AWAction;

import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.AWAction.AWAction;
import oracle.AWAction.Interaction;
import oracle.AWXML.AW;
import oracle.AWXML.AWConnection;
import oracle.AWXML.AWException;
import oracle.AWXML.BaseObject;
import oracle.AWXML.SolveGroup;

public class BuildDatabase
extends AWAction {
    private String m_buildType = "EXECUTE";
    private Vector m_buildList = new Vector(0);
    private boolean m_cleanMeasures = false;
    private boolean m_cleanAttrs = false;
    private boolean m_cleanDim = false;
    private boolean m_runSolve = true;
    private boolean m_trackStatus = false;
    private String m_AWName;
    private int m_maxJobQueues = 0;
    private GregorianCalendar m_startDate = null;

    public BuildDatabase() {
    }

    public BuildDatabase(Interaction interaction) {
        super(interaction);
    }

    public void setMaxJobQueues(String string) {
        this.m_maxJobQueues = new Integer(string);
    }

    public void setMaxJobQueues(int n) {
        this.m_maxJobQueues = n;
    }

    public int getMaxJobQueues() {
        return this.m_maxJobQueues;
    }

    public void setBuildStartDate(String string) {
        this.m_startDate = new GregorianCalendar();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ":");
        int n = 1;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (n == 1) {
                this.m_startDate.set(1, new Integer(string2));
            }
            if (n == 2) {
                this.m_startDate.set(2, new Integer(string2));
            }
            if (n == 3) {
                this.m_startDate.set(5, new Integer(string2));
            }
            if (n == 4) {
                this.m_startDate.set(11, new Integer(string2));
            }
            if (n == 5) {
                this.m_startDate.set(12, new Integer(string2));
            }
            ++n;
        }
    }

    public void setBuildStartDate(GregorianCalendar gregorianCalendar) {
        this.m_startDate = gregorianCalendar;
    }

    public GregorianCalendar getBuildStartDate() {
        return this.m_startDate;
    }

    public void setActiveObject(BaseObject baseObject) {
        if (baseObject instanceof AW) {
            this.m_activeObject = baseObject;
        }
    }

    public void setAWName(String string) {
        this.m_AWName = string;
    }

    public String getAWName() {
        return this.m_AWName;
    }

    public void setBuildType(String string) {
        this.m_buildType = string;
    }

    public String getBuildType() {
        return this.m_buildType;
    }

    public void addBuildList(BaseObject baseObject) {
        this.m_buildList.add(baseObject);
    }

    public void removeBuildList(BaseObject baseObject) {
        this.m_buildList.remove(baseObject);
    }

    public Vector getBuildList() {
        return this.m_buildList;
    }

    public String WriteToXML() {
        String string = null;
        string = BuildDatabase.TAB() + this.WriteElementStart("BuildDatabase");
        string = string + this.WriteAttributesToXML();
        ++s_Indent;
        String string2 = this.WriteContentsToXML();
        --s_Indent;
        if (string2 == null) {
            string = string + s_EndElementTag + s_NEWLINE;
        } else {
            string = string + s_EndTag + s_NEWLINE;
            string = string + string2;
            string = string + BuildDatabase.TAB() + this.WriteElementEndTag("BuildDatabase") + s_NEWLINE;
        }
        return string;
    }

    public String WriteAttributesToXML() {
        String string = null;
        string = super.WriteAttributesToXML();
        if (this.m_activeObject != null) {
            string = string == null ? this.WriteAsAttribute("AWName", this.m_activeObject.getName()) : string + this.WriteAsAttribute("AWName", this.m_activeObject.getName());
        } else if (this.m_AWName != null) {
            string = string == null ? this.WriteAsAttribute("AWName", this.m_AWName) : string + this.WriteAsAttribute("AWName", this.m_AWName);
        }
        if (string != null) {
            string = string + this.WriteAsAttribute("BuildType", this.m_buildType);
            string = string + this.WriteAsAttribute("RunSolve", new Boolean(this.m_runSolve).toString());
            string = string + this.WriteAsAttribute("CleanMeasures", new Boolean(this.m_cleanMeasures).toString());
            string = string + this.WriteAsAttribute("CleanAttrs", new Boolean(this.m_cleanAttrs).toString());
            string = string + this.WriteAsAttribute("CleanDim", new Boolean(this.m_cleanDim).toString());
            string = string + this.WriteAsAttribute("TrackStatus", new Boolean(this.m_trackStatus).toString());
            string = string + this.WriteAsAttribute("MaxJobQueues", new Integer(this.m_maxJobQueues).toString());
            if (this.m_startDate != null) {
                String string2 = this.m_startDate.get(1) + ":" + this.m_startDate.get(2) + ":" + this.m_startDate.get(5) + ":" + this.m_startDate.get(11) + ":" + this.m_startDate.get(12);
                string = string + this.WriteAsAttribute("BuildStartDate", string2);
            }
        }
        return string;
    }

    public String WriteContentsToXML() {
        String string = null;
        string = super.WriteContentsToXML();
        Iterator iterator = this.m_buildList.iterator();
        while (iterator.hasNext()) {
            BaseObject baseObject = (BaseObject)iterator.next();
            if (string == null) {
                string = this.WriteAsIDRef("BuildList", baseObject);
                continue;
            }
            string = string + this.WriteAsIDRef("BuildList", baseObject);
        }
        return string;
    }

    public void Execute() {
        try {
            Object object;
            Object object2;
            String string = "NA";
            String string2 = "NA";
            boolean bl = this.m_owner.getConnection().isUsingLongArgProcessing();
            if (bl) {
                object2 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(NA,1)");
                this.m_listResults = this.m_owner.getConnection().getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) < 0) {
                    throw new AWException(this.m_commandResultText);
                }
                object2 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(NA,2)");
                this.m_listResults = this.m_owner.getConnection().getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) < 0) {
                    throw new AWException(this.m_commandResultText);
                }
            }
            object2 = this.m_buildList.iterator();
            while (object2.hasNext()) {
                object = (BaseObject)object2.next();
                if (bl) {
                    String string3;
                    if (object instanceof SolveGroup) {
                        string2 = "AW$XML_ARG:1";
                        string3 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(" + this.quoteValue(((BaseObject)object).getId()) + ",1)");
                        this.m_listResults = this.m_owner.getConnection().getResults();
                        this.m_commandResults = this.m_listResults[0];
                        this.m_commandResultText = this.m_listResults[1];
                        if (new Integer(this.m_commandResults) >= 0) continue;
                        throw new AWException(this.m_commandResultText);
                    }
                    string = "AW$XML_ARG:2";
                    string3 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(" + this.quoteValue(((BaseObject)object).getId()) + ",2)");
                    this.m_listResults = this.m_owner.getConnection().getResults();
                    this.m_commandResults = this.m_listResults[0];
                    this.m_commandResultText = this.m_listResults[1];
                    if (new Integer(this.m_commandResults) >= 0) continue;
                    throw new AWException(this.m_commandResultText);
                }
                if (object instanceof SolveGroup) {
                    if (string2.equals("NA")) {
                        string2 = ((BaseObject)object).getId();
                        continue;
                    }
                    string2 = string2 + "\\n" + ((BaseObject)object).getId();
                    continue;
                }
                if (string.equals("NA")) {
                    string = ((BaseObject)object).getId();
                    continue;
                }
                string = string + "\\n" + ((BaseObject)object).getId();
            }
            if (string.equals("NA") && string2.equals("NA")) {
                string = this.quoteValue("ALL_OBJECTS");
                string2 = this.quoteValue("ALL_SOLVEGROUPS");
            } else {
                if (!string.equals("NA")) {
                    string = this.quoteValue(string);
                }
                if (!string2.equals("NA")) {
                    string2 = this.quoteValue(string2);
                }
            }
            object2 = null;
            object2 = this.m_activeObject != null ? this.m_activeObject.getName() : this.m_AWName;
            object = "NA";
            if (this.m_startDate != null) {
                object = this.m_startDate.get(2) + 1 + "-" + this.m_startDate.get(5) + "-" + this.m_startDate.get(1) + " " + this.m_startDate.get(11) + ":" + this.m_startDate.get(12);
                object = this.quoteValue((String)object);
            }
            this.m_owner.getConnection().executeCommand("call build_driver(" + this.quoteValue(this.m_buildType) + "," + this.quoteValue((String)object2) + "," + string + "," + string2 + "," + this.m_cleanMeasures + "," + this.m_cleanAttrs + "," + this.m_cleanDim + "," + this.m_trackStatus + "," + this.m_maxJobQueues + "," + (String)object + "," + "NA" + ")");
        }
        catch (Exception exception) {
            if (this.m_AWName != null) {
                throw new AWException("AWXML-ERR-NUM-700000", new Object[]{"BUILDDATABASE", this.m_AWName}, exception);
            }
            throw new AWException("AWXML-ERR-NUM-700000", new Object[]{"BUILDDATABASE", this.m_activeObject.getName()}, exception);
        }
    }

    public String Execute(AWConnection aWConnection) {
        String string = null;
        try {
            Object object;
            Object object2;
            String string2 = "NA";
            String string3 = "NA";
            boolean bl = this.m_owner.getConnection().isUsingLongArgProcessing();
            if (bl) {
                object2 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(NA,1)");
                this.m_listResults = this.m_owner.getConnection().getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) < 0) {
                    throw new AWException(this.m_commandResultText);
                }
                object2 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(NA,2)");
                this.m_listResults = this.m_owner.getConnection().getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) < 0) {
                    throw new AWException(this.m_commandResultText);
                }
            }
            object2 = this.m_buildList.iterator();
            while (object2.hasNext()) {
                object = (BaseObject)object2.next();
                if (bl) {
                    String string4;
                    if (object instanceof SolveGroup) {
                        string3 = "AW$XML_ARG:1";
                        string4 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(" + this.quoteValue(((BaseObject)object).getId()) + ",1)");
                        this.m_listResults = this.m_owner.getConnection().getResults();
                        this.m_commandResults = this.m_listResults[0];
                        this.m_commandResultText = this.m_listResults[1];
                        if (new Integer(this.m_commandResults) >= 0) continue;
                        throw new AWException(this.m_commandResultText);
                    }
                    string2 = "AW$XML_ARG:2";
                    string4 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(" + this.quoteValue(((BaseObject)object).getId()) + ",2)");
                    this.m_listResults = this.m_owner.getConnection().getResults();
                    this.m_commandResults = this.m_listResults[0];
                    this.m_commandResultText = this.m_listResults[1];
                    if (new Integer(this.m_commandResults) >= 0) continue;
                    throw new AWException(this.m_commandResultText);
                }
                if (object instanceof SolveGroup) {
                    if (string3.equals("NA")) {
                        string3 = ((BaseObject)object).getId();
                        continue;
                    }
                    string3 = string3 + "\\n" + ((BaseObject)object).getId();
                    continue;
                }
                if (string2.equals("NA")) {
                    string2 = ((BaseObject)object).getId();
                    continue;
                }
                string2 = string2 + "\\n" + ((BaseObject)object).getId();
            }
            if (string2.equals("NA") && string3.equals("NA")) {
                string2 = this.quoteValue("ALL_OBJECTS");
                string3 = this.quoteValue("ALL_SOLVEGROUPS");
            } else {
                if (!string2.equals("NA")) {
                    string2 = this.quoteValue(string2);
                }
                if (!string3.equals("NA")) {
                    string3 = this.quoteValue(string3);
                }
            }
            object2 = null;
            object2 = this.m_activeObject != null ? this.m_activeObject.getName() : this.m_AWName;
            object = "NA";
            if (this.m_startDate != null) {
                object = this.m_startDate.get(2) + 1 + "-" + this.m_startDate.get(5) + "-" + this.m_startDate.get(1) + " " + this.m_startDate.get(11) + ":" + this.m_startDate.get(12);
                object = this.quoteValue((String)object);
            }
            string = aWConnection.executeCommand("push commas;commas=no;show build_driver(" + this.quoteValue(this.m_buildType) + "," + this.quoteValue(this.m_AWName) + "," + string2 + "," + string3 + "," + this.m_cleanMeasures + "," + this.m_cleanAttrs + "," + this.m_cleanDim + "," + this.m_trackStatus + "," + this.m_maxJobQueues + "," + (String)object + "," + "NA" + ");pop commas");
            this.m_listResults = aWConnection.getResults();
            this.m_commandResults = this.m_listResults[0];
            this.m_commandResultText = this.m_listResults[1];
            if (new Integer(this.m_commandResults) < 0) {
                throw new AWException(this.m_commandResultText);
            }
            return string;
        }
        catch (Exception exception) {
            if (this.m_AWName != null) {
                throw new AWException("AWXML-ERR-NUM-700000", new Object[]{"BUILDDATABASE", this.m_AWName}, exception);
            }
            throw new AWException("AWXML-ERR-NUM-700000", new Object[]{"BUILDDATABASE", this.m_activeObject.getName()}, exception);
        }
    }

    public void setCleanDim(boolean bl) {
        this.m_cleanDim = bl;
    }

    public void setCleanDim(Boolean bl) {
        this.m_cleanDim = bl;
    }

    public boolean getCleanDim() {
        return this.m_cleanDim;
    }

    public void setCleanAttrs(boolean bl) {
        this.m_cleanAttrs = bl;
    }

    public void setCleanAttrs(Boolean bl) {
        this.m_cleanAttrs = bl;
    }

    public boolean getCleanAttrs() {
        return this.m_cleanAttrs;
    }

    public void setCleanMeasures(boolean bl) {
        this.m_cleanMeasures = bl;
    }

    public void setCleanMeasures(Boolean bl) {
        this.m_cleanMeasures = bl;
    }

    public boolean getCleanMeasures() {
        return this.m_cleanMeasures;
    }

    public void setRunSolve(boolean bl) {
        this.m_runSolve = bl;
    }

    public void setRunSolve(Boolean bl) {
        this.m_runSolve = bl;
    }

    public boolean getRunSolve() {
        return this.m_runSolve;
    }

    public void setTrackStatus(boolean bl) {
        this.m_trackStatus = bl;
    }

    public void setTrackStatus(Boolean bl) {
        this.m_trackStatus = bl;
    }

    public boolean getTrackStatus() {
        return this.m_trackStatus;
    }

    public static String StopBuildJob(AWConnection aWConnection, int n) {
        aWConnection.executeCommand("call stop_build_job(" + n + ")");
        String[] stringArray = aWConnection.getResults();
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (new Integer(string) < 0) {
            throw new AWException(string2);
        }
        return string;
    }

    public static String ModifyJobProcesses(AWConnection aWConnection, int n, int n2) {
        aWConnection.executeCommand("call manage_parallel_processes(" + n + ", " + n2 + ")");
        String[] stringArray = aWConnection.getResults();
        String string = stringArray[0];
        String string2 = stringArray[1];
        if (new Integer(string) < 0) {
            throw new AWException(string2);
        }
        return string;
    }

    public String ExecuteBuild() {
        String string = null;
        try {
            Object object;
            Object object2;
            String string2 = "NA";
            String string3 = "NA";
            boolean bl = this.m_owner.getConnection().isUsingLongArgProcessing();
            if (bl) {
                object2 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(NA,1)");
                this.m_listResults = this.m_owner.getConnection().getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) < 0) {
                    throw new AWException(this.m_commandResultText);
                }
                object2 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(NA,2)");
                this.m_listResults = this.m_owner.getConnection().getResults();
                this.m_commandResults = this.m_listResults[0];
                this.m_commandResultText = this.m_listResults[1];
                if (new Integer(this.m_commandResults) < 0) {
                    throw new AWException(this.m_commandResultText);
                }
            }
            object2 = this.m_buildList.iterator();
            while (object2.hasNext()) {
                object = (BaseObject)object2.next();
                if (bl) {
                    String string4;
                    if (object instanceof SolveGroup) {
                        string3 = "AW$XML_ARG:1";
                        string4 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(" + this.quoteValue(((BaseObject)object).getId()) + ",1)");
                        this.m_listResults = this.m_owner.getConnection().getResults();
                        this.m_commandResults = this.m_listResults[0];
                        this.m_commandResultText = this.m_listResults[1];
                        if (new Integer(this.m_commandResults) >= 0) continue;
                        throw new AWException(this.m_commandResultText);
                    }
                    string2 = "AW$XML_ARG:2";
                    string4 = this.m_owner.getConnection().executeCommand("call SET_LONG_ARG(" + this.quoteValue(((BaseObject)object).getId()) + ",2)");
                    this.m_listResults = this.m_owner.getConnection().getResults();
                    this.m_commandResults = this.m_listResults[0];
                    this.m_commandResultText = this.m_listResults[1];
                    if (new Integer(this.m_commandResults) >= 0) continue;
                    throw new AWException(this.m_commandResultText);
                }
                if (object instanceof SolveGroup) {
                    if (string3.equals("NA")) {
                        string3 = ((BaseObject)object).getId();
                        continue;
                    }
                    string3 = string3 + "\\n" + ((BaseObject)object).getId();
                    continue;
                }
                if (string2.equals("NA")) {
                    string2 = ((BaseObject)object).getId();
                    continue;
                }
                string2 = string2 + "\\n" + ((BaseObject)object).getId();
            }
            if (string2.equals("NA") && string3.equals("NA")) {
                string2 = this.quoteValue("ALL_OBJECTS");
                string3 = this.quoteValue("ALL_SOLVEGROUPS");
            } else {
                if (!string2.equals("NA")) {
                    string2 = this.quoteValue(string2);
                }
                if (!string3.equals("NA")) {
                    string3 = this.quoteValue(string3);
                }
            }
            object2 = null;
            object2 = this.m_activeObject != null ? this.m_activeObject.getName() : this.m_AWName;
            object = "NA";
            if (this.m_startDate != null) {
                object = this.m_startDate.get(2) + 1 + "-" + this.m_startDate.get(5) + "-" + this.m_startDate.get(1) + " " + this.m_startDate.get(11) + ":" + this.m_startDate.get(12);
                object = this.quoteValue((String)object);
            }
            string = this.m_owner.getConnection().executeCommand("push commas;commas=no;show build_driver(" + this.quoteValue(this.m_buildType) + "," + this.quoteValue((String)object2) + "," + string2 + "," + string3 + "," + this.m_cleanMeasures + "," + this.m_cleanAttrs + "," + this.m_cleanDim + "," + this.m_trackStatus + "," + this.m_maxJobQueues + "," + (String)object + "," + "NA" + ");pop commas");
        }
        catch (Exception exception) {
            if (this.m_AWName != null) {
                throw new AWException("AWXML-ERR-NUM-700000", new Object[]{"BUILDDATABASE", this.m_AWName}, exception);
            }
            throw new AWException("AWXML-ERR-NUM-700000", new Object[]{"BUILDDATABASE", this.m_activeObject.getName()}, exception);
        }
        return string;
    }
}

