/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoInt;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoReal;
import org.spoofax.interpreter.terms.IStrategoString;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.strategoxt.lang.Term;

public class TermEqualityUtil {
    public static boolean equalsIgnoreAnnos(IStrategoTerm t1, IStrategoTerm t2, ITermFactory factory) {
        int type2;
        if (t1 == t2) {
            return true;
        }
        int termType = t1.getTermType();
        if (termType != (type2 = t2.getTermType())) {
            return false;
        }
        switch (termType) {
            case 1: {
                return TermEqualityUtil.equalsIgnoreAnnosAppl((IStrategoAppl)t1, (IStrategoAppl)t2, factory);
            }
            case 2: 
            case 7: {
                return TermEqualityUtil.equalsIgnoreAnnosList(t1, t2, factory);
            }
            case 3: {
                return ((IStrategoInt)t1).intValue() == ((IStrategoInt)t2).intValue();
            }
            case 4: {
                return ((IStrategoReal)t1).realValue() == ((IStrategoReal)t2).realValue();
            }
            case 5: {
                return ((IStrategoString)t1).stringValue().equals(((IStrategoString)t2).stringValue());
            }
            case 9: {
                IStrategoList empty = factory.makeList(Term.NO_TERMS);
                return factory.annotateTerm(t1, empty).match(factory.annotateTerm(t2, empty));
            }
        }
        throw new IllegalStateException("Unknown term type: " + termType);
    }

    private static boolean equalsIgnoreAnnosAppl(IStrategoAppl appl1, IStrategoAppl appl2, ITermFactory factory) {
        IStrategoConstructor cons2;
        IStrategoConstructor cons1 = appl1.getConstructor();
        if (cons1 != (cons2 = appl2.getConstructor()) && !cons1.match(cons2)) {
            return false;
        }
        return TermEqualityUtil.equalsIgnoreAnnosList(appl1, appl2, factory);
    }

    private static boolean equalsIgnoreAnnosList(IStrategoTerm term1, IStrategoTerm term2, ITermFactory factory) {
        IStrategoTerm[] children2;
        IStrategoTerm[] children1 = term1.getAllSubterms();
        if (children1.length != (children2 = term2.getAllSubterms()).length) {
            return false;
        }
        int i = 0;
        while (i < children1.length) {
            if (!TermEqualityUtil.equalsIgnoreAnnos(children1[i], children2[i], factory)) {
                return false;
            }
            ++i;
        }
        return true;
    }
}

