/*
 * Decompiled with CFR 0.152.
 */
package org.strategoxt.lang;

import java.util.Arrays;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterErrorExit;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.SDefT;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.strategoxt.HybridInterpreter;
import org.strategoxt.lang.Context;
import org.strategoxt.lang.DynamicStrategy;
import org.strategoxt.lang.InteropSDefT;
import org.strategoxt.lang.StrategoErrorExit;
import org.strategoxt.lang.StrategoException;
import org.strategoxt.lang.StrategoExit;
import org.strategoxt.lang.Strategy;

public class InteropStrategy
extends DynamicStrategy {
    private final SDefT definition;

    public InteropStrategy(SDefT definition) {
        this.definition = definition;
    }

    public static Strategy[] toInteropStrategies(SDefT[] definitions) {
        Strategy[] results = new Strategy[definitions.length];
        int i = 0;
        while (i < definitions.length) {
            SDefT definition = definitions[i];
            results[i] = definition instanceof InteropSDefT ? ((InteropSDefT)definition).getStrategy() : new InteropStrategy(definitions[i]);
            ++i;
        }
        return results;
    }

    @Override
    public IStrategoTerm invokeDynamic(Context compiledContext, IStrategoTerm current, Strategy[] sargs, IStrategoTerm[] targs) {
        IContext context = HybridInterpreter.getContext(compiledContext);
        VarScope oldScope = context.getVarScope();
        try {
            VarScope defScope = this.definition.getScope();
            if (sargs.length != 0 || targs.length != 0) {
                defScope = new VarScope(defScope);
                this.assignParameters(compiledContext, defScope, sargs, targs);
                context.setVarScope(defScope);
            }
            context.setCurrent(current);
            context.setVarScope(defScope);
            boolean success = this.definition.evaluate(context);
            IStrategoTerm iStrategoTerm = success ? context.current() : null;
            return iStrategoTerm;
        }
        catch (InterpreterErrorExit e) {
            throw new StrategoErrorExit(e.getMessage(), e.getTerm(), e.getTrace(), e.getCause());
        }
        catch (InterpreterExit e) {
            throw new StrategoExit(e.getValue(), (Throwable)e);
        }
        catch (InterpreterException e) {
            throw new StrategoException("Exception in interpreter: " + e.getMessage(), e);
        }
        finally {
            context.restoreVarScope(oldScope);
        }
    }

    private void assignParameters(Context compiledContext, VarScope scope, Strategy[] sargs, IStrategoTerm[] targs) throws InterpreterException {
        SDefT.SVar[] sparams = this.definition.getStrategyParams();
        String[] tparams = this.definition.getTermParams();
        IContext context = HybridInterpreter.getContext(compiledContext);
        SDefT[] sargs2 = InteropSDefT.toInteropSDefTs(sargs, context);
        if (sparams.length != sargs.length || tparams.length != targs.length) {
            throw new InterpreterException("Illegal number of arguments passed to strategy " + this.getName() + ": " + Arrays.toString(sargs) + "|" + Arrays.toString(targs));
        }
        int i = 0;
        while (i < sparams.length) {
            scope.addSVar(sparams[i].name, sargs2[i]);
            ++i;
        }
        i = 0;
        while (i < tparams.length) {
            scope.add(tparams[i], targs[i]);
            ++i;
        }
    }

    @Override
    public String getName() {
        return this.definition.getName();
    }

    public SDefT getDefinition() {
        return this.definition;
    }
}

