/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.stack;

import java.util.ArrayList;
import java.util.List;
import org.metaborg.parsetable.states.IState;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseForestManager;
import org.spoofax.jsglr2.parser.AbstractParseState;
import org.spoofax.jsglr2.parser.observing.ParserObserving;
import org.spoofax.jsglr2.stack.IStackNode;
import org.spoofax.jsglr2.stack.StackLink;
import org.spoofax.jsglr2.stack.paths.EmptyStackPath;
import org.spoofax.jsglr2.stack.paths.NonEmptyStackPath;
import org.spoofax.jsglr2.stack.paths.StackPath;

public abstract class AbstractStackManager<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>, StackNode extends IStackNode, ParseState extends AbstractParseState<?, StackNode>> {
    protected final ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing;

    protected AbstractStackManager(ParserObserving<ParseForest, Derivation, ParseNode, StackNode, ParseState> observing) {
        this.observing = observing;
    }

    public abstract StackNode createInitialStackNode(IState var1);

    public abstract StackNode createStackNode(IState var1);

    public abstract StackLink<ParseForest, StackNode> createStackLink(ParseState var1, StackNode var2, StackNode var3, ParseForest var4);

    public void rejectStackLink(StackLink<ParseForest, StackNode> link) {
        link.reject();
        this.observing.notify(observer -> observer.rejectStackLink(link));
    }

    public StackLink<ParseForest, StackNode> findDirectLink(StackNode from, StackNode to) {
        for (StackLink<ParseForest, StackNode> link : this.stackLinksOut(from)) {
            if (link.to != to) continue;
            return link;
        }
        return null;
    }

    public List<StackPath<ParseForest, StackNode>> findAllPathsOfLength(StackNode stack, int length) {
        ArrayList<StackPath<ParseForest, StackNode>> paths = new ArrayList<StackPath<ParseForest, StackNode>>();
        EmptyStackPath pathsOrigin = new EmptyStackPath(stack);
        this.findAllPathsOfLength(pathsOrigin, length, paths);
        return paths;
    }

    private void findAllPathsOfLength(StackPath<ParseForest, StackNode> path, int length, List<StackPath<ParseForest, StackNode>> paths) {
        if (length == 0) {
            paths.add(path);
        } else {
            StackNode lastStackNode = path.head();
            for (StackLink<ParseForest, StackNode> linkOut : this.stackLinksOut(lastStackNode)) {
                if (linkOut.isRejected()) continue;
                NonEmptyStackPath<ParseForest, StackNode> extendedPath = new NonEmptyStackPath<ParseForest, StackNode>(linkOut, path);
                this.findAllPathsOfLength(extendedPath, length - 1, paths);
            }
        }
    }

    protected abstract Iterable<StackLink<ParseForest, StackNode>> stackLinksOut(StackNode var1);

    public ParseForest[] getParseForests(ParseForestManager<ParseForest, ?, ?, ?, ?> parseForestManager, StackPath<ParseForest, StackNode> pathBegin) {
        IParseForest[] res = parseForestManager.parseForestsArray(pathBegin.length);
        if (res != null) {
            StackPath<ParseForest, StackNode> path = pathBegin;
            int i = 0;
            while (i < pathBegin.length) {
                NonEmptyStackPath nonEmptyPath = (NonEmptyStackPath)path;
                res[i] = (IParseForest)nonEmptyPath.link.parseForest;
                path = nonEmptyPath.tail;
                ++i;
            }
            return res;
        }
        return null;
    }
}

