/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.parser;

import java.util.Collection;
import org.spoofax.jsglr2.messages.Category;
import org.spoofax.jsglr2.messages.Message;
import org.spoofax.jsglr2.messages.SourceRegion;
import org.spoofax.jsglr2.parseforest.IDerivation;
import org.spoofax.jsglr2.parseforest.IParseForest;
import org.spoofax.jsglr2.parseforest.IParseNode;
import org.spoofax.jsglr2.parseforest.ParseNodeVisiting;
import org.spoofax.jsglr2.parseforest.ParseNodeVisitor;
import org.spoofax.jsglr2.parser.Position;

public class AmbiguityDetector<ParseForest extends IParseForest, Derivation extends IDerivation<ParseForest>, ParseNode extends IParseNode<ParseForest, Derivation>>
implements ParseNodeVisitor<ParseForest, Derivation, ParseNode> {
    private final String inputString;
    private final Collection<Message> messages;

    AmbiguityDetector(String inputString, Collection<Message> messages) {
        this.inputString = inputString;
        this.messages = messages;
    }

    @Override
    public void postVisit(ParseNode parseNode, Position startPosition, Position endPosition) {
        if (parseNode.isAmbiguous()) {
            String message;
            if (parseNode.production().isContextFree() && parseNode.getPreferredAvoidedDerivations().size() == 1) {
                return;
            }
            switch (parseNode.production().concreteSyntaxContext()) {
                case Lexical: 
                case Literal: {
                    message = "Lexical ambiguity";
                    break;
                }
                case Layout: {
                    message = "Layout ambiguity";
                    break;
                }
                default: {
                    message = "Ambiguity";
                }
            }
            SourceRegion region = ParseNodeVisiting.visitRegion(this.inputString, startPosition, endPosition);
            this.messages.add(new Message(message, Category.AMBIGUITY, region));
        }
    }
}

