/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr2.incremental.diff;

import java.util.ArrayList;
import java.util.List;
import org.spoofax.jsglr2.incremental.EditorUpdate;
import org.spoofax.jsglr2.incremental.diff.IStringDiff;
import org.spoofax.jsglr2.incremental.diff.jgit.Edit;
import org.spoofax.jsglr2.incremental.diff.jgit.EditList;
import org.spoofax.jsglr2.incremental.diff.jgit.HistogramDiff;
import org.spoofax.jsglr2.incremental.diff.jgit.IntList;
import org.spoofax.jsglr2.incremental.diff.jgit.RawText;
import org.spoofax.jsglr2.incremental.diff.jgit.RawTextComparator;

public class JGitHistogramDiff
implements IStringDiff {
    private final HistogramDiff diff = new HistogramDiff();

    @Override
    public List<EditorUpdate> diff(String oldString, String newString) {
        RawText oldText = new RawText(oldString.toCharArray(), new IncrementingIntList(oldString.length()));
        RawText newText = new RawText(newString.toCharArray(), new IncrementingIntList(newString.length()));
        EditList edits = this.diff.diff(RawTextComparator.DEFAULT, oldText, newText);
        ArrayList<EditorUpdate> updates = new ArrayList<EditorUpdate>(edits.size());
        for (Edit edit : edits) {
            updates.add(new EditorUpdate(edit.getBeginA(), edit.getEndA(), newString.substring(edit.getBeginB(), edit.getEndB())));
        }
        return updates;
    }

    static class IncrementingIntList
    extends IntList {
        private final int size;

        IncrementingIntList(int size) {
            super(0);
            this.size = size;
        }

        @Override
        public void add(int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean contains(int value) {
            return value == Integer.MIN_VALUE || value >= 0 && value <= this.size;
        }

        @Override
        public void fillTo(int toIndex, int val) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int get(int i) {
            if (i == 0) {
                return Integer.MIN_VALUE;
            }
            if (i >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return i - 1;
        }

        @Override
        public void set(int index, int n) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return this.size + 2;
        }

        @Override
        public String toString() {
            return "[-2147483648, 0, 1, ..., " + this.size + "]";
        }
    }
}

