/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client.editregion.detection;

import java.util.ArrayList;
import java.util.IdentityHashMap;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.jsglr.client.editregion.detection.HelperFunctions;
import org.spoofax.jsglr.client.editregion.detection.RecoverInterpretation;
import org.spoofax.jsglr.client.imploder.ImploderAttachment;
import org.spoofax.jsglr.client.imploder.TermTreeFactory;
import org.spoofax.terms.TermFactory;

public class TermEditsAnalyzer {
    private final IStrategoTerm correctAST;
    private final ArrayList<Integer> offsetsDeletedChars;
    private final IdentityHashMap<IStrategoTerm, RecoverInterpretation> recoveryLookup;

    public TermEditsAnalyzer(ArrayList<Integer> offsetsDeletedChars, IStrategoTerm correctAST) {
        this.offsetsDeletedChars = offsetsDeletedChars;
        this.recoveryLookup = new IdentityHashMap();
        this.correctAST = correctAST;
    }

    public RecoverInterpretation getDiscardRecovery() {
        this.recoveryLookup.clear();
        this.collectRecoveries(this.correctAST, null);
        RecoverInterpretation discardRecovery = this.lookupRecovery(this.correctAST, null);
        assert (discardRecovery == null || discardRecovery.getTerm() == this.correctAST);
        return discardRecovery;
    }

    private void collectRecoveries(IStrategoTerm term, IStrategoTerm parent) {
        if (!this.hasDeletions(term)) {
            RecoverInterpretation originalTermRecovery = RecoverInterpretation.createOriginalTermInterpretation(term, parent);
            assert (this.recoveryLookup.get(term) == null);
            this.recoveryLookup.put(term, originalTermRecovery);
            return;
        }
        int i = 0;
        while (i < term.getSubtermCount()) {
            this.collectRecoveries(term.getSubterm(i), term);
            ++i;
        }
        RecoverInterpretation recovery = this.constructMinimalCostRecovery(term, parent);
        if (recovery != null) {
            this.recoveryLookup.put(term, recovery);
        }
    }

    private RecoverInterpretation constructMinimalCostRecovery(IStrategoTerm term, IStrategoTerm parent) {
        RecoverInterpretation discardRecovery = this.constructDiscardRecovery(term, parent);
        RecoverInterpretation childTermsRecovery = null;
        if (term.isList()) {
            childTermsRecovery = this.sublistRecovery(0, term, parent);
            if (childTermsRecovery != null) {
                return childTermsRecovery;
            }
            return discardRecovery;
        }
        childTermsRecovery = this.constructRepairSubtermsRecovery(term, parent);
        RecoverInterpretation subTermsRecovery = this.constructReplaceBySubtermsRecovery(term, parent);
        ArrayList<RecoverInterpretation> candidates = new ArrayList<RecoverInterpretation>();
        candidates.add(childTermsRecovery);
        candidates.add(subTermsRecovery);
        candidates.add(discardRecovery);
        return this.getMinimumCostRecovery(candidates);
    }

    private RecoverInterpretation sublistRecovery(int startIndex, IStrategoTerm listTerm, IStrategoTerm parent) {
        assert (listTerm.isList());
        assert (listTerm.getSubtermCount() != 0);
        int i = startIndex;
        while (i < listTerm.getSubtermCount()) {
            IStrategoTerm prefixSublist;
            int endIndex;
            ArrayList<RecoverInterpretation> candidates;
            RecoverInterpretation prefixRecovery;
            if ((i == listTerm.getSubtermCount() - 1 || this.hasCorrectSeparationAfterIndex(listTerm, i)) && (prefixRecovery = this.getMinimumCostRecovery(candidates = this.getRecoverCandidatesFromChildTerms(listTerm, startIndex, endIndex = i, prefixSublist = this.createSublist(listTerm, startIndex, endIndex), listTerm))) != null) {
                assert (prefixRecovery.getTerm() == prefixSublist);
                assert (prefixRecovery.getSubtermRecoveries().size() >= 1);
                assert (!prefixRecovery.isDiscardRecovery());
                RecoverInterpretation suffixRecovery = this.sublistRecovery(endIndex + 1, listTerm, parent);
                if (suffixRecovery != null) {
                    assert (!suffixRecovery.isDiscardRecovery());
                    ArrayList<RecoverInterpretation> recoveredSubLists = new ArrayList<RecoverInterpretation>();
                    recoveredSubLists.add(prefixRecovery);
                    recoveredSubLists.add(suffixRecovery);
                    return RecoverInterpretation.createRepairSublistsInterpretation(listTerm, parent, recoveredSubLists);
                }
                ArrayList<RecoverInterpretation> prefixCandidates = prefixRecovery.getSubtermRecoveries();
                if (startIndex == 0) {
                    return RecoverInterpretation.createReplaceBySubtermsInterpretation(listTerm, parent, prefixCandidates);
                }
                IStrategoTerm sublist = this.createSublist(listTerm, startIndex, listTerm.getSubtermCount() - 1);
                return RecoverInterpretation.createReplaceBySubtermsInterpretation(sublist, listTerm, prefixCandidates);
            }
            ++i;
        }
        return null;
    }

    private IStrategoTerm createSublist(IStrategoTerm listTerm, int startIndex, int endIndex) {
        TermFactory termFactory = new TermFactory();
        TermTreeFactory termTreeFactory = new TermTreeFactory(termFactory);
        IStrategoTerm firstChild = listTerm.getSubterm(startIndex);
        IStrategoTerm lastChild = listTerm.getSubterm(endIndex);
        IStrategoTerm prefixSublist = termTreeFactory.createSublist((IStrategoList)listTerm, firstChild, lastChild);
        return prefixSublist;
    }

    private boolean hasCorrectSeparationAfterIndex(IStrategoTerm listTerm, int i) {
        if (i < listTerm.getSubtermCount() - 1) {
            int startOffset = ImploderAttachment.getRightToken(listTerm.getSubterm(i)).getEndOffset() + 1;
            int endOffset = ImploderAttachment.getLeftToken(listTerm.getSubterm(i + 1)).getStartOffset() - 1;
            return TermEditsAnalyzer.getCoveredOffsets(startOffset, endOffset, this.offsetsDeletedChars).isEmpty();
        }
        return true;
    }

    private RecoverInterpretation constructRepairSubtermsRecovery(IStrategoTerm term, IStrategoTerm parent) {
        if (this.hasAssociatedDeletions(term)) {
            return null;
        }
        ArrayList<RecoverInterpretation> subtermRecoveries = new ArrayList<RecoverInterpretation>();
        int i = 0;
        while (i < term.getSubtermCount()) {
            IStrategoTerm subterm = term.getSubterm(i);
            RecoverInterpretation subtermRecovery = this.lookupRecovery(subterm, term);
            if (subtermRecovery == null) {
                return null;
            }
            assert (subterm == subtermRecovery.getTerm());
            subtermRecoveries.add(subtermRecovery);
            ++i;
        }
        return RecoverInterpretation.createRepairSubtermsInterpretation(term, parent, subtermRecoveries);
    }

    private RecoverInterpretation constructDiscardRecovery(IStrategoTerm term, IStrategoTerm parent) {
        if (HelperFunctions.isSomeNode(term) || term.isList()) {
            return RecoverInterpretation.createDiscardInterpretation(term, parent);
        }
        return null;
    }

    private RecoverInterpretation constructReplaceBySubtermsRecovery(IStrategoTerm term, IStrategoTerm parent) {
        RecoverInterpretation recovery = this.getRecoveryFromSubterms(term, parent, term, parent);
        return recovery;
    }

    private RecoverInterpretation getRecoveryFromSubterms(IStrategoTerm visitedTerm, IStrategoTerm visitedParent, IStrategoTerm term, IStrategoTerm parent) {
        RecoverInterpretation fromVisitedRecovery = null;
        RecoverInterpretation candidateFromVisited = this.lookupRecovery(visitedTerm, null);
        if (candidateFromVisited != null && candidateFromVisited.hasCompatibleSort(term, parent)) {
            assert (candidateFromVisited.getTerm() == visitedTerm);
            fromVisitedRecovery = RecoverInterpretation.createReplaceBySubtermsInterpretation(term, parent, candidateFromVisited);
            assert (fromVisitedRecovery != null && fromVisitedRecovery.getTerm() == term && fromVisitedRecovery.hasCompatibleSort(term, parent));
        }
        if (fromVisitedRecovery != null && (fromVisitedRecovery.hasSameSort(term, parent) || candidateFromVisited.isUndamagedTerm())) {
            return fromVisitedRecovery;
        }
        RecoverInterpretation fromSubtermsRecovery = null;
        fromSubtermsRecovery = parent == null || !parent.isList() ? this.getMinimumCostRecoveryFromChildterms(visitedTerm, term, parent) : this.getMergedRecoveriesFromChildTerms(visitedTerm, term, parent);
        RecoverInterpretation minimumCostRecovery = this.getMinimumCostRecovery(fromSubtermsRecovery, fromVisitedRecovery);
        assert (minimumCostRecovery == null || minimumCostRecovery.getTerm() == term && minimumCostRecovery.hasCompatibleSort(term, parent));
        return minimumCostRecovery;
    }

    private RecoverInterpretation getMergedRecoveriesFromChildTerms(IStrategoTerm visitedTerm, IStrategoTerm term, IStrategoTerm parent) {
        ArrayList<RecoverInterpretation> candidatesFromSubterms = this.getRecoverCandidatesFromChildTerms(visitedTerm, term, parent);
        ArrayList<RecoverInterpretation> mergedSubtermRecoveries = new ArrayList<RecoverInterpretation>();
        int i = 0;
        while (i < candidatesFromSubterms.size()) {
            mergedSubtermRecoveries.addAll(candidatesFromSubterms.get(i).getSubtermRecoveries());
            ++i;
        }
        RecoverInterpretation fromSubtermsRecovery = null;
        if (!mergedSubtermRecoveries.isEmpty()) {
            fromSubtermsRecovery = RecoverInterpretation.createReplaceBySubtermsInterpretation(term, parent, mergedSubtermRecoveries);
        }
        return fromSubtermsRecovery;
    }

    private RecoverInterpretation getMinimumCostRecoveryFromChildterms(IStrategoTerm visitedTerm, IStrategoTerm term, IStrategoTerm parent) {
        ArrayList<RecoverInterpretation> candidatesFromSubterms = this.getRecoverCandidatesFromChildTerms(visitedTerm, term, parent);
        RecoverInterpretation minimumCostRecovery = this.getMinimumCostRecovery(candidatesFromSubterms);
        return minimumCostRecovery;
    }

    private ArrayList<RecoverInterpretation> getRecoverCandidatesFromChildTerms(IStrategoTerm visitedTerm, IStrategoTerm term, IStrategoTerm parent) {
        if (visitedTerm.getSubtermCount() == 0) {
            return new ArrayList<RecoverInterpretation>();
        }
        int startIndex = 0;
        int endIndex = visitedTerm.getSubtermCount() - 1;
        ArrayList<RecoverInterpretation> candidatesFromSubterms = this.getRecoverCandidatesFromChildTerms(visitedTerm, startIndex, endIndex, term, parent);
        return candidatesFromSubterms;
    }

    private ArrayList<RecoverInterpretation> getRecoverCandidatesFromChildTerms(IStrategoTerm visitedTerm, int startIndex, int endIndex, IStrategoTerm term, IStrategoTerm parent) {
        assert (endIndex <= visitedTerm.getSubtermCount() - 1);
        assert (startIndex >= 0);
        assert (startIndex <= endIndex);
        ArrayList<RecoverInterpretation> candidatesFromSubterms = new ArrayList<RecoverInterpretation>();
        int i = startIndex;
        while (i <= endIndex) {
            IStrategoTerm subterm = visitedTerm.getSubterm(i);
            RecoverInterpretation subtermRecovery = this.getRecoveryFromSubterms(subterm, visitedTerm, term, parent);
            if (subtermRecovery != null && !subtermRecovery.isDiscardRecovery()) {
                assert (subtermRecovery.hasCompatibleSort(term, parent));
                assert (subtermRecovery.getTerm() == term);
                candidatesFromSubterms.add(subtermRecovery);
            }
            ++i;
        }
        return candidatesFromSubterms;
    }

    private RecoverInterpretation lookupRecovery(IStrategoTerm visitedTerm, IStrategoTerm parentTerm) {
        if (this.recoveryLookup.containsKey(visitedTerm)) {
            return this.recoveryLookup.get(visitedTerm);
        }
        if (!this.hasDeletions(visitedTerm)) {
            return RecoverInterpretation.createOriginalTermInterpretation(visitedTerm, parentTerm);
        }
        return null;
    }

    private RecoverInterpretation getMinimumCostRecovery(ArrayList<RecoverInterpretation> recoveries) {
        RecoverInterpretation minimumCostInterpretation = null;
        for (RecoverInterpretation recovery : recoveries) {
            minimumCostInterpretation = this.getMinimumCostRecovery(minimumCostInterpretation, recovery);
        }
        return minimumCostInterpretation;
    }

    private RecoverInterpretation getMinimumCostRecovery(RecoverInterpretation recovery1, RecoverInterpretation recovery2) {
        if (recovery2 == null) {
            return recovery1;
        }
        if (recovery1 == null) {
            return recovery2;
        }
        if (recovery2.getRecoveryCosts() < recovery1.getRecoveryCosts()) {
            return recovery2;
        }
        return recovery1;
    }

    private boolean hasDeletions(IStrategoTerm term) {
        return !TermEditsAnalyzer.getCoveredOffsets(term, this.offsetsDeletedChars).isEmpty();
    }

    private boolean hasAssociatedDeletions(IStrategoTerm term) {
        return !TermEditsAnalyzer.getAssociatedCoveredOffsets(term, this.offsetsDeletedChars).isEmpty();
    }

    private static ArrayList<Integer> getAssociatedCoveredOffsets(IStrategoTerm term, ArrayList<Integer> offsets) {
        ArrayList<Integer> associatedCoveredOffsets = TermEditsAnalyzer.getCoveredOffsets(term, offsets);
        int i = 0;
        while (i < term.getSubtermCount()) {
            IStrategoTerm subterm = term.getSubterm(i);
            ArrayList<Integer> subtermOffsets = TermEditsAnalyzer.getCoveredOffsets(subterm, offsets);
            associatedCoveredOffsets.removeAll(subtermOffsets);
            ++i;
        }
        return associatedCoveredOffsets;
    }

    private static ArrayList<Integer> getCoveredOffsets(IStrategoTerm term, ArrayList<Integer> offsets) {
        int startOffset = ImploderAttachment.getLeftToken(term).getStartOffset();
        int endOffset = ImploderAttachment.getRightToken(term).getEndOffset();
        ArrayList<Integer> coveredOffsets = TermEditsAnalyzer.getCoveredOffsets(startOffset, endOffset, offsets);
        return coveredOffsets;
    }

    private static ArrayList<Integer> getCoveredOffsets(int startOffset, int endOffset, ArrayList<Integer> offsets) {
        ArrayList<Integer> coveredOffsets = new ArrayList<Integer>();
        int i = 0;
        while (i < offsets.size()) {
            int offset = offsets.get(i);
            if (startOffset <= offset && offset <= endOffset) {
                coveredOffsets.add(offset);
            }
            ++i;
        }
        return coveredOffsets;
    }
}

