/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.jsglr.client;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.SetMultimap;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.parsetable.IParseTable;
import org.metaborg.parsetable.IParseTableGenerator;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.terms.IStrategoAppl;
import org.spoofax.interpreter.terms.IStrategoConstructor;
import org.spoofax.interpreter.terms.IStrategoList;
import org.spoofax.interpreter.terms.IStrategoNamed;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.terms.TermType;
import org.spoofax.jsglr.client.Accept;
import org.spoofax.jsglr.client.Action;
import org.spoofax.jsglr.client.ActionItem;
import org.spoofax.jsglr.client.Associativity;
import org.spoofax.jsglr.client.Goto;
import org.spoofax.jsglr.client.IKeywordRecognizer;
import org.spoofax.jsglr.client.ITreeBuilder;
import org.spoofax.jsglr.client.InvalidParseTableException;
import org.spoofax.jsglr.client.KeywordRecognizer;
import org.spoofax.jsglr.client.Label;
import org.spoofax.jsglr.client.Priority;
import org.spoofax.jsglr.client.ProductionAttributes;
import org.spoofax.jsglr.client.RangeList;
import org.spoofax.jsglr.client.Reduce;
import org.spoofax.jsglr.client.ReduceLookahead;
import org.spoofax.jsglr.client.Shift;
import org.spoofax.jsglr.client.State;
import org.spoofax.jsglr.client.imploder.ProductionAttributeReader;
import org.spoofax.jsglr.client.imploder.TreeBuilder;
import org.spoofax.jsglr.io.ParseTableManager;
import org.spoofax.jsglr.io.SGLR;
import org.spoofax.jsglr.shared.SGLRException;
import org.spoofax.terms.ParseError;
import org.spoofax.terms.Term;
import org.spoofax.terms.TermFactory;
import org.spoofax.terms.util.NotImplementedException;
import org.spoofax.terms.util.TermUtils;

public class ParseTable
implements Serializable {
    public static final int LABEL_BASE = 257;
    private static final ILogger logger = LoggerUtils.logger(ParseTable.class);
    private static final long serialVersionUID = -3372429249660900093L;
    private final IParseTableGenerator ptGenerator;
    private static SGLR layoutParser;
    private int version;
    private State[] states;
    private int startState;
    private Label[] labels;
    private Priority[] priorities;
    private Associativity[] associativities;
    private final SetMultimap<Integer, Integer> nonAssocProductionLabels = HashMultimap.create();
    private final SetMultimap<Integer, Integer> nonNestedProductionLabels = HashMultimap.create();
    private final SetMultimap<String, String> nonAssocProductions = HashMultimap.create();
    private final SetMultimap<String, String> nonNestedProductions = HashMultimap.create();
    private boolean hasRejects;
    private boolean hasAvoids;
    private boolean hasPrefers;
    private boolean hasRecovers;
    private transient ITermFactory factory;
    public transient IStrategoConstructor applIStrategoConstructor;
    public transient IStrategoConstructor ambIStrategoConstructor;
    private Label[] injections;
    private transient HashMap<Goto, Goto> gotoCache = new HashMap();
    private transient HashMap<Shift, Shift> shiftCache = new HashMap();
    private transient HashMap<Reduce, Reduce> reduceCache = new HashMap();
    private transient HashMap<RangeList, RangeList> rangesCache = new HashMap();
    private transient Map<Label, List<Priority>> priorityCache;
    private transient IKeywordRecognizer keywords;
    private boolean dynamicPTgeneration = false;

    public ParseTable(IStrategoTerm pt, ITermFactory factory) throws InvalidParseTableException {
        this.initTransientData(factory);
        this.parse(pt);
        this.ptGenerator = null;
        if (this.states.length == 0) {
            throw new InvalidParseTableException("Parse table does not contain any state and normalized grammar is null");
        }
    }

    public ParseTable(IStrategoTerm pt, ITermFactory factory, IParseTableGenerator ptGenerator) throws InvalidParseTableException {
        this.initTransientData(factory);
        this.parse(pt);
        if (this.states.length == 0) {
            this.dynamicPTgeneration = true;
        }
        if (this.dynamicPTgeneration) {
            this.ptGenerator = ptGenerator;
            this.gotoCache = new HashMap();
            this.shiftCache = new HashMap();
            this.reduceCache = new HashMap();
            this.rangesCache = new HashMap();
        } else {
            this.ptGenerator = null;
        }
    }

    public ParseTable(IStrategoTerm pt, ITermFactory factory, FileObject persistedTable, IParseTable referencePt, IParseTableGenerator ptGenerator, IStrategoTerm parseTableAterm) throws Exception {
        this.initTransientData(factory);
        this.dynamicPTgeneration = this.checkDynamicGeneration(pt);
        this.ptGenerator = this.dynamicPTgeneration && persistedTable != null ? ptGenerator : null;
        this.parse(parseTableAterm);
        this.gotoCache = new HashMap();
        this.shiftCache = new HashMap();
        this.reduceCache = new HashMap();
        this.rangesCache = new HashMap();
        if (this.dynamicPTgeneration && persistedTable == null) {
            throw new InvalidParseTableException("Parse table does not contain any state and normalized grammar is null");
        }
    }

    private boolean checkDynamicGeneration(IStrategoTerm pt) {
        return true;
    }

    @Deprecated
    public ParseTable(IStrategoTerm pt) throws InvalidParseTableException {
        this(pt, new TermFactory());
    }

    public void initTransientData(ITermFactory factory) {
        this.factory = factory;
        this.applIStrategoConstructor = factory.makeConstructor("appl", 2);
        this.ambIStrategoConstructor = factory.makeConstructor("amb", 1);
    }

    public ITermFactory getFactory() {
        return this.factory;
    }

    private boolean parse(IStrategoTerm pt) throws InvalidParseTableException {
        this.version = Term.intAt(pt, 0);
        if (pt.getSubtermCount() == 1) {
            throw new InvalidParseTableException("Invalid parse table (possibly wrong start symbol specified)\n" + pt);
        }
        this.startState = Term.intAt(pt, 1);
        IStrategoList labelsTerm = (IStrategoList)Term.termAt(pt, 2);
        IStrategoNamed statesTerm = (IStrategoNamed)Term.termAt(pt, 3);
        IStrategoNamed prioritiesTerm = (IStrategoNamed)Term.termAt(pt, 4);
        if (this.version != 4 && this.version != 6 && this.version != 7) {
            throw new InvalidParseTableException("Only supports version 4, 6 and 7 tables.");
        }
        this.labels = this.parseLabels(labelsTerm);
        this.states = this.parseStates(statesTerm);
        this.priorities = this.parsePriorities(prioritiesTerm);
        this.associativities = this.parseAssociativities(prioritiesTerm);
        this.injections = new Label[this.labels.length];
        int i = 0;
        while (i < this.labels.length) {
            if (this.labels[i] != null && this.labels[i].isInjection()) {
                this.injections[i] = this.labels[i];
            }
            ++i;
        }
        this.gotoCache = null;
        this.shiftCache = null;
        this.reduceCache = null;
        this.rangesCache = null;
        return true;
    }

    private Priority[] parsePriorities(IStrategoNamed prioritiesTerm) throws InvalidParseTableException {
        IStrategoList prods = (IStrategoList)Term.termAt(prioritiesTerm, 0);
        ArrayList<Priority> ret = new ArrayList<Priority>();
        while (!prods.isEmpty()) {
            IStrategoNamed a = (IStrategoNamed)prods.head();
            prods = prods.tail();
            int left = Term.intAt(a, 0);
            int right = Term.intAt(a, 1);
            if (a.getName().equals("left-prio") || a.getName().equals("right-prio") || a.getName().equals("non-assoc")) continue;
            if (a.getName().equals("gtr-prio")) {
                if (left == right) continue;
                ret.add(new Priority(4, left, right));
                continue;
            }
            if (a.getName().equals("arg-gtr-prio")) {
                int arg = right;
                right = Term.intAt(a, 2);
                if (left == right) continue;
                ret.add(new Priority(4, left, right, arg));
                continue;
            }
            throw new InvalidParseTableException("Unknown priority : " + a.getName());
        }
        return ret.toArray(new Priority[0]);
    }

    private Associativity[] parseAssociativities(IStrategoNamed prioritiesTerm) throws InvalidParseTableException {
        IStrategoList prods = (IStrategoList)Term.termAt(prioritiesTerm, 0);
        ArrayList<Associativity> ret = new ArrayList<Associativity>();
        IStrategoNamed a = (IStrategoNamed)prods.head();
        while (!prods.tail().isEmpty()) {
            int left = Term.intAt(a, 0);
            int right = Term.intAt(a, 1);
            if (a.getName().equals("left-prio")) {
                if (left == right) {
                    ret.add(new Associativity(1, left));
                }
            } else if (a.getName().equals("right-prio")) {
                if (left == right) {
                    ret.add(new Associativity(2, left));
                }
            } else if (a.getName().equals("non-assoc")) {
                if (left == right) {
                    ret.add(new Associativity(3, left));
                }
            } else if (!a.getName().equals("gtr-prio") && !a.getName().equals("arg-gtr-prio")) {
                throw new InvalidParseTableException("Unknown priority : " + a.getName());
            }
            prods = prods.tail();
        }
        return ret.toArray(new Associativity[0]);
    }

    private Label[] parseLabels(IStrategoList labelsTerm) throws InvalidParseTableException {
        Label[] ret = new Label[labelsTerm.getSubtermCount() + 257];
        while (!labelsTerm.isEmpty()) {
            IStrategoNamed a = (IStrategoNamed)labelsTerm.head();
            IStrategoAppl prod = (IStrategoAppl)Term.termAt(a, 0);
            int labelNumber = Term.intAt(a, 1);
            boolean injection = this.isInjection(prod);
            IStrategoAppl attrs = (IStrategoAppl)Term.termAt(prod, 2);
            ProductionAttributes pa = this.parseProductionAttributes(labelNumber, attrs);
            ret[labelNumber] = new Label(labelNumber, prod, pa, injection);
            labelsTerm = labelsTerm.tail();
        }
        this.updateNonAssocProductions(ret, this.nonAssocProductionLabels, this.nonAssocProductions);
        this.updateNonAssocProductions(ret, this.nonNestedProductionLabels, this.nonNestedProductions);
        return ret;
    }

    private void updateNonAssocProductions(Label[] labels, SetMultimap<Integer, Integer> productionLabels, SetMultimap<String, String> productions) {
        ProductionAttributeReader par = new ProductionAttributeReader(this.getFactory());
        productionLabels.forEach((higher, lower) -> {
            Label highLabel = labels[higher];
            Label lowLabel = labels[lower];
            String highSort = par.getSort((IStrategoAppl)highLabel.prod.getSubterm(1));
            String highCons = par.getConsAttribute((IStrategoAppl)highLabel.prod.getSubterm(2));
            String lowSort = par.getSort((IStrategoAppl)lowLabel.prod.getSubterm(1));
            String lowCons = par.getConsAttribute((IStrategoAppl)lowLabel.prod.getSubterm(2));
            productions.put((Object)(String.valueOf(highSort) + "." + highCons), (Object)(String.valueOf(lowSort) + "." + lowCons));
        });
    }

    private boolean isInjection(IStrategoNamed prod) {
        if (!prod.getName().equals("prod")) {
            return false;
        }
        if (prod.getSubterm(1).getType() != TermType.APPL) {
            return false;
        }
        String nm = ((IStrategoNamed)prod.getSubterm(1)).getName();
        if (!nm.equals("cf") && !nm.equals("lex")) {
            return false;
        }
        if (prod.getSubterm(0).getType() != TermType.LIST) {
            return false;
        }
        IStrategoList ls = (IStrategoList)prod.getSubterm(0);
        if (ls.getSubtermCount() != 1) {
            return false;
        }
        if (ls.head().getType() != TermType.APPL) {
            return false;
        }
        IStrategoConstructor fun = ((IStrategoAppl)ls.head()).getConstructor();
        return !fun.getName().equals("lit") || fun.getArity() != 1;
    }

    private ProductionAttributes parseProductionAttributes(int labelNumber, IStrategoAppl attr) throws InvalidParseTableException {
        block48: {
            if (!attr.getName().equals("attrs")) break block48;
            int type = 0;
            boolean isRecover = false;
            boolean isIgnoreLayout = false;
            IStrategoTerm layoutConstraint = null;
            boolean isNewlineEnforced = false;
            boolean isLongestMatch = false;
            boolean isCompletion = false;
            boolean isPlaceholderInsertion = false;
            boolean isLiteralCompletion = false;
            boolean isBracket = false;
            IStrategoTerm term = null;
            IStrategoList ls = (IStrategoList)attr.getSubterm(0);
            while (!ls.isEmpty()) {
                block50: {
                    String ctor;
                    IStrategoNamed t;
                    block55: {
                        block54: {
                            block53: {
                                block52: {
                                    block51: {
                                        block49: {
                                            t = (IStrategoNamed)ls.head();
                                            ctor = t.getName();
                                            if (!ctor.equals("reject")) break block49;
                                            type = 1;
                                            this.hasRejects = true;
                                            break block50;
                                        }
                                        if (!ctor.equals("prefer")) break block51;
                                        type = 2;
                                        this.hasPrefers = true;
                                        break block50;
                                    }
                                    if (!ctor.equals("avoid")) break block52;
                                    type = 4;
                                    this.hasAvoids = true;
                                    break block50;
                                }
                                if (!ctor.equals("bracket")) break block53;
                                type = 3;
                                isBracket = true;
                                break block50;
                            }
                            if (!ctor.equals("assoc")) break block54;
                            IStrategoNamed a = (IStrategoNamed)t.getSubterm(0);
                            if (a.getName().equals("left") || a.getName().equals("assoc")) {
                                type = 5;
                            } else if (a.getName().equals("right")) {
                                type = 6;
                            } else if (!a.getName().equals("non-assoc")) {
                                throw new InvalidParseTableException("Unknown assocativity: " + a.getName());
                            }
                            break block50;
                        }
                        if (!ctor.equals("assoc-with")) break block55;
                        IStrategoTerm[] iStrategoTermArray = t.getAllSubterms();
                        int n = iStrategoTermArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IStrategoTerm assocInfo = iStrategoTermArray[n2];
                            IStrategoAppl assocInfoAppl = TermUtils.toAppl(assocInfo);
                            String assocName = assocInfoAppl.getConstructor().getName();
                            Set assocWithSet = (Set)Arrays.stream(TermUtils.toList(assocInfoAppl.getSubterm(0)).getAllSubterms()).map(s -> TermUtils.toInt(s).intValue()).collect(ImmutableSet.toImmutableSet());
                            switch (assocName) {
                                case "non-assoc": {
                                    this.nonAssocProductionLabels.putAll((Object)labelNumber, (Iterable)assocWithSet);
                                    break;
                                }
                                case "non-nested": {
                                    this.nonNestedProductionLabels.putAll((Object)labelNumber, (Iterable)assocWithSet);
                                    break;
                                }
                                default: {
                                    throw new InvalidParseTableException("Unknown associativity info within assoc-with attribute: " + assocName);
                                }
                            }
                            ++n2;
                        }
                        break block50;
                    }
                    if (ctor.equals("term") && t.getSubtermCount() == 1) {
                        if (t.getSubterm(0) instanceof IStrategoNamed) {
                            IStrategoNamed child = (IStrategoNamed)t.getSubterm(0);
                            if (child.getSubtermCount() == 1 && child.getName().equals("cons")) {
                                term = t.getSubterm(0).getSubterm(0);
                            } else if (child.getSubtermCount() == 0 && child.getName().equals("recover")) {
                                isRecover = true;
                                this.hasRecovers = true;
                            } else if (child.getSubtermCount() == 0 && child.getName().equals("completion")) {
                                isCompletion = true;
                            } else if (child.getSubtermCount() == 0 && child.getName().equals("placeholder-insertion")) {
                                isPlaceholderInsertion = true;
                            } else if (child.getSubtermCount() == 0 && child.getName().equals("literal-completion")) {
                                isLiteralCompletion = true;
                            } else if (child.getSubtermCount() == 0 && (child.getName().equals("ignore-layout") || child.getName().equals("ignore-indent"))) {
                                isIgnoreLayout = true;
                            } else if (child.getSubtermCount() == 1 && child.getName().equals("layout")) {
                                layoutConstraint = child.getSubterm(0);
                                if (Term.isTermString(layoutConstraint)) {
                                    try {
                                        if (layoutParser == null) {
                                            try {
                                                InputStream in = this.getClass().getResourceAsStream("indentation/LayoutConstraint.tbl");
                                                ParseTable pt = new ParseTableManager(this.factory).loadFromStream(in);
                                                layoutParser = new SGLR(new TreeBuilder(), pt);
                                            }
                                            catch (ParseError e) {
                                                e.printStackTrace();
                                            }
                                            catch (IOException e) {
                                                e.printStackTrace();
                                            }
                                        }
                                        layoutConstraint = (IStrategoTerm)ParseTable.layoutParser.parse((String)Term.asJavaString((IStrategoTerm)layoutConstraint), (String)"", (String)"Constraint").output;
                                    }
                                    catch (SGLRException e) {
                                        throw new InvalidParseTableException("invalid layout constraint " + Term.asJavaString(layoutConstraint) + ": " + e.getMessage());
                                    }
                                    catch (InterruptedException e) {
                                        e.printStackTrace();
                                    }
                                }
                            } else if (child.getSubtermCount() == 0 && child.getName().equals("enforce-newline")) {
                                isNewlineEnforced = true;
                            } else if (child.getSubtermCount() == 0 && child.getName().equals("longest-match")) {
                                isLongestMatch = true;
                            }
                        } else if (ctor.equals("id")) {
                            term = t.getSubterm(0);
                        } else {
                            throw new InvalidParseTableException("Unknown attribute: " + t);
                        }
                    }
                }
                ls = ls.tail();
            }
            return new ProductionAttributes(term, type, isRecover, isBracket, isCompletion, isPlaceholderInsertion, isLiteralCompletion, isIgnoreLayout, layoutConstraint, isNewlineEnforced, isLongestMatch);
        }
        if (attr.getName().equals("no-attrs")) {
            return new ProductionAttributes(null, 0, false, false, false, false, false, false, null, false, false);
        }
        throw new InvalidParseTableException("Unknown attribute type: " + attr);
    }

    private State[] parseStates(IStrategoNamed statesTerm) throws InvalidParseTableException {
        IStrategoList states = (IStrategoList)Term.termAt(statesTerm, 0);
        State[] ret = new State[states.getSubtermCount()];
        int i = 0;
        while (i < ret.length) {
            IStrategoNamed stateRec = (IStrategoNamed)states.head();
            states = states.tail();
            int stateNumber = Term.intAt(stateRec, 0);
            Goto[] gotos = this.parseGotos((IStrategoList)Term.termAt(stateRec, 1));
            Action[] actions = this.parseActions((IStrategoList)Term.termAt(stateRec, 2));
            ret[i] = new State(stateNumber, gotos, actions);
            ++i;
        }
        return ret;
    }

    private Goto makeGoto(int newStateNumber, RangeList ranges) {
        Goto g = new Goto(ranges, newStateNumber);
        Goto cached = this.gotoCache.get(g);
        if (cached == null) {
            this.gotoCache.put(g, g);
            return g;
        }
        return cached;
    }

    private Action[] parseActions(IStrategoList actionList) throws InvalidParseTableException {
        Action[] ret = new Action[actionList.getSubtermCount()];
        int i = 0;
        while (i < ret.length) {
            IStrategoNamed action = (IStrategoNamed)actionList.head();
            actionList = actionList.tail();
            RangeList ranges = this.parseRanges((IStrategoList)Term.termAt(action, 0));
            ActionItem[] items = this.parseActionItems((IStrategoList)Term.termAt(action, 1));
            ret[i] = new Action(ranges, items);
            ++i;
        }
        return ret;
    }

    private ActionItem[] parseActionItems(IStrategoList items) throws InvalidParseTableException {
        ActionItem[] ret = new ActionItem[items.getSubtermCount()];
        int i = 0;
        while (i < ret.length) {
            int status;
            int label;
            int productionArity;
            ActionItem item = null;
            IStrategoAppl a = (IStrategoAppl)items.head();
            items = items.tail();
            if (a.getName().equals("reduce") && a.getConstructor().getArity() == 3) {
                productionArity = Term.intAt(a, 0);
                label = Term.intAt(a, 1);
                status = Term.intAt(a, 2);
                boolean isRecoverAction = this.getLabel(label).getAttributes().isRecoverProduction();
                boolean isCompletionAction = this.getLabel(label).getAttributes().isCompletionProduction();
                boolean isPlaceholderInsertionAction = this.getLabel(label).getAttributes().isPlaceholderInsertionProduction();
                boolean isLiteralCompletionAction = this.getLabel(label).getAttributes().isLiteralCompletionProduction();
                boolean isBracketAction = this.getLabel(label).getAttributes().isBracket();
                item = this.makeReduce(productionArity, label, status, isRecoverAction, isBracketAction, isCompletionAction, isPlaceholderInsertionAction, isLiteralCompletionAction);
            } else if (a.getName().equals("reduce") && a.getConstructor().getArity() == 4) {
                productionArity = Term.intAt(a, 0);
                label = Term.intAt(a, 1);
                status = Term.intAt(a, 2);
                RangeList[] charClasses = this.parseCharRanges((IStrategoList)Term.termAt(a, 3));
                item = this.makeReduceLookahead(productionArity, label, status, charClasses);
            } else if (a.getName().equals("accept")) {
                item = new Accept();
            } else if (a.getName().equals("shift")) {
                int nextState = Term.intAt(a, 0);
                item = this.makeShift(nextState);
            } else {
                throw new InvalidParseTableException("Unknown action " + a.getName());
            }
            ret[i] = item;
            ++i;
        }
        return ret;
    }

    private RangeList[] parseCharRanges(IStrategoList list) throws InvalidParseTableException {
        LinkedList<RangeList> ret = new LinkedList<RangeList>();
        int i = 0;
        while (i < list.getSubtermCount()) {
            IStrategoList n;
            IStrategoList l;
            IStrategoNamed t = (IStrategoNamed)list.head();
            list = list.tail();
            if (t.getName().equals("look")) {
                l = (IStrategoList)Term.termAt(Term.termAt(t, 0), 0);
                n = (IStrategoList)Term.termAt(t, 1);
            } else {
                assert (t.getName().equals("follow-restriction"));
                l = (IStrategoList)Term.termAt(Term.termAt(Term.termAt(t, 0), 0), 0);
                n = ((IStrategoList)Term.termAt(t, 0)).tail();
            }
            ret.add(this.parseRanges(l));
            if (n.getSubtermCount() > 0) {
                throw new InvalidParseTableException("Multiple lookahead not fully supported");
            }
            IStrategoTerm[] iStrategoTermArray = n.getAllSubterms();
            int n2 = iStrategoTermArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IStrategoTerm nt = iStrategoTermArray[n3];
                ret.add(this.parseRanges((IStrategoList)nt.getSubterm(0)));
                ++n3;
            }
            ++i;
        }
        return ret.toArray(new RangeList[ret.size()]);
    }

    private ActionItem makeReduceLookahead(int productionArity, int label, int status, RangeList[] charClasses) {
        return new ReduceLookahead(productionArity, label, status, charClasses);
    }

    private Reduce makeReduce(int arity, int label, int status, boolean isRecoverAction, boolean isBracketAction, boolean isCompletionAction, boolean isPlaceholderInsertionAction, boolean isLiteralCompletionAction) {
        Reduce r = new Reduce(arity, label, status, isRecoverAction, isBracketAction, isCompletionAction, isPlaceholderInsertionAction, isLiteralCompletionAction);
        Reduce cached = this.reduceCache.get(r);
        if (cached == null) {
            this.reduceCache.put(r, r);
            return r;
        }
        return cached;
    }

    private Shift makeShift(int nextState) {
        Shift s = new Shift(nextState);
        Shift cached = this.shiftCache.get(s);
        if (cached == null) {
            this.shiftCache.put(s, s);
            return s;
        }
        return cached;
    }

    private Goto[] parseGotos(IStrategoList gotos) throws InvalidParseTableException {
        Goto[] ret = new Goto[gotos.getSubtermCount()];
        int i = 0;
        while (i < ret.length) {
            IStrategoNamed go = (IStrategoNamed)gotos.head();
            gotos = gotos.tail();
            IStrategoList rangeList = (IStrategoList)Term.termAt(go, 0);
            int newStateNumber = Term.intAt(go, 1);
            RangeList ranges = this.parseRanges(rangeList);
            ret[i] = this.makeGoto(newStateNumber, ranges);
            ++i;
        }
        return ret;
    }

    private RangeList parseRanges(IStrategoList ranges) throws InvalidParseTableException {
        int[] ret;
        int size = ranges.getSubtermCount();
        boolean containsEOF = false;
        int idx = 0;
        IStrategoTerm[] allSubterms = ranges.getAllSubterms();
        IStrategoTerm lastSubterm = allSubterms[allSubterms.length - 1];
        if (this.version >= 7) {
            if (Term.isTermAppl(lastSubterm) && "eof".equals(((IStrategoAppl)lastSubterm).getName())) {
                containsEOF = true;
            }
            ret = new int[size * 2 - (containsEOF ? 2 : 0)];
            IStrategoTerm[] iStrategoTermArray = allSubterms;
            int n = allSubterms.length;
            int n2 = 0;
            while (n2 < n) {
                IStrategoTerm t = iStrategoTermArray[n2];
                if (Term.isTermInt(t)) {
                    int value = Term.javaInt(t);
                    ret[idx++] = value;
                    ret[idx++] = value;
                } else if ("range".equals(((IStrategoAppl)t).getName())) {
                    ret[idx++] = Term.intAt(t, 0);
                    ret[idx++] = Term.intAt(t, 1);
                }
                ++n2;
            }
        } else {
            containsEOF = Term.isTermInt(lastSubterm) && Term.javaInt(lastSubterm) == 256;
            ret = new int[size * 2 - (containsEOF ? 2 : 0)];
            IStrategoTerm[] iStrategoTermArray = allSubterms;
            int n = allSubterms.length;
            int n3 = 0;
            while (n3 < n) {
                IStrategoTerm t = iStrategoTermArray[n3];
                if (Term.isTermInt(t)) {
                    int value = Term.javaInt(t);
                    if (value != 256) {
                        ret[idx++] = value;
                        ret[idx++] = value;
                    }
                } else {
                    ret[idx++] = Term.intAt(t, 0);
                    int to = Term.intAt(t, 1);
                    if (to == 256) {
                        containsEOF = true;
                        ret[idx++] = 255;
                    } else {
                        ret[idx++] = to;
                    }
                }
                ++n3;
            }
        }
        return this.makeRangeList(ret, containsEOF);
    }

    private RangeList makeRangeList(int[] ranges, boolean containsEOF) {
        RangeList r = new RangeList(ranges, containsEOF);
        RangeList cached = this.rangesCache.get(r);
        if (cached == null) {
            this.rangesCache.put(r, r);
            return r;
        }
        return cached;
    }

    private State parseDynamicState(IStrategoTerm s) {
        IStrategoNamed stateRec = (IStrategoNamed)s;
        int stateNumber = Term.intAt(stateRec, 0);
        Goto[] gotos = new Goto[]{};
        Action[] actions = new Action[]{};
        try {
            gotos = this.parseGotos((IStrategoList)Term.termAt(stateRec, 1));
            actions = this.parseActions((IStrategoList)Term.termAt(stateRec, 2));
        }
        catch (Exception e) {
            logger.error("Could not dynamically generate the parse table.");
        }
        return new State(stateNumber, gotos, actions);
    }

    public State getInitialState() {
        if (this.dynamicPTgeneration) {
            IStrategoTerm s0 = this.ptGenerator.getStateAterm(this.ptGenerator.getParseTable().getStartState());
            State s = this.parseDynamicState(s0);
            return s;
        }
        return this.states[this.startState];
    }

    public State go(State s, int label) {
        if (this.dynamicPTgeneration) {
            IStrategoTerm s0 = this.ptGenerator.getStateAterm(this.ptGenerator.getParseTable().getState(s.go(label)));
            State s_new = this.parseDynamicState(s0);
            return s_new;
        }
        return this.states[s.go(label)];
    }

    public Label getLabel(int label) {
        return this.labels[label];
    }

    public State getState(int s) {
        if (this.dynamicPTgeneration) {
            IStrategoTerm s0 = this.ptGenerator.getStateAterm(this.ptGenerator.getParseTable().getState(s));
            State s_new = this.parseDynamicState(s0);
            return s_new;
        }
        return this.states[s];
    }

    public int getStateCount() {
        return this.states.length;
    }

    public int getProductionCount() {
        return this.labels.length - 257 - 1;
    }

    public int getActionEntryCount() {
        int total = 0;
        State[] stateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            total += s.getActionItemCount();
            ++n2;
        }
        return total;
    }

    public int getGotoCount() {
        int total = 0;
        State[] stateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            total += s.getGotoCount();
            ++n2;
        }
        return total;
    }

    public int getActionCount() {
        int total = 0;
        State[] stateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            State s = stateArray[n2];
            total += s.getActionCount();
            ++n2;
        }
        return total;
    }

    public IParseTableGenerator getPTgenerator() {
        return this.ptGenerator;
    }

    public boolean hasPriorities() {
        return this.priorities.length > 0 || this.associativities.length > 0;
    }

    public boolean hasRejects() {
        return this.hasRejects;
    }

    public boolean hasPrefers() {
        return this.hasPrefers;
    }

    public boolean hasAvoids() {
        return this.hasAvoids;
    }

    public boolean hasRecovers() {
        return this.hasRecovers;
    }

    public boolean hasPrefersOrAvoids() {
        return this.hasAvoids() || this.hasPrefers();
    }

    public IStrategoTerm getProduction(int prod) {
        if (prod < 256) {
            return this.factory.makeInt(prod);
        }
        return this.labels[prod].prod;
    }

    public List<Priority> getPriorities(Label prodLabel) {
        List<Priority> results;
        if (this.priorityCache == null) {
            this.priorityCache = new HashMap<Label, List<Priority>>();
        }
        if ((results = this.priorityCache.get(prodLabel)) != null) {
            return results;
        }
        results = new ArrayList<Priority>();
        Priority[] priorityArray = this.priorities;
        int n = this.priorities.length;
        int n2 = 0;
        while (n2 < n) {
            Priority p = priorityArray[n2];
            if (p.left == prodLabel.labelNumber && p.type == 4) {
                results.add(p);
            }
            ++n2;
        }
        this.priorityCache.put(prodLabel, results);
        return results;
    }

    public Label lookupInjection(int prod) {
        return this.injections[prod];
    }

    public void lookupAction(int stateNumber, int peekNextToken) {
        throw new NotImplementedException();
    }

    public List<Label> getLabels() {
        return Collections.unmodifiableList(Arrays.asList(this.labels));
    }

    public void initializeTreeBuilder(ITreeBuilder treeBuilder) {
        treeBuilder.initializeTable(this, 257, this.labels.length);
        int i = 0;
        while (i < this.labels.length) {
            if (this.labels[i] != null) {
                treeBuilder.initializeLabel(i, this.labels[i].getProduction());
            }
            ++i;
        }
    }

    public IKeywordRecognizer getKeywordRecognizer() {
        if (this.keywords == null) {
            this.keywords = new KeywordRecognizer(this);
        }
        return this.keywords;
    }

    public SetMultimap<String, String> getNonAssocProductions() {
        return this.nonAssocProductions;
    }

    public SetMultimap<String, String> getNonNestedProductions() {
        return this.nonNestedProductions;
    }
}

