/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.stratego;

import java.util.List;
import org.spoofax.interpreter.core.IConstruct;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.VarScope;
import org.spoofax.interpreter.stratego.Hook;
import org.spoofax.interpreter.stratego.Strategy;
import org.spoofax.interpreter.stratego.StupidFormatter;

public class Scope
extends Strategy {
    protected List<String> vars;
    protected Strategy body;

    public Scope(List<String> vars, Strategy body) {
        this.vars = vars;
        this.body = body;
    }

    @Override
    public IConstruct eval(IContext env) throws InterpreterException {
        VarScope newScope = new VarScope(env.getVarScope());
        newScope.addVars(this.vars);
        env.setVarScope(newScope);
        final Scope th = this;
        this.body.getHook().push(new Hook(){

            @Override
            public IConstruct onFailure(IContext env) throws InterpreterException {
                env.popVarScope();
                return th.getHook().pop().onFailure(env);
            }

            @Override
            public IConstruct onSuccess(IContext env) throws InterpreterException {
                env.popVarScope();
                return th.getHook().pop().onSuccess(env);
            }
        });
        return this.body;
    }

    @Override
    public void prettyPrint(StupidFormatter sf) {
        sf.append("Scope(\n");
        sf.bump(6);
        sf.append(", " + this.vars);
        sf.append(", ");
        this.body.prettyPrint(sf);
        sf.append(")");
        sf.unbump(6);
    }
}

