/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.xml;

import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.spoofax.interpreter.library.AbstractStrategoOperatorRegistry;
import org.spoofax.interpreter.library.xml.XML_get_parse_errors;
import org.spoofax.interpreter.library.xml.XML_parse_file;
import org.spoofax.interpreter.library.xml.XML_parse_string;
import org.spoofax.interpreter.library.xml.XML_set_feature;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLLibrary
extends AbstractStrategoOperatorRegistry {
    public static final String REGISTRY_NAME = "XML";
    private SAXParserFactory parserFactory;
    private SAXParser parser;
    private boolean allowMixedContent = false;
    private boolean allowCharacterContent = true;
    private Exception lastException;
    private ArrayList<SAXParseException> lastErrors;

    public XMLLibrary() {
        this.add(new XML_get_parse_errors(this));
        this.add(new XML_parse_file(this));
        this.add(new XML_parse_string(this));
        this.add(new XML_set_feature(this));
    }

    @Override
    public String getOperatorRegistryName() {
        return REGISTRY_NAME;
    }

    public SAXParserFactory obtainParserFactory() {
        if (this.parserFactory == null) {
            this.parserFactory = SAXParserFactory.newInstance();
        }
        return this.parserFactory;
    }

    public SAXParser obtainParser() {
        if (this.parser == null) {
            try {
                this.parser = this.obtainParserFactory().newSAXParser();
            }
            catch (ParserConfigurationException e) {
                this.setLastException(e);
            }
            catch (SAXException e) {
                this.setLastException(e);
            }
        }
        return this.parser;
    }

    public void purgeParser() {
        this.parser = null;
    }

    public void clearErrors() {
        this.lastException = null;
        this.lastErrors = null;
    }

    public boolean getAllowMixedContent() {
        return this.allowMixedContent;
    }

    public void setAllowMixedContent(boolean allowMixedContent) {
        this.allowMixedContent = allowMixedContent;
    }

    public boolean getAllowCharacterContent() {
        return this.allowCharacterContent;
    }

    public void setAllowCharacterContent(boolean allowCharacterContent) {
        this.allowCharacterContent = allowCharacterContent;
    }

    public Exception getLastException() {
        return this.lastException;
    }

    public void setLastException(Exception lastException) {
        this.lastException = lastException;
    }

    public ArrayList<SAXParseException> getLastErrors() {
        return this.lastErrors;
    }

    public void setLastErrors(ArrayList<SAXParseException> lastErrors) {
        this.lastErrors = lastErrors;
    }
}

