/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.library.jsglr.treediff;

import java.util.ArrayList;
import java.util.List;
import org.spoofax.interpreter.library.jsglr.treediff.LCSCommand;

public class LCS<T> {
    private LCSCommand<T> lcsCommand;
    private List<T> elems1 = new ArrayList<T>();
    private List<T> elems2 = new ArrayList<T>();
    private ArrayList<Integer> matchedIndices1 = new ArrayList();
    private ArrayList<Integer> matchedIndices2 = new ArrayList();

    public ArrayList<Integer> getMatchedIndices1() {
        return this.matchedIndices1;
    }

    public ArrayList<Integer> getMatchedIndices2() {
        return this.matchedIndices2;
    }

    public ArrayList<Integer> getUnMatchedIndices1() {
        return this.getUnmatchedIndices(this.elems1, this.matchedIndices1);
    }

    public ArrayList<Integer> getUnMatchedIndices2() {
        return this.getUnmatchedIndices(this.elems2, this.matchedIndices2);
    }

    public ArrayList<T> getResultLCS1() {
        return this.getIncludedElems(this.elems1, this.matchedIndices1);
    }

    public ArrayList<T> getResultLCS2() {
        return this.getIncludedElems(this.elems2, this.matchedIndices2);
    }

    public ArrayList<T> getResultUnmatched1() {
        return this.getIncludedElems(this.elems1, this.getUnMatchedIndices1());
    }

    public ArrayList<T> getResultUnmatched2() {
        return this.getIncludedElems(this.elems2, this.getUnMatchedIndices2());
    }

    public int getLCSSize() {
        return this.matchedIndices1.size();
    }

    public void setLcsCommand(LCSCommand<T> lcsCommand) {
        this.lcsCommand = lcsCommand;
    }

    public LCS(LCSCommand<T> lcsCommand) {
        this.lcsCommand = lcsCommand;
    }

    private void clearResults() {
        this.matchedIndices1.clear();
        this.matchedIndices2.clear();
    }

    public LCS<T> createLCSResultsOptimized(List<T> elems1, List<T> elems2) {
        this.clearResults();
        this.elems1 = elems1;
        this.elems2 = elems2;
        return this.createLCSResultsOptimized();
    }

    private ArrayList<Integer> getUnmatchedIndices(List<T> elems, ArrayList<Integer> indices) {
        assert (elems.size() >= indices.size());
        ArrayList<Integer> unmatchedIndices = new ArrayList<Integer>();
        int indexIndices = 0;
        int nextIncludedIndex = -1;
        if (indexIndices < indices.size()) {
            nextIncludedIndex = indices.get(indexIndices);
        }
        int elems_index = 0;
        while (elems_index < elems.size()) {
            if (elems_index == nextIncludedIndex) {
                nextIncludedIndex = -1;
                if (++indexIndices < indices.size()) {
                    nextIncludedIndex = indices.get(indexIndices);
                }
            } else {
                unmatchedIndices.add(elems_index);
            }
            ++elems_index;
        }
        assert (unmatchedIndices.size() + indices.size() == elems.size());
        return unmatchedIndices;
    }

    private ArrayList<T> getIncludedElems(List<T> elems, ArrayList<Integer> indices) {
        assert (elems.size() >= indices.size());
        ArrayList<T> includedElems = new ArrayList<T>();
        int indexIndices = 0;
        int nextIncludedIndex = -1;
        if (indexIndices < indices.size()) {
            nextIncludedIndex = indices.get(indexIndices);
        }
        int elems_index = 0;
        while (elems_index < elems.size()) {
            if (elems_index == nextIncludedIndex) {
                includedElems.add(elems.get(elems_index));
                nextIncludedIndex = -1;
                if (++indexIndices < indices.size()) {
                    nextIncludedIndex = indices.get(indexIndices);
                }
            }
            ++elems_index;
        }
        assert (includedElems.size() == indices.size());
        return includedElems;
    }

    private LCS<T> createLCSResultsOptimized() {
        int commonPrefixLength = this.commonPrefixLength();
        int commonSuffixLength = this.commonSuffixLength(commonPrefixLength);
        this.addPrefixIndices(commonPrefixLength);
        this.addMidIndices(commonPrefixLength, commonSuffixLength);
        this.addSuffixIndices(commonSuffixLength);
        this.checkAssertions(this.elems1, this.elems2);
        return this;
    }

    private void addMidIndices(int commonPrefixLength, int commonSuffixLength) {
        List<T> elems1_mid = this.elems1.subList(commonPrefixLength, this.elems1.size() - commonSuffixLength);
        List<T> elems2_mid = this.elems2.subList(commonPrefixLength, this.elems2.size() - commonSuffixLength);
        this.lcs(elems1_mid, elems2_mid, commonPrefixLength);
    }

    private void addSuffixIndices(int commonSuffixLength) {
        int suffixIndex = commonSuffixLength - 1;
        while (suffixIndex >= 0) {
            int el1_index = this.elems1.size() - 1 - suffixIndex;
            int el2_index = this.elems2.size() - 1 - suffixIndex;
            assert (this.lcsCommand.isMatch(this.elems1.get(el1_index), this.elems2.get(el2_index))) : "elements should match since they are in the common suffix";
            this.matchedIndices1.add(el1_index);
            this.matchedIndices2.add(el2_index);
            --suffixIndex;
        }
    }

    private void addPrefixIndices(int commonPrefixLength) {
        int prefixIndex = 0;
        while (prefixIndex < commonPrefixLength) {
            assert (this.lcsCommand.isMatch(this.elems1.get(prefixIndex), this.elems2.get(prefixIndex))) : "elements should match since they are in the common prefix";
            this.matchedIndices1.add(prefixIndex);
            this.matchedIndices2.add(prefixIndex);
            ++prefixIndex;
        }
    }

    private int commonPrefixLength() {
        int minLength = Math.min(this.elems1.size(), this.elems2.size());
        int commonPrefixLength = 0;
        while (commonPrefixLength < minLength) {
            T el2;
            T el1 = this.elems1.get(commonPrefixLength);
            if (!this.lcsCommand.isMatch(el1, el2 = this.elems2.get(commonPrefixLength))) break;
            ++commonPrefixLength;
        }
        return commonPrefixLength;
    }

    private int commonSuffixLength(int commonPrefixLength) {
        int minLength = Math.min(this.elems1.size(), this.elems2.size());
        int commonSuffixLength = 0;
        while (commonSuffixLength < minLength - commonPrefixLength) {
            T el2;
            int el1_index = this.elems1.size() - commonSuffixLength - 1;
            int el2_index = this.elems2.size() - commonSuffixLength - 1;
            T el1 = this.elems1.get(el1_index);
            if (!this.lcsCommand.isMatch(el1, el2 = this.elems2.get(el2_index))) break;
            ++commonSuffixLength;
        }
        return commonSuffixLength;
    }

    public LCS<T> createLCSResults(List<T> elems1, List<T> elems2) {
        this.clearResults();
        this.elems1 = elems1;
        this.elems2 = elems2;
        this.lcs(elems1, elems2, 0);
        this.checkAssertions(elems1, elems2);
        return this;
    }

    private void lcs(List<T> elems1, List<T> elems2, int startIndex) {
        int j;
        int lengthElems1 = elems1.size();
        int lengthElems2 = elems2.size();
        int[][] opt = new int[lengthElems1 + 1][lengthElems2 + 1];
        int i = lengthElems1 - 1;
        while (i >= 0) {
            j = lengthElems2 - 1;
            while (j >= 0) {
                opt[i][j] = this.lcsCommand.isMatch(elems1.get(i), elems2.get(j)) ? opt[i + 1][j + 1] + 1 : Math.max(opt[i + 1][j], opt[i][j + 1]);
                --j;
            }
            --i;
        }
        i = 0;
        j = 0;
        while (i < lengthElems1 && j < lengthElems2) {
            T el2;
            T el1 = elems1.get(i);
            if (this.lcsCommand.isMatch(el1, el2 = elems2.get(j))) {
                this.matchedIndices1.add(i + startIndex);
                this.matchedIndices2.add(j + startIndex);
                ++i;
                ++j;
                continue;
            }
            if (opt[i + 1][j] >= opt[i][j + 1]) {
                ++i;
                continue;
            }
            ++j;
        }
    }

    private void checkAssertions(List<T> elems1, List<T> elems2) {
        assert (this.matchedIndices1.size() == this.matchedIndices2.size());
        assert (this.matchedIndices1.size() <= elems1.size());
        assert (this.matchedIndices2.size() <= elems2.size());
        int i = 0;
        while (i < this.matchedIndices1.size()) {
            T el1 = elems1.get(this.matchedIndices1.get(i));
            T el2 = elems2.get(this.matchedIndices2.get(i));
            assert (this.lcsCommand.isMatch(el1, el2));
            ++i;
        }
        i = 1;
        while (i < this.matchedIndices1.size()) {
            assert (this.matchedIndices1.get(i) > this.matchedIndices1.get(i - 1));
            assert (this.matchedIndices2.get(i) > this.matchedIndices2.get(i - 1));
            ++i;
        }
    }
}

