/*
 * Decompiled with CFR 0.152.
 */
package org.spoofax.interpreter.core;

import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.spoofax.interpreter.core.Interpreter;
import org.spoofax.interpreter.core.InterpreterException;
import org.spoofax.interpreter.core.InterpreterExit;
import org.spoofax.interpreter.library.IOperatorRegistry;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.interpreter.util.DebugUtil;

public class Main {
    public static void main(String[] args) throws IOException {
        String[] files = null;
        String factoryName = null;
        boolean waitForProfiler = false;
        boolean inProgramArgs = false;
        LinkedList<String> programArgs = new LinkedList<String>();
        LinkedList<String> libraryArgs = new LinkedList<String>();
        int i = 0;
        while (i < args.length) {
            if (inProgramArgs) {
                programArgs.add(args[i]);
            } else if (args[i].equals("--debug")) {
                DebugUtil.setDebug(true);
            } else if (args[i].equals("-i")) {
                files = args[i + 1].split(",");
            } else if (args[i].equals("-l")) {
                libraryArgs.add(args[i + 1]);
            } else if (args[i].equals("-f")) {
                factoryName = args[i + 1];
            } else if (args[i].equals("--wait-for-profiler")) {
                waitForProfiler = true;
            } else if (args[i].equals("--trace")) {
                DebugUtil.tracing = true;
            } else if (args[i].equals("--")) {
                inProgramArgs = true;
            }
            ++i;
        }
        Interpreter itp = Main.createInterpreter(factoryName);
        Main.loadLibraries(itp, libraryArgs, itp.getFactory());
        try {
            String[] stringArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String fn = stringArray[n2];
                System.err.println("Loading " + fn);
                itp.load(fn);
                ++n2;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InterpreterException e) {
            e.printStackTrace();
        }
        try {
            IStrategoTerm[] as = new IStrategoTerm[programArgs.size()];
            ITermFactory factory = itp.getFactory();
            int i2 = 0;
            while (i2 < as.length) {
                as[i2] = factory.makeString((String)programArgs.get(i2));
                ++i2;
            }
            itp.setCurrent(itp.getFactory().makeList(as));
            boolean r = itp.invoke("main_0_0");
            if (r) {
                System.out.println("" + itp.current());
            } else {
                System.err.println("rewriting failed");
                System.exit(-1);
            }
        }
        catch (InterpreterExit e) {
            System.out.println("Exit with status: " + e.getValue());
        }
        catch (InterpreterException e) {
            e.printStackTrace();
        }
        if (waitForProfiler) {
            System.in.read();
        }
    }

    private static Interpreter createInterpreter(String factoryName) {
        if (factoryName == null) {
            return new Interpreter();
        }
        try {
            Class<?> clazz = Class.forName(factoryName);
            Constructor<?> ctor = clazz.getConstructor(new Class[0]);
            ITermFactory factory = (ITermFactory)ctor.newInstance(new Object[0]);
            return new Interpreter(factory, factory);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        System.err.println("Fatal: failed to instantiate term factory '" + factoryName + "'");
        System.exit(-2);
        return null;
    }

    private static void loadLibraries(Interpreter itp, List<String> libraryArgs, ITermFactory factory) {
        for (String s : libraryArgs) {
            IOperatorRegistry ior = Main.findOperatorRegistry(s, factory);
            if (ior == null) {
                System.err.println("Unable to load '" + s + "'");
                continue;
            }
            itp.addOperatorRegistry(ior);
        }
    }

    private static IOperatorRegistry findOperatorRegistry(String s, ITermFactory factory) {
        try {
            Class<?> clazz = Class.forName(s);
            Constructor<?> m = clazz.getConstructor(ITermFactory.class);
            return (IOperatorRegistry)m.newInstance(factory);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return null;
    }
}

