/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.util.file;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.LinkedList;
import java.util.regex.Pattern;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.util.file.URIEncode;

public class FileUtils {
    private static Pattern sanitizePattern = Pattern.compile("[^a-zA-Z0-9.-]");

    public static File toFile(FileObject fileObject) {
        URI uri = FileUtils.toURI(fileObject);
        File file = new File(uri);
        return file;
    }

    public static Iterable<File> toFiles(Iterable<FileObject> fileObjects) {
        LinkedList files = Lists.newLinkedList();
        for (FileObject fileObject : fileObjects) {
            files.add(FileUtils.toFile(fileObject));
        }
        return files;
    }

    public static URI toURI(FileObject fileObject) {
        try {
            FileName name = fileObject.getName();
            String uriString = URIEncode.encode(name.getURI());
            return new URI(uriString);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Could not convert FileObject to URI", e);
        }
    }

    public static String sanitize(String path) {
        return sanitizePattern.matcher(path).replaceAll("_");
    }
}

