/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.spoofax.core.shell;

import com.google.common.collect.Iterables;
import com.google.common.collect.Streams;
import java.io.OutputStream;
import java.util.Arrays;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.matching.Transform;
import mb.nabl2.terms.stratego.StrategoTerms;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixTerms;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.MetaborgException;
import org.metaborg.core.MetaborgRuntimeException;
import org.metaborg.core.action.CompileGoal;
import org.metaborg.core.action.TransformActionContrib;
import org.metaborg.core.build.BuildInput;
import org.metaborg.core.build.BuildInputBuilder;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageComponent;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.language.LanguageFileSelector;
import org.metaborg.core.messages.WithLocationStreamMessagePrinter;
import org.metaborg.core.processing.ITask;
import org.metaborg.spoofax.core.Spoofax;
import org.metaborg.spoofax.core.build.ISpoofaxBuildOutput;
import org.metaborg.spoofax.core.shell.CLIUtils;
import org.metaborg.spoofax.core.unit.ISpoofaxAnalyzeUnit;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;
import org.spoofax.terms.util.TermUtils;
import org.strategoxt.HybridInterpreter;

public class StatixGenerator {
    private static final String LANG_STX_NAME = "StatixLang";
    private static final OutputStream MSG_OUT = System.out;
    private final Spoofax S;
    private final CLIUtils CLI;
    private final ILanguageImpl statixLang;
    private final IContext context;
    private final Spec spec;
    private final IConstraint constraint;

    public StatixGenerator(Spoofax spoofax, IContext context, FileObject spec) throws MetaborgException {
        this.S = spoofax;
        this.CLI = new CLIUtils(this.S);
        this.statixLang = this.CLI.getLanguage(LANG_STX_NAME);
        this.context = context;
        Tuple2<Spec, IConstraint> specAndConstraint = this.loadSpec(spec);
        this.spec = specAndConstraint._1();
        this.constraint = specAndConstraint._2();
    }

    private Tuple2<Spec, IConstraint> loadSpec(FileObject resource) throws MetaborgException {
        ITask<ISpoofaxBuildOutput> task;
        try {
            BuildInputBuilder inputBuilder = new BuildInputBuilder(this.context.project());
            BuildInput input = inputBuilder.withCompileDependencyLanguages(false).withLanguages(Arrays.asList(this.statixLang)).withDefaultIncludePaths(true).withSourcesFromDefaultSourceLocations(true).withSelector(new LanguageFileSelector(this.S.languageIdentifierService, this.statixLang)).withMessagePrinter(new WithLocationStreamMessagePrinter(this.S.sourceTextService, this.S.projectService, MSG_OUT)).withThrowOnErrors(true).addTransformGoal(new CompileGoal()).build(this.S.dependencyService, this.S.languagePathService);
            task = this.S.processorRunner.build(input, null, null).schedule().block();
        }
        catch (InterruptedException | MetaborgException e) {
            throw new MetaborgException("Building Statix files failed unexpectedly", e);
        }
        catch (MetaborgRuntimeException e) {
            throw new MetaborgException("Building Statix files failed", e);
        }
        ISpoofaxBuildOutput output = task.result();
        if (!output.success()) {
            throw new MetaborgException("Failed to build Statix files in " + this.context.project());
        }
        ISpoofaxAnalyzeUnit analyzeUnit = Streams.stream(output.analysisResults().iterator()).filter(r -> r.source().getName().equals(resource.getName())).findFirst().orElse(null);
        if (analyzeUnit == null) {
            throw new MetaborgException("Cannot find " + resource);
        }
        if (!analyzeUnit.success()) {
            throw new MetaborgException(resource + " has analysis errors.");
        }
        TransformActionContrib evalAction = this.CLI.getNamedTransformAction("Evaluation Pair", this.statixLang);
        IStrategoTerm ast = analyzeUnit.ast();
        if (ast == null || !TermUtils.isAppl(ast) || !TermUtils.isAppl(ast, "Test")) {
            throw new MetaborgException("Not a correct spec.");
        }
        IStrategoTerm evalPair = this.CLI.transform(analyzeUnit, evalAction, this.context);
        if (!TermUtils.isTuple(evalPair, 2)) {
            throw new MetaborgException("Expected tuple of constraint and spec, but got " + evalPair);
        }
        StrategoTerms strategoTerms = new StrategoTerms(this.S.termFactory);
        IConstraint constraint = StatixTerms.constraint().match(strategoTerms.fromStratego(evalPair.getSubterm(0))).orElseThrow(() -> new MetaborgException("Expected constraint"));
        Spec spec = StatixTerms.spec().match(strategoTerms.fromStratego(evalPair.getSubterm(1))).orElseThrow(() -> new MetaborgException("Expected spec"));
        return Tuple2.of(spec, constraint);
    }

    public Spec spec() {
        return this.spec;
    }

    public IConstraint constraint() {
        return this.constraint;
    }

    public static TermFormatter pretty(Spoofax S2, IContext context, String strategy) {
        TermFormatter pp;
        ILanguageImpl lang = context.language();
        if (!Iterables.isEmpty(lang.components())) {
            HybridInterpreter runtime;
            ITermFactory tf;
            ILanguageComponent lc = (ILanguageComponent)Iterables.getOnlyElement(lang.components());
            try {
                tf = S2.termFactory;
                runtime = S2.strategoRuntimeService.runtime(lc, context);
            }
            catch (MetaborgException e) {
                throw new MetaborgRuntimeException(e);
            }
            StrategoTerms strategoTerms = new StrategoTerms(tf);
            pp = t -> {
                IStrategoTerm st = strategoTerms.toStratego(StatixGenerator.explicate(t));
                try {
                    IStrategoTerm r = spoofax.strategoCommon.invoke(runtime, st, strategy);
                    return r != null ? TermUtils.toJavaString(r) : t.toString();
                }
                catch (MetaborgException e) {
                    return t.toString();
                }
            };
        } else {
            pp = Object::toString;
        }
        return pp;
    }

    private static ITerm explicate(ITerm t) {
        return Transform.T.sometd(TermMatch.M.cases(TermMatch.M.cons(TermMatch.M.term(), TermMatch.M.var(StatixGenerator::explicate), (cons, hd, tl) -> TermBuild.B.newCons(StatixGenerator.explicate(hd), TermBuild.B.newList(StatixGenerator.explicate(tl)), cons.getAttachments())), TermMatch.M.var(v -> TermBuild.B.newAppl("Var", TermBuild.B.newString(v.getResource()), TermBuild.B.newString(v.getName()))))::match).apply(t);
    }
}

