/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.sdf2table.grammar;

import com.google.common.collect.Lists;
import java.util.Map;
import java.util.Set;
import org.metaborg.parsetable.symbols.ISymbol;
import org.metaborg.parsetable.symbols.LiteralSymbol;
import org.metaborg.parsetable.symbols.SortCardinality;
import org.metaborg.parsetable.symbols.SortSymbol;
import org.metaborg.parsetable.symbols.SyntaxContext;
import org.metaborg.sdf2table.deepconflicts.Context;
import org.metaborg.sdf2table.grammar.LiteralType;
import org.metaborg.sdf2table.grammar.Symbol;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public class Sort
extends Symbol {
    private static final long serialVersionUID = 9143763814850136478L;
    private final String name;
    private final LiteralType type;

    protected Sort(String name) {
        this.name = name;
        this.type = null;
        this.followRestrictionsLookahead = Lists.newArrayList();
        this.followRestrictionsNoLookahead = null;
    }

    protected Sort(String name, LiteralType type) {
        this.name = name;
        this.type = type;
        this.followRestrictionsLookahead = Lists.newArrayList();
        this.followRestrictionsNoLookahead = null;
    }

    @Override
    public String name() {
        if (this.type == null) {
            return this.name;
        }
        if (this.type == LiteralType.CiLit) {
            return "'" + this.name + "'";
        }
        return "\"" + this.name + "\"";
    }

    public String getSortName() {
        return this.name;
    }

    public LiteralType getType() {
        return this.type;
    }

    @Override
    public IStrategoTerm toAterm(ITermFactory tf) {
        if (this.type == LiteralType.CiLit) {
            return tf.makeAppl(tf.makeConstructor("cilit", 1), tf.makeString(this.decodeLiteral(this.name)));
        }
        if (this.type == LiteralType.Lit) {
            return tf.makeAppl(tf.makeConstructor("lit", 1), tf.makeString(this.decodeLiteral(this.name)));
        }
        return tf.makeAppl(tf.makeConstructor("sort", 1), tf.makeString(this.name));
    }

    private String decodeLiteral(String literal) {
        return literal.replace("\\\"", "\"").replace("\\\\", "\\").replace("\\'", "'");
    }

    @Override
    public IStrategoTerm toSDF3Aterm(ITermFactory tf, Map<Set<Context>, Integer> ctx_vals, Integer ctx_val) {
        if (this.type == LiteralType.CiLit) {
            return tf.makeAppl(tf.makeConstructor("CiLit", 1), tf.makeString("\"" + this.name + "\""));
        }
        if (this.type == LiteralType.Lit) {
            return tf.makeAppl(tf.makeConstructor("Lit", 1), tf.makeString("\"" + this.name + "\""));
        }
        if (ctx_val != null) {
            return tf.makeAppl(tf.makeConstructor("Sort", 1), tf.makeString(String.valueOf(this.name) + ctx_val));
        }
        return tf.makeAppl(tf.makeConstructor("Sort", 1), tf.makeString(this.name));
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Sort other = (Sort)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    @Override
    public ISymbol toParseTableSymbol(SyntaxContext syntaxContext, SortCardinality cardinality) {
        if (this.type == LiteralType.CiLit || this.type == LiteralType.Lit) {
            return new LiteralSymbol(syntaxContext, cardinality, this.decodeLiteral(this.name));
        }
        return new SortSymbol(syntaxContext, cardinality, this.name);
    }
}

