/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.query;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Set;
import org.metaborg.parsetable.actions.ActionType;
import org.metaborg.parsetable.actions.IAction;
import org.metaborg.parsetable.actions.IReduce;
import org.metaborg.parsetable.actions.IShift;
import org.metaborg.parsetable.query.ActionsPerCharacterClass;
import org.metaborg.parsetable.query.IActionQuery;
import org.metaborg.parsetable.query.ParsingMode;

public interface IActionsForCharacter {
    public IAction[] getActions();

    public Iterable<IAction> getApplicableActions(IActionQuery var1, ParsingMode var2);

    public Iterable<IReduce> getApplicableReduceActions(IActionQuery var1, ParsingMode var2);

    default public ActionsPerCharacterClass[] filterNonRecoveryActions(ActionsPerCharacterClass[] actionsPerCharacterClasses, Set<Integer> recoveryStateIds) {
        ActionsPerCharacterClass[] filteredActionsPerCharacterClasses = new ActionsPerCharacterClass[actionsPerCharacterClasses.length];
        int i = 0;
        ActionsPerCharacterClass[] actionsPerCharacterClassArray = actionsPerCharacterClasses;
        int n = actionsPerCharacterClasses.length;
        int n2 = 0;
        while (n2 < n) {
            ActionsPerCharacterClass actionsPerCharacterClass = actionsPerCharacterClassArray[n2];
            ArrayList<IAction> filteredActions = new ArrayList<IAction>(actionsPerCharacterClass.actions);
            filteredActions.removeIf(action -> {
                boolean isShiftToRecoveryState;
                boolean isRecoveryReduce = (action.actionType() == ActionType.REDUCE || action.actionType() == ActionType.REDUCE_LOOKAHEAD) && ((IReduce)action).production().isRecovery();
                boolean bl = isShiftToRecoveryState = action.actionType() == ActionType.SHIFT && recoveryStateIds.contains(((IShift)action).shiftStateId());
                return isRecoveryReduce || isShiftToRecoveryState;
            });
            if (filteredActions.size() == actionsPerCharacterClass.actions.size()) {
                filteredActionsPerCharacterClasses[i++] = actionsPerCharacterClass;
            } else if (filteredActions.size() > 0) {
                filteredActionsPerCharacterClasses[i++] = new ActionsPerCharacterClass(actionsPerCharacterClass.characterClass, filteredActions);
            }
            ++n2;
        }
        return Arrays.copyOf(filteredActionsPerCharacterClasses, i);
    }
}

