/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.parsetable.characterclasses;

import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import org.metaborg.parsetable.characterclasses.CharacterClassRangeList;
import org.metaborg.parsetable.characterclasses.ICharacterClass;
import org.spoofax.interpreter.terms.IStrategoTerm;
import org.spoofax.interpreter.terms.ITermFactory;

public final class CharacterClassOptimized
implements ICharacterClass,
Serializable {
    private static final long serialVersionUID = -7493425262859611574L;
    static final int BITMAP_SIZE = 256;
    static final int BITMAP_SEGMENT_SIZE = 6;
    static final CharacterClassRangeList OPTIMIZED_RANGE;
    private final long[] words;
    private final int[] originalRanges;
    private final int[] optimizedRanges;
    private final boolean containsEOF;
    private final int min;
    private final int max;

    static {
        int[] nArray = new int[2];
        nArray[1] = 255;
        OPTIMIZED_RANGE = new CharacterClassRangeList(nArray, false);
    }

    public CharacterClassOptimized(CharacterClassRangeList cc) {
        if (cc.isEmpty()) {
            throw new IllegalStateException("Empty character classes are not allowed");
        }
        this.originalRanges = cc.getRanges();
        if (this.originalRanges.length == 0) {
            this.words = new long[0];
        } else {
            BitSet bitSet = new BitSet(256);
            int i = 0;
            while (i < this.originalRanges.length && this.originalRanges[i] < 256) {
                bitSet.set(this.originalRanges[i], Integer.min(256, this.originalRanges[i + 1] + 1));
                i += 2;
            }
            this.words = bitSet.toLongArray();
            assert (this.words.length <= 4);
        }
        this.optimizedRanges = this.words.length == 0 ? this.originalRanges : cc.difference(OPTIMIZED_RANGE).getRanges();
        this.containsEOF = cc.contains(-1);
        this.min = cc.min();
        this.max = cc.max();
    }

    @Override
    public final boolean contains(int character) {
        if (character <= -1) {
            return this.containsEOF;
        }
        int wordIndex = character >> 6;
        if (wordIndex < this.words.length) {
            return (this.words[wordIndex] & 1L << (character & 0x3F)) != 0L;
        }
        if (this.optimizedRanges.length == 0 || character < this.optimizedRanges[0] || character > this.optimizedRanges[this.optimizedRanges.length - 1]) {
            return false;
        }
        if (this.optimizedRanges.length == 2) {
            return this.optimizedRanges[0] <= character && character <= this.optimizedRanges[1];
        }
        int low = 0;
        int high = this.optimizedRanges.length - 1;
        int mid = -1;
        while (low < high) {
            mid = (low + high) / 2;
            if (character < this.optimizedRanges[mid]) {
                high = mid;
                continue;
            }
            if (character < this.optimizedRanges[mid + 1]) break;
            low = mid + 1;
        }
        return (mid & 1) == 0 || character == this.optimizedRanges[mid];
    }

    @Override
    public int min() {
        return this.min;
    }

    @Override
    public int max() {
        return this.max;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public int[] getRanges() {
        return this.originalRanges;
    }

    @Override
    public ICharacterClass setEOF(boolean eof) {
        throw new IllegalStateException("CharacterClassOptimized is not mutable");
    }

    @Override
    public ICharacterClass union(ICharacterClass other) {
        throw new IllegalStateException("Union can only be done with Single and RangeSet character classes");
    }

    @Override
    public ICharacterClass intersection(ICharacterClass other) {
        throw new IllegalStateException("Intersection can only be done with Single and RangeSet character classes");
    }

    @Override
    public ICharacterClass difference(ICharacterClass other) {
        throw new IllegalStateException("Difference can only be done with Single and RangeSet character classes");
    }

    @Override
    public IStrategoTerm toAtermList(ITermFactory tf) {
        throw new IllegalStateException("Optimized character class cannot be converted to ATerm");
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.originalRanges) ^ Boolean.hashCode(this.containsEOF);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterClassOptimized that = (CharacterClassOptimized)o;
        return Arrays.equals(this.words, that.words) && this.containsEOF == that.containsEOF;
    }

    public final String toString() {
        return "[...optimized-character-class...]";
    }
}

