/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.config;

import java.io.IOException;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.HierarchicalConfiguration;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.tree.ImmutableNode;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.metaborg.core.config.AConfigurationReaderWriter;
import org.metaborg.core.config.ConfigException;
import org.metaborg.core.config.ConfigRequest;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.messages.MessageBuilder;
import org.metaborg.util.file.IFileAccess;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;

public abstract class AConfigService<TSubject, TConfig> {
    private static final ILogger logger = LoggerUtils.logger(AConfigService.class);
    protected final AConfigurationReaderWriter configReaderWriter;

    protected AConfigService(AConfigurationReaderWriter configReaderWriter) {
        this.configReaderWriter = configReaderWriter;
    }

    public boolean available(FileObject rootDirectory) {
        try {
            FileObject configFile = this.getConfigFile(rootDirectory);
            return configFile.exists();
        }
        catch (FileSystemException e) {
            logger.debug("Cannot determine if configuration at root directory {} is available", e, rootDirectory);
            return false;
        }
    }

    public ConfigRequest<TConfig> get(FileObject rootDirectory) {
        FileObject configFile;
        try {
            configFile = this.getConfigFile(rootDirectory);
        }
        catch (FileSystemException e) {
            IMessage message = MessageBuilder.create().withMessage("Unable to locate configuration for root directory " + rootDirectory).withException(e).build();
            return new ConfigRequest(message);
        }
        return this.getFromConfigFile(configFile, rootDirectory);
    }

    public ConfigRequest<TConfig> getFromConfigFile(FileObject configFile, FileObject rootFolder) {
        HierarchicalConfiguration<ImmutableNode> configuration;
        try {
            configuration = this.readConfig(configFile, rootFolder);
        }
        catch (IOException | ConfigurationException e) {
            IMessage message = MessageBuilder.create().withSource(configFile).withMessage("Unable to read configuration from " + configFile).withException(e).build();
            return new ConfigRequest(message);
        }
        if (configuration != null) {
            return this.toConfig(configuration, configFile);
        }
        return new ConfigRequest();
    }

    public void write(TSubject subject, TConfig config, @Nullable IFileAccess access) throws ConfigException {
        FileObject rootDirectory;
        try {
            rootDirectory = this.getRootDirectory(subject);
        }
        catch (FileSystemException e) {
            throw new ConfigException("Unable to locate configuration for subject " + subject, e);
        }
        this.write(rootDirectory, config, access);
    }

    public void write(FileObject rootDirectory, TConfig config, @Nullable IFileAccess access) throws ConfigException {
        FileObject configFile;
        try {
            configFile = this.getConfigFile(rootDirectory);
        }
        catch (FileSystemException e) {
            throw new ConfigException("Unable to locate configuration at root directory " + rootDirectory, e);
        }
        if (access != null) {
            access.write(configFile);
        }
        HierarchicalConfiguration<ImmutableNode> configuration = this.fromConfig(config);
        this.writeConfig(configFile, configuration, rootDirectory);
    }

    @Nullable
    protected HierarchicalConfiguration<ImmutableNode> readConfig(FileObject configFile, FileObject rootDirectory) throws IOException, ConfigurationException {
        if (!configFile.exists()) {
            return null;
        }
        return this.configReaderWriter.read(configFile, rootDirectory);
    }

    protected void writeConfig(FileObject configFile, @Nullable HierarchicalConfiguration<ImmutableNode> config, @Nullable FileObject rootDirectory) throws ConfigException {
        if (config != null) {
            try {
                this.configReaderWriter.write(config, configFile, rootDirectory);
            }
            catch (IOException | ConfigurationException e) {
                throw new ConfigException("Unable to write configuration to " + configFile, e);
            }
        }
        try {
            configFile.delete();
        }
        catch (FileSystemException e) {
            throw new ConfigException("Unable to delete configuration at " + configFile, e);
        }
    }

    protected FileObject getConfigFile(TSubject subject) throws FileSystemException {
        return this.getConfigFile(this.getRootDirectory(subject));
    }

    protected abstract FileObject getRootDirectory(TSubject var1) throws FileSystemException;

    protected abstract FileObject getConfigFile(FileObject var1) throws FileSystemException;

    protected abstract ConfigRequest<TConfig> toConfig(HierarchicalConfiguration<ImmutableNode> var1, FileObject var2);

    protected abstract HierarchicalConfiguration<ImmutableNode> fromConfig(TConfig var1);
}

