/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.build;

import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.analysis.IAnalyzeUnitUpdate;
import org.metaborg.core.build.BuildState;
import org.metaborg.core.build.IBuildOutputInternal;
import org.metaborg.core.messages.IMessage;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.core.transform.ITransformUnit;
import org.metaborg.core.unit.IUnit;

public class BuildOutput<P extends IParseUnit, A extends IAnalyzeUnit, AU extends IAnalyzeUnitUpdate, T extends ITransformUnit<?>>
implements IBuildOutputInternal<P, A, AU, T> {
    private boolean success = true;
    public BuildState state;
    public final Set<FileName> removedResources = Sets.newHashSet();
    public final Set<FileName> includedResources = Sets.newHashSet();
    public final Collection<FileObject> changedResources = Lists.newArrayList();
    public final Collection<P> parseResults = Lists.newArrayList();
    public final Collection<A> analysisResults = Lists.newArrayList();
    public final Collection<AU> analysisUpdates = Lists.newArrayList();
    public final Collection<T> transformResults = Lists.newArrayList();
    public final Collection<IMessage> extraMessages = Lists.newLinkedList();

    @Override
    public boolean success() {
        return this.success;
    }

    @Override
    public BuildState state() {
        return this.state;
    }

    @Override
    public Set<FileName> removedResources() {
        return this.removedResources;
    }

    @Override
    public Set<FileName> includedResources() {
        return this.includedResources;
    }

    @Override
    public Iterable<FileObject> changedResources() {
        return this.changedResources;
    }

    @Override
    public Iterable<P> parseResults() {
        return this.parseResults;
    }

    @Override
    public Iterable<A> analysisResults() {
        return this.analysisResults;
    }

    @Override
    public Iterable<AU> analysisUpdates() {
        return this.analysisUpdates;
    }

    @Override
    public Iterable<T> transformResults() {
        return this.transformResults;
    }

    @Override
    public Iterable<IMessage> extraMessages() {
        return this.extraMessages;
    }

    @Override
    public Iterable<IMessage> allMessages() {
        LinkedList messages = Lists.newLinkedList();
        for (IUnit result : this.parseResults) {
            Iterables.addAll((Collection)messages, result.messages());
        }
        for (IUnit result : this.analysisResults) {
            Iterables.addAll((Collection)messages, result.messages());
        }
        for (IUnit result : this.transformResults) {
            Iterables.addAll((Collection)messages, result.messages());
        }
        return messages;
    }

    @Override
    public void setState(BuildState state) {
        this.state = state;
    }

    @Override
    public void add(boolean success, Iterable<FileName> removedResources, Iterable<FileName> includedResources, Iterable<FileObject> changedResources, Iterable<P> parseResults, Iterable<A> analysisResults, Iterable<AU> analysisUpdates, Iterable<T> transformResults, Iterable<IMessage> extraMessages) {
        this.success &= success;
        Iterables.addAll(this.removedResources, removedResources);
        Iterables.addAll(this.includedResources, includedResources);
        Iterables.addAll(this.changedResources, changedResources);
        Iterables.addAll(this.parseResults, parseResults);
        Iterables.addAll(this.analysisResults, analysisResults);
        Iterables.addAll(this.analysisUpdates, analysisUpdates);
        Iterables.addAll(this.transformResults, transformResults);
        Iterables.addAll(this.extraMessages, extraMessages);
    }
}

