/*
 * Decompiled with CFR 0.152.
 */
package org.metaborg.core.analysis;

import org.metaborg.core.analysis.AnalysisException;
import org.metaborg.core.analysis.AnalyzerFacet;
import org.metaborg.core.analysis.IAnalysisService;
import org.metaborg.core.analysis.IAnalyzeResult;
import org.metaborg.core.analysis.IAnalyzeResults;
import org.metaborg.core.analysis.IAnalyzeUnit;
import org.metaborg.core.analysis.IAnalyzeUnitUpdate;
import org.metaborg.core.analysis.IAnalyzer;
import org.metaborg.core.context.IContext;
import org.metaborg.core.language.ILanguageImpl;
import org.metaborg.core.syntax.IParseUnit;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;

public class AnalysisService<P extends IParseUnit, A extends IAnalyzeUnit, AU extends IAnalyzeUnitUpdate>
implements IAnalysisService<P, A, AU> {
    private static final ILogger logger = LoggerUtils.logger(AnalysisService.class);

    @Override
    public boolean available(ILanguageImpl langImpl) {
        return langImpl.hasFacet(AnalyzerFacet.class);
    }

    @Override
    public IAnalyzeResult<A, AU> analyze(P input, IContext context, IProgress progress, ICancel cancel) throws AnalysisException, InterruptedException {
        ILanguageImpl langImpl = context.language();
        AnalyzerFacet<P, A, AU> facet = this.facet(langImpl);
        if (facet == null) {
            String message = logger.format("Cannot get an analyzer for {}", langImpl);
            throw new AnalysisException(context, message);
        }
        IAnalyzer analyzer = facet.analyzer;
        return analyzer.analyze(input, context, progress, cancel);
    }

    @Override
    public IAnalyzeResults<A, AU> analyzeAll(Iterable<P> inputs, IContext context, IProgress progress, ICancel cancel) throws AnalysisException, InterruptedException {
        ILanguageImpl langImpl = context.language();
        AnalyzerFacet<P, A, AU> facet = this.facet(langImpl);
        if (facet == null) {
            String message = logger.format("Cannot get an analyzer for {}", langImpl);
            throw new AnalysisException(context, message);
        }
        IAnalyzer analyzer = facet.analyzer;
        return analyzer.analyzeAll(inputs, context, progress, cancel);
    }

    private AnalyzerFacet<P, A, AU> facet(ILanguageImpl langImpl) {
        return langImpl.facet(AnalyzerFacet.class);
    }
}

