/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import mb.nabl2.terms.IBlobTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.statix.solver.IConstraint;
import mb.statix.solver.IState;
import mb.statix.solver.completeness.IsComplete;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.Solver;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spec.Spec;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.tuple.Tuple2;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_solve_multi_file
extends StatixPrimitive {
    private static final ILogger logger = LoggerUtils.logger(STX_solve_multi_file.class);

    @Inject
    public STX_solve_multi_file() {
        super(STX_solve_multi_file.class.getSimpleName(), 5);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        Spec spec = StatixTerms.spec().match(terms.get(0)).orElseThrow(() -> new InterpreterException("Expected spec."));
        this.reportOverlappingRules(spec);
        SolverResult initial = TermMatch.M.blobValue(SolverResult.class).match(terms.get(1)).orElseThrow(() -> new InterpreterException("Expected solver result."));
        IDebugContext debug = this.getDebugContext(terms.get(2));
        IProgress progress = this.getProgress(terms.get(3));
        ICancel cancel = this.getCancel(terms.get(4));
        TermMatch.IMatcher<Tuple2> constraintMatcher = TermMatch.M.tuple2(TermMatch.M.stringValue(), StatixTerms.constraint(), (t, r, c) -> Tuple2.of(r, c));
        Function1<Tuple2, ITerm> solveConstraint = resource_constraint -> this.solveConstraint(spec, initial.state().withResource((String)resource_constraint._1()), (IConstraint)resource_constraint._2(), debug, progress, cancel);
        List<Tuple2> constraints = TermMatch.M.listElems(constraintMatcher).match(term).orElseThrow(() -> new InterpreterException("Expected list of constraints."));
        double t0 = System.currentTimeMillis();
        List results = (List)((Stream)constraints.stream().parallel()).map(solveConstraint::apply).collect(ImmutableList.toImmutableList());
        double dt = (double)System.currentTimeMillis() - t0;
        logger.info("Files analyzed in {} s", dt / 1000.0);
        return Optional.of(TermBuild.B.newList(results));
    }

    private ITerm solveConstraint(Spec spec, IState.Immutable state, IConstraint constraint, IDebugContext debug, IProgress progress, ICancel cancel) {
        SolverResult resultConfig;
        IsComplete isComplete = (s, l, st) -> !state.scopes().contains(s);
        try {
            resultConfig = Solver.solve(spec, state, constraint, isComplete, debug, cancel, progress, 0);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        IBlobTerm resultTerm = TermBuild.B.newBlob(resultConfig);
        return resultTerm;
    }
}

