/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.spoofax;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.TermBuild;
import mb.nabl2.terms.matching.TermMatch;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.IState;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.spoofax.StatixPrimitive;
import mb.statix.spoofax.StatixTerms;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.spoofax.interpreter.core.IContext;
import org.spoofax.interpreter.core.InterpreterException;

public class STX_debug_scopegraph
extends StatixPrimitive {
    private static final ILogger logger = LoggerUtils.logger(STX_debug_scopegraph.class);

    @Inject
    public STX_debug_scopegraph() {
        super(STX_debug_scopegraph.class.getSimpleName(), 0);
    }

    @Override
    protected Optional<? extends ITerm> call(IContext env, ITerm term, List<ITerm> terms) throws InterpreterException {
        List analyses = (List)TermMatch.M.cases(TermMatch.M.blobValue(SolverResult.class).map(ImmutableList::of), TermMatch.M.listElems(TermMatch.M.blobValue(SolverResult.class))).match(term).orElseThrow(() -> new InterpreterException("Expected solver result."));
        HashMap edgeEntries = Maps.newHashMap();
        HashMap relationEntries = Maps.newHashMap();
        HashSet dataScopes = Sets.newHashSet();
        for (SolverResult analysis : analyses) {
            this.addScopeEntries(analysis, edgeEntries, relationEntries, dataScopes);
        }
        ArrayList scopeEntries = Lists.newArrayList();
        for (Scope scope : Sets.union(edgeEntries.keySet(), relationEntries.keySet())) {
            if (dataScopes.contains(scope)) {
                if (relationEntries.containsKey(scope) && !((ListMultimap)relationEntries.get(scope)).isEmpty()) {
                    logger.warn("Data scope {} has relations {}. The inlined scope graph will be incomplete.", scope, ((ListMultimap)relationEntries.get(scope)).keySet());
                }
                if (!edgeEntries.containsKey(scope) || ((ListMultimap)edgeEntries.get(scope)).isEmpty()) continue;
                logger.warn("Data scope {} has edges {}. The inlined scope graph will be incomplete.", scope, edgeEntries.get(scope));
                continue;
            }
            ITerm relations = Optional.ofNullable((ListMultimap)relationEntries.get(scope)).map(rs -> {
                ArrayList lblDatums = Lists.newArrayList();
                rs.asMap().entrySet().forEach(rr -> {
                    ITerm lbl_datum = TermBuild.B.newTuple((ITerm)rr.getKey(), TermBuild.B.newList(StatixTerms.explicateVars((Iterable)rr.getValue())));
                    lblDatums.add(lbl_datum);
                });
                return TermBuild.B.newList(lblDatums);
            }).orElse(TermBuild.B.newList(new ITerm[0]));
            ITerm edges = Optional.ofNullable((ListMultimap)edgeEntries.get(scope)).map(es -> {
                ArrayList lblTgts = Lists.newArrayList();
                es.asMap().entrySet().forEach(ee -> {
                    ITerm lbl_tgt = TermBuild.B.newTuple((ITerm)ee.getKey(), TermBuild.B.newList(StatixTerms.explicateVars((Iterable)ee.getValue())));
                    lblTgts.add(lbl_tgt);
                });
                return TermBuild.B.newList(lblTgts);
            }).orElse(TermBuild.B.newList(new ITerm[0]));
            scopeEntries.add(TermBuild.B.newAppl("InlinedEntry", StatixTerms.explicateVars(scope), relations, edges));
        }
        return Optional.of(TermBuild.B.newAppl("ScopeGraph", TermBuild.B.newList(scopeEntries)));
    }

    private void addScopeEntries(SolverResult analysis, Map<Scope, ListMultimap<ITerm, Scope>> edgeEntries, Map<Scope, ListMultimap<ITerm, ITerm>> relationEntries, Set<Scope> dataScopes) {
        IState.Immutable state = analysis.state();
        IScopeGraph scopeGraph = state.scopeGraph();
        IUniDisunifier.Immutable unifier = state.unifier();
        ImmutableSet<ITerm> dataLabels = analysis.spec().dataLabels();
        scopeGraph.getEdges().forEach((arg_0, arg_1) -> STX_debug_scopegraph.lambda$6(dataLabels, relationEntries, dataScopes, (IScopeGraph.Immutable)scopeGraph, unifier, edgeEntries, arg_0, arg_1));
    }

    private static /* synthetic */ void lambda$6(Set set, Map map, Set set2, IScopeGraph.Immutable immutable, IUniDisunifier.Immutable immutable2, Map map2, Map.Entry src_lbl, Iterable tgts) {
        Scope src = (Scope)src_lbl.getKey();
        ITerm lbl = (ITerm)src_lbl.getValue();
        if (set.contains(lbl)) {
            ListMultimap relations = (ListMultimap)map.getOrDefault(src, LinkedListMultimap.create());
            for (Scope tgt : tgts) {
                set2.add(tgt);
                immutable.getData(tgt).ifPresent(d -> {
                    d = immutable2.findRecursive((ITerm)d);
                    relations.put((Object)lbl, d);
                });
            }
            map.put(src, relations);
        } else {
            ListMultimap edges = (ListMultimap)map2.getOrDefault(src, LinkedListMultimap.create());
            edges.putAll((Object)lbl, tgts);
            map2.put(src, edges);
        }
    }
}

