/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.constraints;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.substitution.FreshVars;
import mb.nabl2.terms.substitution.IRenaming;
import mb.nabl2.terms.substitution.ISubstitution;
import mb.nabl2.util.TermFormatter;
import mb.statix.solver.IConstraint;
import mb.statix.solver.completeness.ICompleteness;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.functions.Action1;

public class CExists
implements IConstraint,
Serializable {
    private static final long serialVersionUID = 1L;
    private final Set.Immutable<ITermVar> vars;
    private final IConstraint constraint;
    @Nullable
    private final IConstraint cause;
    @Nullable
    private final ICompleteness.Immutable bodyCriticalEdges;
    private volatile Set.Immutable<ITermVar> freeVars;
    private volatile int hashCode;

    public CExists(Iterable<ITermVar> vars, IConstraint constraint) {
        this(vars, constraint, null, null, null);
    }

    public CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause) {
        this(vars, constraint, cause, null, null);
    }

    public CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause, ICompleteness.Immutable bodyCriticalEdges) {
        this(vars, constraint, cause, bodyCriticalEdges, null);
    }

    private CExists(Iterable<ITermVar> vars, IConstraint constraint, @Nullable IConstraint cause, @Nullable ICompleteness.Immutable bodyCriticalEdges, @Nullable Set.Immutable<ITermVar> freeVars) {
        this.vars = CapsuleUtil.toSet(vars);
        this.constraint = constraint;
        this.cause = cause;
        this.bodyCriticalEdges = bodyCriticalEdges;
        this.freeVars = freeVars;
    }

    public Set.Immutable<ITermVar> vars() {
        return this.vars;
    }

    public IConstraint constraint() {
        return this.constraint;
    }

    public CExists withConstraint(IConstraint constraint) {
        return new CExists((Iterable<ITermVar>)this.vars, constraint, this.cause, this.bodyCriticalEdges, null);
    }

    @Override
    public Optional<IConstraint> cause() {
        return Optional.ofNullable(this.cause);
    }

    @Override
    public CExists withCause(@Nullable IConstraint cause) {
        return new CExists((Iterable<ITermVar>)this.vars, this.constraint, cause, this.bodyCriticalEdges, this.freeVars);
    }

    @Override
    public Optional<ICompleteness.Immutable> bodyCriticalEdges() {
        return Optional.ofNullable(this.bodyCriticalEdges);
    }

    @Override
    public CExists withBodyCriticalEdges(@Nullable ICompleteness.Immutable criticalEdges) {
        return new CExists((Iterable<ITermVar>)this.vars, this.constraint, this.cause, criticalEdges, this.freeVars);
    }

    @Override
    public <R> R match(IConstraint.Cases<R> cases) {
        return cases.caseExists(this);
    }

    @Override
    public <R, E extends Throwable> R matchOrThrow(IConstraint.CheckedCases<R, E> cases) throws E {
        return cases.caseExists(this);
    }

    @Override
    public Set.Immutable<ITermVar> getVars() {
        return Set.Immutable.union(this.vars, this.constraint.getVars());
    }

    @Override
    public Set.Immutable<ITermVar> freeVars() {
        Set.Immutable result = this.freeVars;
        if (this.freeVars == null) {
            Set.Transient _freeVars = CapsuleUtil.transientSet();
            this.doVisitFreeVars(arg_0 -> _freeVars.__insert(arg_0));
            this.freeVars = result = _freeVars.freeze();
        }
        return result;
    }

    @Override
    public void visitFreeVars(Action1<ITermVar> onFreeVar) {
        this.freeVars().forEach(onFreeVar::apply);
    }

    private void doVisitFreeVars(Action1<ITermVar> onFreeVar) {
        this.constraint.visitFreeVars(v -> {
            if (!this.vars.contains(v)) {
                onFreeVar.apply((ITermVar)v);
            }
        });
    }

    @Override
    public CExists apply(ISubstitution.Immutable subst) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.vars).retainAll((Iterable<ITermVar>)this.freeVars());
        if (localSubst.isEmpty()) {
            return this;
        }
        IConstraint constraint = this.constraint;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        Set.Immutable freeVars = this.freeVars;
        if (freeVars != null) {
            freeVars = freeVars.__removeAll(localSubst.domainSet()).__insertAll(localSubst.rangeSet());
        }
        FreshVars fresh = new FreshVars(new Set[]{localSubst.domainSet(), localSubst.rangeSet(), this.freeVars()});
        IRenaming ren = fresh.fresh((Set<ITermVar>)this.vars);
        Set.Immutable<ITermVar> vars = fresh.fix();
        if (!ren.isEmpty()) {
            localSubst = ren.asSubstitution().compose(localSubst);
        }
        constraint = constraint.apply(localSubst);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(localSubst);
        }
        return new CExists((Iterable<ITermVar>)vars, constraint, this.cause, bodyCriticalEdges, (Set.Immutable<ITermVar>)freeVars);
    }

    @Override
    public CExists unsafeApply(ISubstitution.Immutable subst) {
        ISubstitution.Immutable localSubst = subst.removeAll((Iterable<ITermVar>)this.vars);
        if (localSubst.isEmpty()) {
            return this;
        }
        IConstraint constraint = this.constraint;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        constraint = constraint.unsafeApply(localSubst);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(localSubst);
        }
        return new CExists((Iterable<ITermVar>)this.vars, constraint, this.cause, bodyCriticalEdges, null);
    }

    @Override
    public CExists apply(IRenaming subst) {
        Set.Immutable<ITermVar> vars = this.vars;
        IConstraint constraint = this.constraint;
        ICompleteness.Immutable bodyCriticalEdges = this.bodyCriticalEdges;
        vars = CapsuleUtil.toSet(subst.rename((Set<ITermVar>)vars));
        constraint = constraint.apply(subst);
        if (bodyCriticalEdges != null) {
            bodyCriticalEdges = bodyCriticalEdges.apply(subst);
        }
        return new CExists((Iterable<ITermVar>)vars, constraint, this.cause, bodyCriticalEdges, null);
    }

    @Override
    public String toString(TermFormatter termToString) {
        StringBuilder sb = new StringBuilder();
        sb.append("{").append(termToString.format((Iterable<? extends ITerm>)this.vars)).append("} ");
        sb.append(this.constraint.toString(termToString));
        return sb.toString();
    }

    public String toString() {
        return this.toString(Object::toString);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CExists cExists = (CExists)o;
        return Objects.equals(this.vars, cExists.vars) && Objects.equals(this.constraint, cExists.constraint) && Objects.equals(this.cause, cExists.cause);
    }

    public int hashCode() {
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = result = Objects.hash(this.vars, this.constraint, this.cause);
        }
        return result;
    }
}

