/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AStatixProject;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixLibrary;
import mb.statix.concurrent.IStatixProject;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.SolverState;
import mb.statix.scopegraph.Scope;
import mb.statix.spec.Rule;

public final class StatixProject
extends AStatixProject {
    private final String resource;
    private final Rule rule;
    private final ImmutableMap<String, IStatixGroup> groups;
    private final ImmutableMap<String, IStatixUnit> units;
    private final ImmutableMap<String, IStatixLibrary> libraries;
    private final boolean changed;
    @Nullable
    private final IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult;
    private transient int hashCode;

    private StatixProject(String resource, Optional<? extends Rule> rule, Map<String, ? extends IStatixGroup> groups, Map<String, ? extends IStatixUnit> units, Map<String, ? extends IStatixLibrary> libraries, boolean changed, @Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult) {
        this.resource = Objects.requireNonNull(resource, "resource");
        this.rule = rule.orElse(null);
        this.groups = ImmutableMap.copyOf(groups);
        this.units = ImmutableMap.copyOf(units);
        this.libraries = ImmutableMap.copyOf(libraries);
        this.changed = changed;
        this.previousResult = previousResult;
    }

    private StatixProject(StatixProject original, String resource, Rule rule, ImmutableMap<String, IStatixGroup> groups, ImmutableMap<String, IStatixUnit> units, ImmutableMap<String, IStatixLibrary> libraries, boolean changed, @Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult) {
        this.resource = resource;
        this.rule = rule;
        this.groups = groups;
        this.units = units;
        this.libraries = libraries;
        this.changed = changed;
        this.previousResult = previousResult;
    }

    @Override
    public String resource() {
        return this.resource;
    }

    @Override
    public Optional<Rule> rule() {
        return Optional.ofNullable(this.rule);
    }

    public ImmutableMap<String, IStatixGroup> groups() {
        return this.groups;
    }

    public ImmutableMap<String, IStatixUnit> units() {
        return this.units;
    }

    public ImmutableMap<String, IStatixLibrary> libraries() {
        return this.libraries;
    }

    @Override
    public boolean changed() {
        return this.changed;
    }

    @Override
    @Nullable
    public IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult() {
        return this.previousResult;
    }

    public final StatixProject withResource(String value) {
        String newValue = Objects.requireNonNull(value, "resource");
        if (this.resource.equals(newValue)) {
            return this;
        }
        return new StatixProject(this, newValue, this.rule, this.groups, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject withRule(Rule value) {
        Rule newValue = Objects.requireNonNull(value, "rule");
        if (this.rule == newValue) {
            return this;
        }
        return new StatixProject(this, this.resource, newValue, this.groups, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject withRule(Optional<? extends Rule> optional) {
        Rule value = optional.orElse(null);
        if (this.rule == value) {
            return this;
        }
        return new StatixProject(this, this.resource, value, this.groups, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject withGroups(Map<String, ? extends IStatixGroup> entries) {
        if (this.groups == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixProject(this, this.resource, this.rule, (ImmutableMap<String, IStatixGroup>)newValue, this.units, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject withUnits(Map<String, ? extends IStatixUnit> entries) {
        if (this.units == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixProject(this, this.resource, this.rule, this.groups, (ImmutableMap<String, IStatixUnit>)newValue, this.libraries, this.changed, this.previousResult);
    }

    public final StatixProject withLibraries(Map<String, ? extends IStatixLibrary> entries) {
        if (this.libraries == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new StatixProject(this, this.resource, this.rule, this.groups, this.units, (ImmutableMap<String, IStatixLibrary>)newValue, this.changed, this.previousResult);
    }

    public final StatixProject withChanged(boolean value) {
        if (this.changed == value) {
            return this;
        }
        return new StatixProject(this, this.resource, this.rule, this.groups, this.units, this.libraries, value, this.previousResult);
    }

    public final StatixProject withPreviousResult(@Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> value) {
        if (this.previousResult == value) {
            return this;
        }
        return new StatixProject(this, this.resource, this.rule, this.groups, this.units, this.libraries, this.changed, value);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof StatixProject && this.equalTo((StatixProject)another);
    }

    private boolean equalTo(StatixProject another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.resource.equals(another.resource) && Objects.equals(this.rule, another.rule) && this.groups.equals(another.groups) && this.units.equals(another.units) && this.libraries.equals(another.libraries) && this.changed == another.changed && Objects.equals(this.previousResult, another.previousResult);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.resource.hashCode();
        h += (h << 5) + Objects.hashCode(this.rule);
        h += (h << 5) + this.groups.hashCode();
        h += (h << 5) + this.units.hashCode();
        h += (h << 5) + this.libraries.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.changed);
        h += (h << 5) + Objects.hashCode(this.previousResult);
        return h;
    }

    public static StatixProject of(String resource, Optional<? extends Rule> rule, Map<String, ? extends IStatixGroup> groups, Map<String, ? extends IStatixUnit> units, Map<String, ? extends IStatixLibrary> libraries, boolean changed, @Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult) {
        return new StatixProject(resource, rule, groups, units, libraries, changed, previousResult);
    }

    public static StatixProject copyOf(AStatixProject instance) {
        if (instance instanceof StatixProject) {
            return (StatixProject)instance;
        }
        return StatixProject.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StatixProject(StatixProject statixProject, String string, Rule rule, ImmutableMap immutableMap, ImmutableMap immutableMap2, ImmutableMap immutableMap3, boolean bl, IUnitResult iUnitResult, StatixProject statixProject2) {
        this(statixProject, string, rule, (ImmutableMap<String, IStatixGroup>)immutableMap, (ImmutableMap<String, IStatixUnit>)immutableMap2, (ImmutableMap<String, IStatixLibrary>)immutableMap3, bl, iUnitResult);
    }

    public static final class Builder {
        private static final long INIT_BIT_RESOURCE = 1L;
        private static final long INIT_BIT_CHANGED = 2L;
        private long initBits = 3L;
        private String resource;
        private Rule rule;
        private ImmutableMap.Builder<String, IStatixGroup> groups = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IStatixUnit> units = ImmutableMap.builder();
        private ImmutableMap.Builder<String, IStatixLibrary> libraries = ImmutableMap.builder();
        private boolean changed;
        private IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult;

        private Builder() {
        }

        public final Builder from(IStatixProject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AStatixProject instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<Rule> ruleOptional;
            IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResultValue;
            IStatixProject instance;
            long bits = 0L;
            if (object instanceof IStatixProject) {
                instance = (IStatixProject)object;
                if ((bits & 1L) == 0L) {
                    previousResultValue = instance.previousResult();
                    if (previousResultValue != null) {
                        this.previousResult(previousResultValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.resource(instance.resource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllLibraries(instance.libraries());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    ruleOptional = instance.rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllGroups(instance.groups());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.putAllUnits(instance.units());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.changed(instance.changed());
                    bits |= 0x40L;
                }
            }
            if (object instanceof AStatixProject) {
                instance = (AStatixProject)object;
                if ((bits & 1L) == 0L) {
                    previousResultValue = ((AStatixProject)instance).previousResult();
                    if (previousResultValue != null) {
                        this.previousResult(previousResultValue);
                    }
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.resource(((AStatixProject)instance).resource());
                    bits |= 2L;
                }
                if ((bits & 4L) == 0L) {
                    this.putAllLibraries(((AStatixProject)instance).libraries());
                    bits |= 4L;
                }
                if ((bits & 8L) == 0L) {
                    ruleOptional = ((AStatixProject)instance).rule();
                    if (ruleOptional.isPresent()) {
                        this.rule(ruleOptional);
                    }
                    bits |= 8L;
                }
                if ((bits & 0x10L) == 0L) {
                    this.putAllGroups(((AStatixProject)instance).groups());
                    bits |= 0x10L;
                }
                if ((bits & 0x20L) == 0L) {
                    this.putAllUnits(((AStatixProject)instance).units());
                    bits |= 0x20L;
                }
                if ((bits & 0x40L) == 0L) {
                    this.changed(((AStatixProject)instance).changed());
                    bits |= 0x40L;
                }
            }
        }

        public final Builder resource(String resource) {
            this.resource = Objects.requireNonNull(resource, "resource");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder rule(Rule rule) {
            this.rule = Objects.requireNonNull(rule, "rule");
            return this;
        }

        public final Builder rule(Optional<? extends Rule> rule) {
            this.rule = rule.orElse(null);
            return this;
        }

        public final Builder putGroups(String key, IStatixGroup value) {
            this.groups.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putGroups(Map.Entry<String, ? extends IStatixGroup> entry) {
            this.groups.put(entry);
            return this;
        }

        public final Builder groups(Map<String, ? extends IStatixGroup> entries) {
            this.groups = ImmutableMap.builder();
            return this.putAllGroups(entries);
        }

        public final Builder putAllGroups(Map<String, ? extends IStatixGroup> entries) {
            this.groups.putAll(entries);
            return this;
        }

        public final Builder putUnits(String key, IStatixUnit value) {
            this.units.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putUnits(Map.Entry<String, ? extends IStatixUnit> entry) {
            this.units.put(entry);
            return this;
        }

        public final Builder units(Map<String, ? extends IStatixUnit> entries) {
            this.units = ImmutableMap.builder();
            return this.putAllUnits(entries);
        }

        public final Builder putAllUnits(Map<String, ? extends IStatixUnit> entries) {
            this.units.putAll(entries);
            return this;
        }

        public final Builder putLibraries(String key, IStatixLibrary value) {
            this.libraries.put((Object)key, (Object)value);
            return this;
        }

        public final Builder putLibraries(Map.Entry<String, ? extends IStatixLibrary> entry) {
            this.libraries.put(entry);
            return this;
        }

        public final Builder libraries(Map<String, ? extends IStatixLibrary> entries) {
            this.libraries = ImmutableMap.builder();
            return this.putAllLibraries(entries);
        }

        public final Builder putAllLibraries(Map<String, ? extends IStatixLibrary> entries) {
            this.libraries.putAll(entries);
            return this;
        }

        public final Builder changed(boolean changed) {
            this.changed = changed;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder previousResult(@Nullable IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, ProjectResult, SolverState>> previousResult) {
            this.previousResult = previousResult;
            return this;
        }

        public StatixProject build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StatixProject(null, this.resource, this.rule, this.groups.build(), this.units.build(), this.libraries.build(), this.changed, this.previousResult, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resource");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("changed");
            }
            return "Cannot build StatixProject, some of required attributes are not set " + attributes;
        }
    }
}

