/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import mb.nabl2.terms.ITerm;
import mb.p_raffrayi.IIncrementalTypeCheckerContext;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.statix.concurrent.AbstractTypeChecker;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.IStatixProject;
import mb.statix.concurrent.ProjectResult;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.UnitResult;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.log.IDebugContext;
import mb.statix.spec.Spec;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.unit.Unit;

public class ProjectTypeChecker
extends AbstractTypeChecker<ProjectResult> {
    private static final ILogger logger = LoggerUtils.logger(ProjectTypeChecker.class);
    private final IStatixProject project;

    public ProjectTypeChecker(IStatixProject project, Spec spec, IDebugContext debug) {
        super(spec, debug);
        this.project = project;
    }

    @Override
    public IFuture<ProjectResult> run(IIncrementalTypeCheckerContext<Scope, ITerm, ITerm, ProjectResult, SolverState> context, List<Scope> rootScopes) {
        Scope projectScope = this.makeSharedScope(context, "s_prj");
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Unit>>> libraryResults = this.runLibraries(context, this.project.libraries(), projectScope);
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>>> groupResults = this.runGroups(context, this.project.groups(), Arrays.asList(projectScope));
        IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>>> unitResults = this.runUnits(context, this.project.units(), Arrays.asList(projectScope));
        context.closeScope(projectScope);
        return context.runIncremental(initialState -> this.runSolver((ITypeCheckerContext<Scope, ITerm, ITerm>)context, this.project.rule(), (Optional<SolverState>)initialState, Arrays.asList(projectScope)), ProjectResult::solveResult, this::patch, (result, ex) -> AggregateFuture.apply(libraryResults, groupResults, unitResults).thenApply(e -> ProjectResult.of(this.project.resource(), projectScope, (Map)e._1(), (Map)e._2(), (Map)e._3(), result, ex))).whenComplete((r, __) -> logger.debug("project {}: returned.", context.id()));
    }
}

