/*
 * Decompiled with CFR 0.152.
 */
package mb.statix.concurrent;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.ITermVar;
import mb.nabl2.terms.stratego.TermIndex;
import mb.nabl2.terms.substitution.Replacement;
import mb.nabl2.terms.unification.ud.IUniDisunifier;
import mb.p_raffrayi.ITypeChecker;
import mb.p_raffrayi.ITypeCheckerContext;
import mb.p_raffrayi.IUnitResult;
import mb.p_raffrayi.impl.Result;
import mb.scopegraph.patching.IPatchCollection;
import mb.statix.concurrent.GroupResult;
import mb.statix.concurrent.GroupTypeChecker;
import mb.statix.concurrent.IStatixGroup;
import mb.statix.concurrent.IStatixLibrary;
import mb.statix.concurrent.IStatixUnit;
import mb.statix.concurrent.SolverState;
import mb.statix.concurrent.StatixSolver;
import mb.statix.concurrent.UnitResult;
import mb.statix.concurrent.UnitTypeChecker;
import mb.statix.scopegraph.Scope;
import mb.statix.solver.Delay;
import mb.statix.solver.IState;
import mb.statix.solver.ITermProperty;
import mb.statix.solver.completeness.Completeness;
import mb.statix.solver.completeness.ICompleteness;
import mb.statix.solver.log.IDebugContext;
import mb.statix.solver.persistent.SolverResult;
import mb.statix.solver.persistent.State;
import mb.statix.spec.ApplyMode;
import mb.statix.spec.ApplyResult;
import mb.statix.spec.Rule;
import mb.statix.spec.RuleUtil;
import mb.statix.spec.Spec;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.future.AggregateFuture;
import org.metaborg.util.future.CompletableFuture;
import org.metaborg.util.future.ICompletableFuture;
import org.metaborg.util.future.IFuture;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.NullCancel;
import org.metaborg.util.task.NullProgress;
import org.metaborg.util.tuple.Tuple2;
import org.metaborg.util.unit.Unit;

public abstract class AbstractTypeChecker<R extends ITypeChecker.IOutput<Scope, ITerm, ITerm>>
implements ITypeChecker<Scope, ITerm, ITerm, R, SolverState> {
    private static final ILogger logger = LoggerUtils.logger(AbstractTypeChecker.class);
    protected final Spec spec;
    protected final IDebugContext debug;
    private StatixSolver solver;
    private IFuture<SolverResult> solveResult;
    private final Multimap<ITerm, ICompletableFuture<ITerm>> pendingData = ArrayListMultimap.create();
    private boolean snapshotTaken = false;

    protected AbstractTypeChecker(Spec spec, IDebugContext debug) {
        this.spec = spec;
        this.debug = debug;
    }

    protected Scope makeSharedScope(ITypeCheckerContext<Scope, ITerm, ITerm> context, String name) {
        Scope s = context.stableFreshScope(name, Collections.emptyList(), true);
        context.setDatum(s, s);
        context.shareLocal(s);
        return s;
    }

    protected IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>>> runGroups(ITypeCheckerContext<Scope, ITerm, ITerm> context, Map<String, IStatixGroup> groups, List<Scope> parentScopes) {
        if (groups.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        ArrayList<IFuture<Tuple2>> results = new ArrayList<IFuture<Tuple2>>();
        for (Map.Entry<String, IStatixGroup> entry : groups.entrySet()) {
            String key = entry.getKey();
            IFuture<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, GroupResult, SolverState>>> result = context.add(key, new GroupTypeChecker(entry.getValue(), this.spec, this.debug), parentScopes, entry.getValue().changed());
            results.add(result.thenApply(r -> Tuple2.of(key, r)).whenComplete((r, ex) -> logger.debug("checker {}: group {} returned.", context.id(), key)));
        }
        return AggregateFuture.of(results).thenApply(es -> es.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).whenComplete((r, ex) -> logger.debug("checker {}: all groups returned.", context.id()));
    }

    protected IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>>> runUnits(ITypeCheckerContext<Scope, ITerm, ITerm> context, Map<String, IStatixUnit> units, List<Scope> parentScopes) {
        if (units.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        ArrayList<IFuture<Tuple2>> results = new ArrayList<IFuture<Tuple2>>();
        for (Map.Entry<String, IStatixUnit> entry : units.entrySet()) {
            String key = entry.getKey();
            IFuture<IUnitResult<Scope, ITerm, ITerm, Result<Scope, ITerm, ITerm, UnitResult, SolverState>>> result = context.add(key, new UnitTypeChecker(entry.getValue(), this.spec, this.debug), parentScopes, entry.getValue().changed());
            results.add(result.thenApply(r -> Tuple2.of(key, r)).whenComplete((r, ex) -> logger.debug("checker {}: unit {} returned.", context.id(), key)));
        }
        return AggregateFuture.of(results).thenApply(es -> es.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).whenComplete((r, ex) -> logger.debug("checker {}: all units returned.", context.id()));
    }

    protected IFuture<Map<String, IUnitResult<Scope, ITerm, ITerm, Unit>>> runLibraries(ITypeCheckerContext<Scope, ITerm, ITerm> context, Map<String, IStatixLibrary> libraries, Scope parentScope) {
        if (libraries.isEmpty()) {
            return CompletableFuture.completedFuture(Collections.emptyMap());
        }
        ArrayList<IFuture<Tuple2>> results = new ArrayList<IFuture<Tuple2>>();
        for (Map.Entry<String, IStatixLibrary> entry : libraries.entrySet()) {
            String key = entry.getKey();
            IStatixLibrary library = entry.getValue();
            IFuture<IUnitResult<Scope, ITerm, ITerm, Unit>> result = context.add(key, library, Arrays.asList(parentScope));
            results.add(result.thenApply(r -> Tuple2.of(key, r)).whenComplete((r, ex) -> logger.debug("checker {}: library {} returned.", context.id(), key)));
        }
        return AggregateFuture.of(results).thenApply(es -> es.stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).whenComplete((r, ex) -> logger.debug("checker {}: all libraries returned.", context.id()));
    }

    protected IFuture<SolverResult> runSolver(ITypeCheckerContext<Scope, ITerm, ITerm> context, Optional<Rule> rule, Optional<SolverState> initialState, List<Scope> scopes) {
        if (initialState.isPresent()) {
            return this.runSolver(context, initialState.get());
        }
        return this.runSolver(context, rule, scopes);
    }

    protected IFuture<SolverResult> runSolver(ITypeCheckerContext<Scope, ITerm, ITerm> context, Optional<Rule> rule, List<Scope> scopes) {
        ApplyResult applyResult;
        if (!rule.isPresent()) {
            for (Scope scope : scopes) {
                context.initScope(scope, Collections.emptyList(), false);
            }
            return CompletableFuture.completedFuture(SolverResult.of(this.spec));
        }
        State unitState = State.of().withResource(context.id());
        try {
            applyResult = RuleUtil.apply(unitState.unifier(), rule.get(), scopes, null, ApplyMode.STRICT, ApplyMode.Safety.UNSAFE).orElse(null);
            if (applyResult == null) {
                return CompletableFuture.completedExceptionally(new IllegalArgumentException("Cannot apply initial rule to root scope."));
            }
        }
        catch (Delay delay) {
            return CompletableFuture.completedExceptionally(new IllegalArgumentException("Cannot apply initial rule to root scope.", delay));
        }
        this.solver = new StatixSolver(applyResult.body(), this.spec, unitState, applyResult.criticalEdges(), this.debug, new NullProgress(), new NullCancel(), context, 0);
        this.solveResult = this.solver.solve(scopes);
        return this.finish(this.solveResult, context.id());
    }

    protected IFuture<SolverResult> runSolver(ITypeCheckerContext<Scope, ITerm, ITerm> context, SolverState initialState) {
        this.solver = new StatixSolver(initialState, this.spec, this.debug, new NullProgress(), new NullCancel(), context, 0);
        this.solveResult = this.solver.continueSolve();
        this.pendingData.forEach((d, future) -> {
            IFuture<ITerm> iFuture = this.solver.getExternalRepresentation((ITerm)d).whenComplete(future::complete);
        });
        this.pendingData.clear();
        return this.finish(this.solveResult, context.id());
    }

    private IFuture<SolverResult> finish(IFuture<SolverResult> future, String id) {
        return future.thenApply(r -> {
            logger.debug("checker {}: solver returned.", id);
            if (this.snapshotTaken) {
                this.solver = null;
            }
            return r;
        });
    }

    protected SolverResult patch(SolverResult previousResult, IPatchCollection.Immutable<Scope> patches) {
        if (patches.isIdentity()) {
            return previousResult;
        }
        Replacement.Builder builder = Replacement.builder().put(true);
        patches.patches().asMap().forEach((newScope, oldScope) -> builder.put((ITerm)oldScope, (ITerm)newScope));
        Replacement repl = builder.build();
        IState.Immutable oldState = previousResult.state();
        IUniDisunifier.Immutable unifier = oldState.unifier().replace(repl);
        Map.Transient props = CapsuleUtil.transientMap();
        oldState.termProperties().forEach((k, v) -> {
            Object object = props.__put(k, (Object)v.replace(repl));
        });
        Set.Transient scopes = oldState.scopes().asTransient();
        patches.patchDomain().forEach(s -> {
            if (scopes.__remove(s)) {
                scopes.__insert((Object)patches.patch((Scope)s));
            }
        });
        State newState = State.builder().from(oldState).__scopes((Set.Immutable<Scope>)scopes.freeze()).unifier(unifier).termProperties((Map.Immutable<Tuple2<TermIndex, ITerm>, ITermProperty>)props.freeze()).build();
        return previousResult.withState(newState);
    }

    @Override
    public IFuture<ITerm> getExternalDatum(ITerm datum) {
        if (datum.isGround()) {
            return CompletableFuture.completedFuture(datum);
        }
        if (this.solver != null) {
            return this.solver.getExternalRepresentation(datum);
        }
        if (this.solveResult != null) {
            return this.solveResult.thenCompose(r -> {
                IUniDisunifier.Immutable unifier = r.state().unifier();
                if (unifier.isGround(datum)) {
                    return CompletableFuture.completedFuture(unifier.findRecursive(datum));
                }
                return CompletableFuture.noFuture();
            });
        }
        CompletableFuture<ITerm> future = new CompletableFuture<ITerm>();
        this.pendingData.put((Object)datum, future);
        return future;
    }

    @Override
    public ITerm internalData(ITerm datum) {
        if (this.solver != null) {
            return this.solver.internalData(datum);
        }
        return datum;
    }

    @Override
    public SolverState snapshot() {
        if (this.solver == null) {
            return SolverState.of((IState.Immutable)State.of(), (ICompleteness.Immutable)Completeness.Immutable.of(), Sets.newHashSet(), null, Arrays.asList(new ITermVar[0]), Maps.newHashMap(), CapsuleUtil.immutableSet());
        }
        SolverState snapshot = this.solver.snapshot();
        this.snapshotTaken = true;
        if (this.solveResult.isDone()) {
            this.solver = null;
        }
        return snapshot;
    }
}

