/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.resolution;

import java.io.Serializable;
import java.util.Objects;
import mb.scopegraph.oopsla20.reference.ResolutionException;
import mb.scopegraph.resolution.RExp;

public final class RSubEnv<L>
implements RExp<L>,
Serializable {
    private static final long serialVersionUID = 1L;
    private final L label;
    private final String state;

    public RSubEnv(L label, String state) {
        this.label = label;
        this.state = state;
    }

    public L label() {
        return this.label;
    }

    public String state() {
        return this.state;
    }

    @Override
    public <R> R match(RExp.Cases<L, R> cases) {
        return cases.caseSubEnv(this.label, this.state);
    }

    @Override
    public <R, E extends Throwable> R matchInResolution(RExp.ResolutionCases<L, R> cases) throws ResolutionException, InterruptedException {
        return cases.caseSubEnv(this.label, this.state);
    }

    public String toString() {
        return "SubEnv " + this.label + " " + this.state;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        RSubEnv other = (RSubEnv)obj;
        return Objects.equals(this.label, other.label) && Objects.equals(this.state, other.state);
    }

    public int hashCode() {
        return Objects.hash(this.label, this.state);
    }
}

