/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.terms;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.terms.ANamespace;

public final class Namespace
extends ANamespace
implements Serializable {
    private final IAttachments attachments;
    private final String name;
    private final int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long OP_LAZY_INIT_BIT = 1L;
    private transient String op;
    private static final long ARGS_LAZY_INIT_BIT = 2L;
    private transient List<ITerm> args;
    private static final long serialVersionUID = 42L;

    private Namespace(String name) {
        this.name = Objects.requireNonNull(name, "name");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
        this.hashCode = super.hashCode();
    }

    private Namespace(IAttachments attachments, String name) {
        this.attachments = attachments;
        this.name = name;
        this.hashCode = super.hashCode();
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public final Namespace withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new Namespace(newValue, this.name);
    }

    public final Namespace withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new Namespace(this.attachments, newValue);
    }

    @Override
    public int hashCode() {
        return this.hashCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getOp() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Namespace namespace = this;
            synchronized (namespace) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.op = Objects.requireNonNull(super.getOp(), "op");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.op;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ITerm> getArgs() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Namespace namespace = this;
            synchronized (namespace) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.args = Objects.requireNonNull(super.getArgs(), "args");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.args;
    }

    public static Namespace of(String name) {
        return new Namespace(name);
    }

    public static Namespace copyOf(ANamespace instance) {
        if (instance instanceof Namespace) {
            return (Namespace)instance;
        }
        return Namespace.of(instance.getName()).withAttachments(instance.getAttachments());
    }

    private Object readResolve() throws ObjectStreamException {
        return new Namespace(this.attachments, this.name);
    }
}

