/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.bottomup;

import io.usethesource.capsule.Set;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import mb.nabl2.solver.ISolution;
import mb.nabl2.terms.ITerm;
import mb.scopegraph.pepm16.CriticalEdgeException;
import mb.scopegraph.pepm16.StuckException;
import mb.scopegraph.pepm16.bottomup.BUNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopNameResolution;
import mb.scopegraph.pepm16.esop15.IEsopScopeGraph;
import mb.scopegraph.pepm16.terms.Label;
import mb.scopegraph.pepm16.terms.Occurrence;
import mb.scopegraph.pepm16.terms.Scope;
import org.metaborg.util.collection.CapsuleUtil;
import org.metaborg.util.log.ILogger;
import org.metaborg.util.log.LoggerUtils;
import org.metaborg.util.task.ICancel;
import org.metaborg.util.task.IProgress;
import org.metaborg.util.time.AggregateTimer;

public class BUVerifier {
    private static ILogger logger = LoggerUtils.logger(BUVerifier.class);

    public static boolean verify(ISolution solution, ICancel cancel, IProgress progress) {
        boolean success = true;
        try {
            Collection decls;
            Collection<Object> result;
            logger.info("resolving with bottom-up resolution");
            AggregateTimer timer = new AggregateTimer(false);
            IEsopNameResolution<Scope, Label, Occurrence> nameResolution = solution.nameResolution();
            IEsopScopeGraph.Immutable<Scope, Label, Occurrence, ITerm> scopeGraph = solution.scopeGraph();
            BUNameResolution<Scope, Label, Occurrence> buNameResolution = BUNameResolution.of(solution.config().getResolutionParams(), scopeGraph, (s, l) -> false);
            logger.info("verifying {} references", scopeGraph.getAllRefs().size());
            for (Occurrence ref : scopeGraph.getAllRefs()) {
                try {
                    Collection paths = nameResolution.resolve(ref, cancel, progress);
                    timer.start();
                    result = buNameResolution.resolve(ref, cancel, progress);
                    timer.stop();
                    success &= BUVerifier.verifyEquals("resolve " + ref, paths, result, buNameResolution);
                }
                catch (CriticalEdgeException ex) {
                    timer.stop();
                    logger.error("[resolve {}] incomplete", ex, ref);
                    success &= false;
                }
                catch (StuckException ex) {
                    timer.stop();
                    logger.error("[resolve {}] stuck", ex, ref);
                    success &= false;
                }
            }
            logger.info("verifying {} visible", scopeGraph.getAllScopes().size());
            for (Scope scope : scopeGraph.getAllScopes()) {
                try {
                    decls = nameResolution.visible(scope, cancel, progress);
                    timer.start();
                    result = buNameResolution.visible(scope, cancel, progress);
                    timer.stop();
                    success &= BUVerifier.verifyEquals("visible " + scope, decls, result, buNameResolution);
                }
                catch (CriticalEdgeException ex) {
                    timer.stop();
                    logger.error("[visible {}] incomplete", ex, scope);
                    success &= false;
                }
                catch (StuckException ex) {
                    timer.stop();
                    logger.error("[visible {}] stuck", scope);
                    success &= false;
                }
            }
            logger.info("verifying {} reachable", scopeGraph.getAllScopes());
            for (Scope scope : scopeGraph.getAllScopes()) {
                try {
                    decls = nameResolution.reachable(scope, cancel, progress);
                    timer.start();
                    result = buNameResolution.reachable(scope, cancel, progress);
                    timer.stop();
                    success &= BUVerifier.verifyEquals("reachable " + scope, decls, result, buNameResolution);
                }
                catch (CriticalEdgeException ex) {
                    timer.stop();
                    logger.error("[reachable {}] incomplete", ex, scope);
                    success &= false;
                }
                catch (StuckException ex) {
                    timer.stop();
                    logger.error("[reachable {}] stuck", scope);
                    success &= false;
                }
            }
            logger.info("bottom-up resolution took {} s", (double)timer.total() / (double)TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS));
        }
        catch (InterruptedException e) {
            logger.error("bottom-up resolution interrupted", e);
            success = false;
        }
        return success;
    }

    private static <E> boolean verifyEquals(String tag, Collection<E> expected, Collection<E> actual, BUNameResolution<Scope, Label, Occurrence> bu) {
        Set.Immutable<E> expectedSet = CapsuleUtil.toSet(expected);
        Set.Immutable<E> actualSet = CapsuleUtil.toSet(actual);
        Set.Immutable missing = Set.Immutable.subtract(expectedSet, actualSet);
        Set.Immutable extra = Set.Immutable.subtract(actualSet, expectedSet);
        if (!missing.isEmpty() || !extra.isEmpty()) {
            Set.Immutable matched = Set.Immutable.intersect(actualSet, expectedSet);
            logger.info("[{}] {} matched {}", tag, matched.size(), matched);
        }
        if (!missing.isEmpty()) {
            logger.error("[{}] {} missing {}", tag, missing.size(), missing);
        }
        if (!extra.isEmpty()) {
            logger.error("[{}] {} extra {}", tag, extra.size(), extra);
        }
        return missing.isEmpty() && extra.isEmpty();
    }
}

