/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.pepm16.bottomup;

import java.util.Collection;
import mb.scopegraph.pepm16.ILabel;
import mb.scopegraph.pepm16.IOccurrence;
import mb.scopegraph.pepm16.IScope;
import mb.scopegraph.pepm16.bottomup.BUEnvKey;
import mb.scopegraph.pepm16.bottomup.BUPathKey;
import mb.scopegraph.pepm16.bottomup.BUPathSet;
import mb.scopegraph.pepm16.path.IDeclPath;
import mb.scopegraph.pepm16.terms.SpacedName;
import org.metaborg.util.functions.Function2;
import org.metaborg.util.functions.Predicate2;
import org.metaborg.util.tuple.Tuple2;

public class BUChanges<S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> {
    private final BUPathSet.Immutable<S, L, O, P> addedPaths;
    private final BUPathSet.Immutable<S, L, O, P> removedPaths;

    BUChanges(BUPathSet.Immutable<S, L, O, P> addedPaths, BUPathSet.Immutable<S, L, O, P> removedPaths) {
        this.addedPaths = addedPaths;
        this.removedPaths = removedPaths;
    }

    public boolean isEmpty() {
        return this.addedPaths.isEmpty() && this.removedPaths.isEmpty();
    }

    public BUPathSet.Immutable<S, L, O, P> addedPaths() {
        return this.addedPaths;
    }

    public BUPathSet.Immutable<S, L, O, P> removedPaths() {
        return this.removedPaths;
    }

    public <Q extends IDeclPath<S, L, O>> BUChanges<S, L, O, Q> flatMap(Function2<BUPathKey<L>, Collection<P>, Tuple2<BUPathKey<L>, Collection<Q>>> pathMapper) {
        BUPathSet.Transient mappedAddedPaths = BUPathSet.Transient.of();
        for (SpacedName an : this.addedPaths.names()) {
            for (BUPathKey ak : this.addedPaths.keys(an)) {
                pathMapper.apply(ak, this.addedPaths.paths(ak)).apply(mappedAddedPaths::add);
            }
        }
        BUPathSet.Transient mappedRemovedPaths = BUPathSet.Transient.of();
        for (SpacedName rn : this.removedPaths.names()) {
            for (BUPathKey rk : this.removedPaths.keys(rn)) {
                pathMapper.apply(rk, this.removedPaths.paths(rk)).apply(mappedRemovedPaths::add);
            }
        }
        return new BUChanges(mappedAddedPaths.freeze(), mappedRemovedPaths.freeze());
    }

    public BUChanges<S, L, O, P> filter(Predicate2<BUPathKey<L>, P> pathFilter) {
        return new BUChanges<S, L, O, P>(this.addedPaths.filter(pathFilter), this.removedPaths.filter(pathFilter));
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> BUChanges<S, L, O, P> of(BUEnvKey<S, L> origin) {
        return new BUChanges(BUPathSet.Immutable.of(), BUPathSet.Immutable.of());
    }

    public static <S extends IScope, L extends ILabel, O extends IOccurrence, P extends IDeclPath<S, L, O>> BUChanges<S, L, O, P> ofPaths(BUEnvKey<S, L> origin, BUPathSet.Immutable<S, L, O, P> paths) {
        return new BUChanges<S, L, O, P>(paths, BUPathSet.Immutable.of());
    }
}

