/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.patching;

import java.util.Map;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.BiMap;
import mb.scopegraph.oopsla20.reference.ScopeGraph;
import mb.scopegraph.patching.IPatchCollection;
import mb.scopegraph.patching.InvalidPatchCompositionException;
import mb.scopegraph.patching.PatchCollection;
import org.metaborg.util.functions.Function2;

public class Patcher<S, L, D> {
    private final IPatchCollection.Immutable<S> sourcePatches;
    private final IPatchCollection.Immutable<S> targetPatches;
    private final IPatchCollection.Immutable<S> datumScopePatches;
    private final IPatchCollection.Immutable<S> datumPatches;
    private final Function2<D, BiMap.Immutable<S>, D> patchDatum;

    private Patcher(IPatchCollection.Immutable<S> sourcePatches, IPatchCollection.Immutable<S> targetPatches, IPatchCollection.Immutable<S> datumScopePatches, IPatchCollection.Immutable<S> datumPatches, Function2<D, BiMap.Immutable<S>, D> patchDatum) {
        this.sourcePatches = sourcePatches;
        this.targetPatches = targetPatches;
        this.datumScopePatches = datumScopePatches;
        this.datumPatches = datumPatches;
        this.patchDatum = patchDatum;
    }

    public <T> IScopeGraph.Immutable<S, L, D> apply(IScopeGraph.Immutable<S, L, D> scopeGraph, EdgeSourcePatchCallback<S, L, D, T> edgeSourceCallback, EdgeTargetPatchCallback<S, L, D, T> edgeTargetCallback, DataPatchCallback<S, L, D> dataPatchCallback) {
        if (this.sourcePatches.isIdentity() && this.targetPatches.isIdentity() && this.datumScopePatches.isIdentity()) {
            for (Map.Entry edges : scopeGraph.getEdges().entrySet()) {
                Object source = edges.getKey().getKey();
                Object label = edges.getKey().getValue();
                T sourceMeta = edgeSourceCallback.sourcePatched(source, source);
                for (Object target : edges.getValue()) {
                    edgeTargetCallback.targetPatched(source, source, label, target, target, sourceMeta);
                }
            }
            if (this.datumPatches.isIdentity()) {
                if (dataPatchCallback != DataPatchCallback.noop()) {
                    scopeGraph.getData().forEach((s, d) -> dataPatchCallback.dataPatched(s, s, d, d));
                }
                return scopeGraph;
            }
            IScopeGraph.Transient<S, L, D> patchedGraph = scopeGraph.melt();
            this.applyDatumPatches(patchedGraph, scopeGraph.getData(), dataPatchCallback);
            return patchedGraph.freeze();
        }
        ScopeGraph.Transient patchedGraph = ScopeGraph.Transient.of();
        for (Map.Entry edges : scopeGraph.getEdges().entrySet()) {
            Object oldSource = edges.getKey().getKey();
            Object newSource = this.sourcePatches.patch(oldSource);
            Object label = edges.getKey().getValue();
            T sourceMeta = edgeSourceCallback.sourcePatched(oldSource, newSource);
            for (Object oldTarget : edges.getValue()) {
                Object newTarget = this.targetPatches.patch(oldTarget);
                patchedGraph.addEdge(newSource, label, newTarget);
                edgeTargetCallback.targetPatched(oldSource, newSource, label, oldTarget, newTarget, sourceMeta);
            }
        }
        this.applyDatumPatches(patchedGraph, scopeGraph.getData(), dataPatchCallback);
        return patchedGraph.freeze();
    }

    private void applyDatumPatches(IScopeGraph.Transient<S, L, D> scopeGraph, Map<S, D> data, DataPatchCallback<S, L, D> dataPatchCallback) {
        for (Map.Entry datumEntry : scopeGraph.getData().entrySet()) {
            Object oldScope = datumEntry.getKey();
            Object oldDatum = datumEntry.getValue();
            Object newScope = this.datumScopePatches.patch(oldScope);
            D newDatum = this.patchDatum.apply(oldDatum, this.datumPatches.patches());
            scopeGraph.setDatum(newScope, newDatum);
            dataPatchCallback.dataPatched(oldScope, newScope, oldDatum, newDatum);
        }
    }

    /* synthetic */ Patcher(IPatchCollection.Immutable immutable, IPatchCollection.Immutable immutable2, IPatchCollection.Immutable immutable3, IPatchCollection.Immutable immutable4, Function2 function2, Patcher patcher) {
        this(immutable, immutable2, immutable3, immutable4, function2);
    }

    public static class Builder<S, L, D> {
        private final IPatchCollection.Transient<S> sourcePatches = PatchCollection.Transient.of();
        private final IPatchCollection.Transient<S> targetPatches = PatchCollection.Transient.of();
        private final IPatchCollection.Transient<S> datumScopePatches = PatchCollection.Transient.of();
        private final IPatchCollection.Transient<S> datumPatches = PatchCollection.Transient.of();
        private Function2<D, BiMap.Immutable<S>, D> patchDatum;

        public Builder<S, L, D> patchSources(IPatchCollection<S> patches) throws InvalidPatchCompositionException {
            this.sourcePatches.putAll(patches);
            return this;
        }

        public Builder<S, L, D> patchEdgeTargets(IPatchCollection<S> patches) throws InvalidPatchCompositionException {
            this.targetPatches.putAll(patches);
            return this;
        }

        public Builder<S, L, D> patchDatumSources(IPatchCollection<S> patches) throws InvalidPatchCompositionException {
            this.datumScopePatches.putAll(patches);
            return this;
        }

        public Builder<S, L, D> patchDatums(IPatchCollection<S> patches, Function2<D, BiMap.Immutable<S>, D> patchDatum) throws InvalidPatchCompositionException {
            if (this.patchDatum != null) {
                throw new InvalidPatchCompositionException("Cannot add multiple patch functions for data.");
            }
            this.datumPatches.putAll(patches);
            this.patchDatum = patchDatum;
            return this;
        }

        public Patcher<S, L, D> build() {
            return new Patcher(this.sourcePatches.freeze(), this.targetPatches.freeze(), this.datumScopePatches.freeze(), this.datumPatches.freeze(), this.patchDatum, null);
        }
    }

    public static interface DataPatchCallback<S, L, D> {
        public static final DataPatchCallback NOOP = new DataPatchCallback(){

            public void dataPatched(Object oldSource, Object newSource, Object oldDatum, Object newDatum) {
            }
        };

        public static <S, L, D> DataPatchCallback<S, L, D> noop() {
            return NOOP;
        }

        public void dataPatched(S var1, S var2, D var3, D var4);
    }

    public static interface EdgeSourcePatchCallback<S, L, D, T> {
        public T sourcePatched(S var1, S var2);
    }

    public static interface EdgeTargetPatchCallback<S, L, D, T> {
        public void targetPatched(S var1, S var2, L var3, S var4, S var5, T var6);
    }
}

