/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.terms.path;

import io.usethesource.capsule.Set;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.scopegraph.oopsla20.terms.path.AStep;
import org.metaborg.util.collection.ConsList;

final class Step<S, L>
extends AStep<S, L>
implements Serializable {
    private final S source;
    private final L label;
    private final S target;
    private int hashCode;
    private volatile transient long lazyInitBitmap;
    private static final long SIZE_LAZY_INIT_BIT = 1L;
    private transient int size;
    private static final long SCOPES_LAZY_INIT_BIT = 2L;
    private transient ConsList<S> scopes;
    private static final long SCOPE_SET_LAZY_INIT_BIT = 4L;
    private transient Set.Immutable<S> scopeSet;
    private static final long LABELS_LAZY_INIT_BIT = 8L;
    private transient ConsList<L> labels;
    private static final long serialVersionUID = 42L;

    private Step(S source, L label, S target) {
        this.source = Objects.requireNonNull(source, "source");
        this.label = Objects.requireNonNull(label, "label");
        this.target = Objects.requireNonNull(target, "target");
    }

    private Step(Step<S, L> original, S source, L label, S target) {
        this.source = source;
        this.label = label;
        this.target = target;
    }

    @Override
    public S getSource() {
        return this.source;
    }

    @Override
    public L getLabel() {
        return this.label;
    }

    @Override
    public S getTarget() {
        return this.target;
    }

    public final Step<S, L> withSource(S value) {
        if (this.source == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "source");
        return new Step<S, L>(this, newValue, this.label, this.target);
    }

    public final Step<S, L> withLabel(L value) {
        if (this.label == value) {
            return this;
        }
        L newValue = Objects.requireNonNull(value, "label");
        return new Step<S, L>(this, this.source, newValue, this.target);
    }

    public final Step<S, L> withTarget(S value) {
        if (this.target == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "target");
        return new Step<S, L>(this, this.source, this.label, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof Step && this.equalTo((Step)another);
    }

    private boolean equalTo(Step<?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.source.equals(another.source) && this.label.equals(another.label) && this.target.equals(another.target);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.source.hashCode();
        h += (h << 5) + this.label.hashCode();
        h += (h << 5) + this.target.hashCode();
        return h;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int size() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            Step step = this;
            synchronized (step) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.size = super.size();
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<S> scopes() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            Step step = this;
            synchronized (step) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.scopes = Objects.requireNonNull(super.scopes(), "scopes");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.scopes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set.Immutable<S> scopeSet() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            Step step = this;
            synchronized (step) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.scopeSet = Objects.requireNonNull(super.scopeSet(), "scopeSet");
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.scopeSet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConsList<L> labels() {
        if ((this.lazyInitBitmap & 8L) == 0L) {
            Step step = this;
            synchronized (step) {
                if ((this.lazyInitBitmap & 8L) == 0L) {
                    this.labels = Objects.requireNonNull(super.labels(), "labels");
                    this.lazyInitBitmap |= 8L;
                }
            }
        }
        return this.labels;
    }

    public static <S, L> Step<S, L> of(S source, L label, S target) {
        return new Step<S, L>(source, label, target);
    }

    public static <S, L> Step<S, L> copyOf(AStep<S, L> instance) {
        if (instance instanceof Step) {
            return (Step)instance;
        }
        return Step.builder().from(instance).build();
    }

    public static <S, L> Builder<S, L> builder() {
        return new Builder();
    }

    /* synthetic */ Step(Step step, Object object, Object object2, Object object3, Step step2) {
        this(step, object, object2, object3);
    }

    public static final class Builder<S, L> {
        private static final long INIT_BIT_SOURCE = 1L;
        private static final long INIT_BIT_LABEL = 2L;
        private static final long INIT_BIT_TARGET = 4L;
        private long initBits = 7L;
        private S source;
        private L label;
        private S target;

        private Builder() {
        }

        public final Builder<S, L> from(AStep<S, L> instance) {
            Objects.requireNonNull(instance, "instance");
            this.source(instance.getSource());
            this.label(instance.getLabel());
            this.target(instance.getTarget());
            return this;
        }

        public final Builder<S, L> source(S source) {
            this.source = Objects.requireNonNull(source, "source");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L> label(L label) {
            this.label = Objects.requireNonNull(label, "label");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder<S, L> target(S target) {
            this.target = Objects.requireNonNull(target, "target");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public Step<S, L> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new Step(null, this.source, this.label, this.target, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("source");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("label");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("target");
            }
            return "Cannot build Step, some of required attributes are not set " + attributes;
        }
    }
}

