/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.terms.path;

import com.google.common.collect.Iterators;
import com.google.common.math.IntMath;
import io.usethesource.capsule.Set;
import java.util.Iterator;
import javax.annotation.Nullable;
import mb.scopegraph.oopsla20.path.IScopePath;
import mb.scopegraph.oopsla20.path.IStep;
import org.immutables.serial.Serial;
import org.immutables.value.Value;
import org.metaborg.util.collection.ConsList;

@Value.Immutable
@Serial.Version(value=42L)
abstract class AComposedScopePath<S, L>
implements IScopePath<S, L> {
    AComposedScopePath() {
    }

    @Value.Parameter
    public abstract IScopePath<S, L> getLeft();

    @Value.Parameter
    public abstract IScopePath<S, L> getRight();

    @Nullable
    @Value.Check
    public AComposedScopePath<S, L> check() {
        if (!this.getLeft().getTarget().equals(this.getRight().getSource())) {
            return null;
        }
        if (this.scopeSet().size() < this.size()) {
            return null;
        }
        return this;
    }

    @Override
    @Value.Lazy
    public S getSource() {
        return this.getLeft().getSource();
    }

    @Override
    @Value.Lazy
    public S getTarget() {
        return this.getRight().getTarget();
    }

    @Override
    @Value.Lazy
    public int size() {
        return this.getLeft().size() + this.getRight().size();
    }

    @Override
    @Value.Lazy
    public ConsList<S> scopes() {
        return this.getLeft().scopes().append(this.getRight().scopes().tail());
    }

    @Override
    @Value.Lazy
    public Set.Immutable<S> scopeSet() {
        return this.getLeft().scopeSet().__insertAll(this.getRight().scopeSet());
    }

    @Override
    @Value.Lazy
    public ConsList<L> labels() {
        return this.getLeft().labels().append(this.getRight().labels());
    }

    @Override
    public Iterator<IStep<S, L>> iterator() {
        return Iterators.concat(this.getLeft().iterator(), this.getRight().iterator());
    }

    public int hashCode() {
        return this.getLeft().hashCode() + IntMath.pow((int)31, (int)this.getLeft().size()) * this.getRight().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof IScopePath)) {
            return false;
        }
        IScopePath other = (IScopePath)obj;
        if (!this.getSource().equals(other.getSource())) {
            return false;
        }
        if (!this.getTarget().equals(other.getTarget())) {
            return false;
        }
        return Iterators.elementsEqual(this.iterator(), other.iterator());
    }

    @Override
    public String toString(boolean includeSource, boolean includeTarget) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getLeft().toString(includeSource, true));
        sb.append(" ");
        sb.append(this.getRight().toString(false, includeTarget));
        return sb.toString();
    }

    public String toString() {
        return this.toString(true, true);
    }
}

