/*
 * Decompiled with CFR 0.152.
 */
package mb.scopegraph.oopsla20.diff;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Collections;

public abstract class BiMultimap<K, V> {
    public abstract Collection<V> getValues(K var1);

    public abstract Collection<K> getKeys(V var1);

    public abstract boolean containsValue(V var1);

    public static class Immutable<K, V>
    extends BiMultimap<K, V> {
        private ImmutableMultimap<K, V> fwd;
        private ImmutableMultimap<V, K> bwd;

        private Immutable(ImmutableMultimap<K, V> fwd, ImmutableMultimap<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        @Override
        public Collection<V> getValues(K key) {
            return this.fwd.get(key);
        }

        @Override
        public Collection<K> getKeys(V value) {
            return this.bwd.get(value);
        }

        @Override
        public boolean containsValue(V value) {
            return this.bwd.containsKey(value);
        }

        public Transient<K, V> melt() {
            return new Transient((Multimap)ArrayListMultimap.create(this.fwd), (Multimap)ArrayListMultimap.create(this.bwd));
        }

        public static <K, V> Immutable<K, V> of() {
            return new Immutable<K, V>(ImmutableMultimap.of(), ImmutableMultimap.of());
        }
    }

    public static class Transient<K, V>
    extends BiMultimap<K, V> {
        private Multimap<K, V> fwd;
        private Multimap<V, K> bwd;

        private Transient(Multimap<K, V> fwd, Multimap<V, K> bwd) {
            this.fwd = fwd;
            this.bwd = bwd;
        }

        public void put(K key, V value) {
            this.fwd.put(key, value);
            this.bwd.put(value, key);
        }

        @Override
        public Collection<V> getValues(K key) {
            return this.fwd.get(key);
        }

        @Override
        public Collection<K> getKeys(V value) {
            return this.bwd.get(value);
        }

        protected Collection<K> removeKeys(V value) {
            this.fwd.values().removeAll(Collections.singleton(value));
            return this.bwd.removeAll(value);
        }

        public Collection<V> removeValues(K key) {
            this.bwd.values().removeAll(Collections.singleton(key));
            return this.fwd.removeAll(key);
        }

        @Override
        public boolean containsValue(V value) {
            return this.bwd.containsKey(value);
        }

        public Immutable<K, V> freeze() {
            return new Immutable(ImmutableMultimap.copyOf(this.fwd), ImmutableMultimap.copyOf(this.bwd));
        }

        public static <K, V> Transient<K, V> of() {
            return new Transient<K, V>(ArrayListMultimap.create(), ArrayListMultimap.create());
        }
    }
}

