/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.walk;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mb.resource.hierarchical.HierarchicalResource;
import mb.resource.hierarchical.walk.ResourceWalker;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AllResourceWalker
implements ResourceWalker {
    private final List<ResourceWalker> walkers;

    public AllResourceWalker(ArrayList<ResourceWalker> walkers) {
        this.walkers = walkers;
    }

    public AllResourceWalker(ResourceWalker ... walkers) {
        this.walkers = Arrays.asList(walkers);
    }

    @Override
    public boolean traverse(HierarchicalResource directory, HierarchicalResource rootDirectory) throws IOException {
        for (ResourceWalker walker : this.walkers) {
            if (walker.traverse(directory, rootDirectory)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllResourceWalker other = (AllResourceWalker)obj;
        return this.walkers.equals(other.walkers);
    }

    public int hashCode() {
        return Objects.hash(this.walkers);
    }

    public String toString() {
        return "all(" + this.walkers + ")";
    }
}

