/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical.match.path.string;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import mb.resource.hierarchical.match.path.string.PathStringMatcher;
import org.checkerframework.checker.nullness.qual.Nullable;

public class AllPathStringMatcher
implements PathStringMatcher {
    private final List<PathStringMatcher> matchers;

    public AllPathStringMatcher(ArrayList<PathStringMatcher> matchers) {
        this.matchers = matchers;
    }

    public AllPathStringMatcher(PathStringMatcher ... matchers) {
        this.matchers = Arrays.asList(matchers);
    }

    @Override
    public boolean matches(String pathString) {
        for (PathStringMatcher matcher : this.matchers) {
            if (matcher.matches(pathString)) continue;
            return false;
        }
        return true;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        AllPathStringMatcher other = (AllPathStringMatcher)obj;
        return this.matchers.equals(other.matchers);
    }

    public int hashCode() {
        return Objects.hash(this.matchers);
    }

    public String toString() {
        return "AllPathStringMatcher(" + this.matchers.toString() + ")";
    }
}

