/*
 * Decompiled with CFR 0.152.
 */
package mb.resource.hierarchical;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import mb.resource.hierarchical.FilenameExtensionUtil;
import mb.resource.hierarchical.ResourcePath;
import mb.resource.util.SeparatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ResourcePathDefaults<SELF extends ResourcePathDefaults<SELF>>
implements ResourcePath {
    protected abstract SELF self();

    public abstract SELF appendSegments(Iterable<String> var1);

    public SELF appendSegments(Collection<String> segments) {
        return (SELF)this.appendSegments((Iterable)segments);
    }

    public SELF appendSegments(List<String> segments) {
        return (SELF)this.appendSegments((Collection)segments);
    }

    public SELF appendSegments(String ... segments) {
        return (SELF)this.appendSegments((List)Arrays.asList(segments));
    }

    public SELF appendAsRelativePath(String path) {
        if (SeparatorUtil.startsWithSeparator(path)) {
            return (SELF)this.appendRelativePath(path.substring(1));
        }
        return (SELF)this.appendRelativePath(path);
    }

    public abstract SELF appendRelativePath(String var1);

    public SELF appendString(String other) {
        return (SELF)this.appendAsRelativePath(other);
    }

    public abstract SELF appendRelativePath(ResourcePath var1);

    public SELF appendOrReplaceWithPath(ResourcePath other) {
        if (other.isAbsolute()) {
            ResourcePathDefaults otherSelf = (ResourcePathDefaults)other;
            return (SELF)otherSelf;
        }
        return (SELF)this.appendRelativePath(other);
    }

    public abstract SELF replaceLeaf(String var1);

    public SELF appendToLeaf(String segment) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(leaf + segment);
    }

    public SELF applyToLeaf(Function<String, String> func) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(func.apply(leaf));
    }

    public SELF replaceLeafExtension(String extension) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.replaceExtension(leaf, extension));
    }

    public SELF ensureLeafExtension(String extension) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.ensureExtension(leaf, extension));
    }

    public SELF removeLeafExtension() {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.removeExtension(leaf));
    }

    public SELF appendToLeafExtension(String extension) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.appendExtension(leaf, extension));
    }

    public SELF applyToLeafExtension(Function<String, String> func) {
        @Nullable String leaf = this.getLeaf();
        if (leaf == null) {
            return this.self();
        }
        return (SELF)this.replaceLeaf(FilenameExtensionUtil.applyToExtension(leaf, func));
    }

    @Override
    public int compareTo(ResourcePath o) {
        return this.asResourceKeyString().compareTo(o.asResourceKeyString());
    }

    @Override
    public abstract boolean equals(@Nullable Object var1);

    @Override
    public abstract int hashCode();

    @Override
    public abstract String toString();
}

