/*
 * Decompiled with CFR 0.152.
 */
package mb.pie.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.function.Consumer;
import mb.pie.api.ExecContext;
import mb.pie.api.STask;
import mb.pie.api.Supplier;
import mb.pie.api.stamp.OutputStamper;
import mb.pie.api.stamp.output.OutputStampers;
import org.checkerframework.checker.nullness.qual.Nullable;

public class SupplierWithOrigins<T extends Serializable>
implements Supplier<T> {
    private final Supplier<T> supplier;
    private final ArrayList<Supplier<?>> origins;

    public SupplierWithOrigins(Supplier<T> supplier, ArrayList<Supplier<?>> origins) {
        this.supplier = supplier;
        this.origins = origins;
    }

    public SupplierWithOrigins(Supplier<T> supplier, Collection<? extends Supplier<?>> origins) {
        this.supplier = supplier;
        this.origins = new ArrayList(origins);
    }

    public SupplierWithOrigins(Supplier<T> supplier, Iterable<? extends Supplier<?>> origins) {
        this.supplier = supplier;
        this.origins = new ArrayList();
        for (Supplier<?> origin : origins) {
            this.origins.add(origin);
        }
    }

    public SupplierWithOrigins(Supplier<T> supplier, Supplier<?> ... origins) {
        this.supplier = supplier;
        this.origins = new ArrayList();
        Collections.addAll(this.origins, origins);
    }

    @Override
    public T get(ExecContext context) {
        this.origins.forEach((Consumer<Supplier<?>>)((Consumer<Supplier>)origin -> {
            if (origin instanceof STask) {
                context.require((STask)origin, (OutputStamper)OutputStampers.inconsequential());
            } else {
                context.require(origin);
            }
        }));
        return context.require(this.supplier);
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SupplierWithOrigins that = (SupplierWithOrigins)o;
        if (!this.supplier.equals(that.supplier)) {
            return false;
        }
        return this.origins.equals(that.origins);
    }

    public int hashCode() {
        int result = this.supplier.hashCode();
        result = 31 * result + this.origins.hashCode();
        return result;
    }

    public String toString() {
        return "SupplierWithOrigin{supplier=" + this.supplier + ", origins=" + this.origins + '}';
    }
}

