/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.nameresolution.tracing;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.Set;
import mb.p_raffrayi.IRecordedQuery;
import mb.p_raffrayi.nameresolution.tracing.AExtQuerySet;

public final class ExtQuerySet<S, L, D>
extends AExtQuerySet<S, L, D>
implements Serializable {
    private final ImmutableSet<IRecordedQuery<S, L, D>> transitiveQueries;
    private final ImmutableSet<IRecordedQuery<S, L, D>> predicateQueries;
    private int hashCode;
    private static final long serialVersionUID = 42L;

    private ExtQuerySet(Iterable<? extends IRecordedQuery<S, L, D>> transitiveQueries, Iterable<? extends IRecordedQuery<S, L, D>> predicateQueries) {
        this.transitiveQueries = ImmutableSet.copyOf(transitiveQueries);
        this.predicateQueries = ImmutableSet.copyOf(predicateQueries);
    }

    private ExtQuerySet(ExtQuerySet<S, L, D> original, ImmutableSet<IRecordedQuery<S, L, D>> transitiveQueries, ImmutableSet<IRecordedQuery<S, L, D>> predicateQueries) {
        this.transitiveQueries = transitiveQueries;
        this.predicateQueries = predicateQueries;
    }

    @Override
    public ImmutableSet<IRecordedQuery<S, L, D>> transitiveQueries() {
        return this.transitiveQueries;
    }

    @Override
    public ImmutableSet<IRecordedQuery<S, L, D>> predicateQueries() {
        return this.predicateQueries;
    }

    @SafeVarargs
    public final ExtQuerySet<S, L, D> withTransitiveQueries(IRecordedQuery<S, L, D> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtQuerySet<S, L, D>(this, newValue, this.predicateQueries);
    }

    public final ExtQuerySet<S, L, D> withTransitiveQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
        if (this.transitiveQueries == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtQuerySet<S, L, D>(this, newValue, this.predicateQueries);
    }

    @SafeVarargs
    public final ExtQuerySet<S, L, D> withPredicateQueries(IRecordedQuery<S, L, D> ... elements) {
        ImmutableSet newValue = ImmutableSet.copyOf((Object[])elements);
        return new ExtQuerySet<S, L, D>(this, this.transitiveQueries, newValue);
    }

    public final ExtQuerySet<S, L, D> withPredicateQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
        if (this.predicateQueries == elements) {
            return this;
        }
        ImmutableSet newValue = ImmutableSet.copyOf(elements);
        return new ExtQuerySet<S, L, D>(this, this.transitiveQueries, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ExtQuerySet && this.equalTo((ExtQuerySet)another);
    }

    private boolean equalTo(ExtQuerySet<?, ?, ?> another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.transitiveQueries.equals(another.transitiveQueries) && this.predicateQueries.equals(another.predicateQueries);
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.transitiveQueries.hashCode();
        h += (h << 5) + this.predicateQueries.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ExtQuerySet").omitNullValues().add("transitiveQueries", this.transitiveQueries).add("predicateQueries", this.predicateQueries).toString();
    }

    public static <S, L, D> ExtQuerySet<S, L, D> of(Set<IRecordedQuery<S, L, D>> transitiveQueries, Set<IRecordedQuery<S, L, D>> predicateQueries) {
        return ExtQuerySet.of(transitiveQueries, predicateQueries);
    }

    public static <S, L, D> ExtQuerySet<S, L, D> of(Iterable<? extends IRecordedQuery<S, L, D>> transitiveQueries, Iterable<? extends IRecordedQuery<S, L, D>> predicateQueries) {
        return new ExtQuerySet<S, L, D>(transitiveQueries, predicateQueries);
    }

    public static <S, L, D> ExtQuerySet<S, L, D> copyOf(AExtQuerySet<S, L, D> instance) {
        if (instance instanceof ExtQuerySet) {
            return (ExtQuerySet)instance;
        }
        return ExtQuerySet.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ ExtQuerySet(ExtQuerySet extQuerySet, ImmutableSet immutableSet, ImmutableSet immutableSet2, ExtQuerySet extQuerySet2) {
        this(extQuerySet, immutableSet, immutableSet2);
    }

    public static final class Builder<S, L, D> {
        private ImmutableSet.Builder<IRecordedQuery<S, L, D>> transitiveQueries = ImmutableSet.builder();
        private ImmutableSet.Builder<IRecordedQuery<S, L, D>> predicateQueries = ImmutableSet.builder();

        private Builder() {
        }

        public final Builder<S, L, D> from(AExtQuerySet<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllTransitiveQueries(instance.transitiveQueries());
            this.addAllPredicateQueries(instance.predicateQueries());
            return this;
        }

        public final Builder<S, L, D> addTransitiveQueries(IRecordedQuery<S, L, D> element) {
            this.transitiveQueries.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addTransitiveQueries(IRecordedQuery<S, L, D> ... elements) {
            this.transitiveQueries.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> transitiveQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.transitiveQueries = ImmutableSet.builder();
            return this.addAllTransitiveQueries(elements);
        }

        public final Builder<S, L, D> addAllTransitiveQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.transitiveQueries.addAll(elements);
            return this;
        }

        public final Builder<S, L, D> addPredicateQueries(IRecordedQuery<S, L, D> element) {
            this.predicateQueries.add(element);
            return this;
        }

        @SafeVarargs
        public final Builder<S, L, D> addPredicateQueries(IRecordedQuery<S, L, D> ... elements) {
            this.predicateQueries.add((Object[])elements);
            return this;
        }

        public final Builder<S, L, D> predicateQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.predicateQueries = ImmutableSet.builder();
            return this.addAllPredicateQueries(elements);
        }

        public final Builder<S, L, D> addAllPredicateQueries(Iterable<? extends IRecordedQuery<S, L, D>> elements) {
            this.predicateQueries.addAll(elements);
            return this;
        }

        public ExtQuerySet<S, L, D> build() {
            return new ExtQuerySet(null, this.transitiveQueries.build(), this.predicateQueries.build(), null);
        }
    }
}

