/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.tokens;

import com.google.common.base.MoreObjects;
import java.util.ArrayList;
import java.util.Objects;
import mb.p_raffrayi.actors.IActorRef;
import mb.p_raffrayi.impl.IUnit;
import mb.p_raffrayi.impl.tokens.ACloseScope;

public final class CloseScope<S, L, D>
extends ACloseScope<S, L, D> {
    private final IActorRef<? extends IUnit<S, L, D, ?>> origin;
    private final S scope;
    private final transient int hashCode;

    private CloseScope(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        this.origin = Objects.requireNonNull(origin, "origin");
        this.scope = Objects.requireNonNull(scope, "scope");
        this.hashCode = this.computeHashCode();
    }

    private CloseScope(CloseScope<S, L, D> original, IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        this.origin = origin;
        this.scope = scope;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public IActorRef<? extends IUnit<S, L, D, ?>> origin() {
        return this.origin;
    }

    @Override
    public S scope() {
        return this.scope;
    }

    public final CloseScope<S, L, D> withOrigin(IActorRef<? extends IUnit<S, L, D, ?>> value) {
        if (this.origin == value) {
            return this;
        }
        IActorRef<? extends IUnit<S, L, D, ?>> newValue = Objects.requireNonNull(value, "origin");
        return new CloseScope<S, L, D>(this, newValue, this.scope);
    }

    public final CloseScope<S, L, D> withScope(S value) {
        if (this.scope == value) {
            return this;
        }
        S newValue = Objects.requireNonNull(value, "scope");
        return new CloseScope<S, L, D>(this, this.origin, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CloseScope && this.equalTo((CloseScope)another);
    }

    private boolean equalTo(CloseScope<?, ?, ?> another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.origin.equals(another.origin) && this.scope.equals(another.scope);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.origin.hashCode();
        h += (h << 5) + this.scope.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CloseScope").omitNullValues().add("origin", this.origin).add("scope", this.scope).toString();
    }

    public static <S, L, D> CloseScope<S, L, D> of(IActorRef<? extends IUnit<S, L, D, ?>> origin, S scope) {
        return new CloseScope<S, L, D>(origin, scope);
    }

    public static <S, L, D> CloseScope<S, L, D> copyOf(ACloseScope<S, L, D> instance) {
        if (instance instanceof CloseScope) {
            return (CloseScope)instance;
        }
        return CloseScope.builder().from(instance).build();
    }

    public static <S, L, D> Builder<S, L, D> builder() {
        return new Builder();
    }

    /* synthetic */ CloseScope(CloseScope closeScope, IActorRef iActorRef, Object object, CloseScope closeScope2) {
        this(closeScope, iActorRef, object);
    }

    public static final class Builder<S, L, D> {
        private static final long INIT_BIT_ORIGIN = 1L;
        private static final long INIT_BIT_SCOPE = 2L;
        private long initBits = 3L;
        private IActorRef<? extends IUnit<S, L, D, ?>> origin;
        private S scope;

        private Builder() {
        }

        public final Builder<S, L, D> from(ACloseScope<S, L, D> instance) {
            Objects.requireNonNull(instance, "instance");
            this.origin(instance.origin());
            this.scope(instance.scope());
            return this;
        }

        public final Builder<S, L, D> origin(IActorRef<? extends IUnit<S, L, D, ?>> origin) {
            this.origin = Objects.requireNonNull(origin, "origin");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder<S, L, D> scope(S scope) {
            this.scope = Objects.requireNonNull(scope, "scope");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public CloseScope<S, L, D> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new CloseScope(null, this.origin, this.scope, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("origin");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("scope");
            }
            return "Cannot build CloseScope, some of required attributes are not set " + attributes;
        }
    }
}

