/*
 * Decompiled with CFR 0.152.
 */
package mb.p_raffrayi.impl.diagnostics;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import mb.p_raffrayi.impl.diff.IDifferOps;
import mb.scopegraph.oopsla20.IScopeGraph;
import mb.scopegraph.oopsla20.diff.BiMap;
import org.metaborg.util.collection.HashSetMultiTable;
import org.metaborg.util.collection.MultiTable;
import org.metaborg.util.functions.Action4;

public class AmbigousEdgeMatch<S, L, D> {
    private final IScopeGraph.Immutable<S, L, D> scopeGraph;
    private final Collection<S> rootScopes;
    private final IDifferOps<S, L, D> differOps;

    public AmbigousEdgeMatch(IScopeGraph.Immutable<S, L, D> scopeGraph, Collection<S> rootScopes, IDifferOps<S, L, D> differOps) {
        this.scopeGraph = scopeGraph;
        this.rootScopes = rootScopes;
        this.differOps = differOps;
    }

    public Report<S, L, D> analyze() {
        MultiTable ambiguousMatches = HashSetMultiTable.create();
        for (S root : this.rootScopes) {
            this.analyzeScope(BiMap.Immutable.of(), root, (src, lbl, tgt1, tgt2) -> {
                Object d1 = this.scopeGraph.getData(tgt1).filter(d -> !this.differOps.embed(tgt1).equals(d)).orElse(null);
                Object d2 = this.scopeGraph.getData(tgt2).filter(d -> !this.differOps.embed(tgt2).equals(d)).orElse(null);
                ambiguousMatches.put(src, lbl, new Match<Object, Object>(tgt1, d1, tgt2, d2));
            });
        }
        return new Report(ambiguousMatches);
    }

    private void analyzeScope(BiMap.Immutable<S> matches, S scope, Action4<S, L, S, S> onAmbiguousEdge) {
        if (matches.containsKey(scope)) {
            return;
        }
        BiMap.Immutable<S> newMatches = this.matchScopes(matches, scope, scope).orElseThrow(() -> new IllegalStateException("BUG: appears scope cannot be matched to itself."));
        for (Object label : this.scopeGraph.getLabels()) {
            this.analyzeEdge(newMatches, scope, label, onAmbiguousEdge);
        }
        this.scopeGraph.getData(scope).ifPresent(d -> {
            for (S innerScope : this.differOps.getScopes(d)) {
                this.analyzeScope(matches.put(scope, scope), innerScope, onAmbiguousEdge);
            }
        });
    }

    private void analyzeEdge(BiMap.Immutable<S> matches, S scope, L label, Action4<S, L, S, S> onAmbiguousEdge) {
        ArrayList targets = Lists.newArrayList(this.scopeGraph.getEdges(scope, label));
        while (!targets.isEmpty()) {
            Object target = targets.remove(0);
            for (Object other : targets) {
                this.matchScopes(matches, target, other).ifPresent(__ -> onAmbiguousEdge.apply(scope, label, target, other));
            }
            this.analyzeScope(matches, target, onAmbiguousEdge);
        }
    }

    private Optional<BiMap.Immutable<S>> matchScopes(BiMap.Immutable<S> matches, S scope1, S scope2) {
        if (matches.containsEntry(scope1, scope2)) {
            return Optional.of(matches);
        }
        if (!matches.canPut(scope1, scope2)) {
            return Optional.empty();
        }
        if (!this.differOps.isMatchAllowed(scope1, scope2)) {
            return Optional.empty();
        }
        if (!this.differOps.ownScope(scope1)) {
            return scope1.equals(scope2) ? Optional.of(matches.put(scope1, scope2)) : Optional.empty();
        }
        Optional d1 = this.scopeGraph.getData(scope1);
        Optional d2 = this.scopeGraph.getData(scope2);
        if (d1.isPresent() && d2.isPresent()) {
            return this.canMatchData(matches.put(scope1, scope2), d1.get(), d2.get());
        }
        if (!d1.isPresent() && !d2.isPresent()) {
            return Optional.of(matches.put(scope1, scope2));
        }
        return Optional.empty();
    }

    private Optional<BiMap.Immutable<S>> canMatchData(BiMap.Immutable<S> matches, D d1, D d2) {
        return this.differOps.matchDatums(d1, d2).flatMap(newMatches -> {
            BiMap.Immutable allMatches = matches;
            for (Map.Entry match : newMatches.entrySet()) {
                if (!allMatches.canPut(match.getKey(), match.getValue())) {
                    return Optional.empty();
                }
                Optional transMatches = this.matchScopes(allMatches, match.getKey(), match.getValue());
                if (!transMatches.isPresent()) {
                    return Optional.empty();
                }
                allMatches = transMatches.get();
            }
            return Optional.of(allMatches);
        });
    }

    public static class Match<S, D> {
        private final S scope1;
        private final S scope2;
        @Nullable
        private final D datum1;
        @Nullable
        private final D datum2;

        public Match(S scope1, D datum1, S scope2, D datum2) {
            this.scope1 = scope1;
            this.datum1 = datum1;
            this.scope2 = scope2;
            this.datum2 = datum2;
        }

        public S getScope1() {
            return this.scope1;
        }

        public S getScope2() {
            return this.scope2;
        }

        public Optional<D> getDatum1() {
            return Optional.ofNullable(this.datum1);
        }

        public Optional<D> getDatum2() {
            return Optional.ofNullable(this.datum2);
        }

        public String toString() {
            return this.scope1 + (this.datum1 != null ? " : " + this.datum1 : "") + " ~ " + this.scope2 + (this.datum2 != null ? " : " + this.datum2 : "");
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Match other = (Match)obj;
            return Objects.equals(this.scope1, other.scope1) && Objects.equals(this.datum1, other.datum1) && Objects.equals(this.scope2, other.scope2) && Objects.equals(this.datum2, other.datum2);
        }

        public int hashCode() {
            return Objects.hash(this.scope1, this.datum1, this.scope2, this.datum2);
        }
    }

    public static class Report<S, L, D> {
        private MultiTable<S, L, Match<S, D>> ambiguousMatches;

        public Report(MultiTable<S, L, Match<S, D>> ambiguousMatches) {
            this.ambiguousMatches = ambiguousMatches;
        }

        public Set<S> scopes() {
            return this.ambiguousMatches.rowKeySet();
        }

        public Set<L> labels(S scope) {
            return this.ambiguousMatches.row(scope).keySet();
        }

        public Collection<Match<S, D>> matches(S scope, L label) {
            return this.ambiguousMatches.get(scope, label);
        }

        public int size() {
            return this.ambiguousMatches.cellSet().size();
        }

        public boolean isEmpty() {
            return this.ambiguousMatches.cellSet().isEmpty();
        }

        public boolean contains(S source, L label, Match<S, D> match) {
            return this.ambiguousMatches.get(source, label).contains(match);
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("Report {\n");
            for (S scope : this.ambiguousMatches.rowKeySet()) {
                sb.append("  ");
                sb.append(scope);
                sb.append(" {\n");
                for (Map.Entry<L, Collection<Match<S, D>>> entry : this.ambiguousMatches.row(scope).entrySet()) {
                    sb.append("    ");
                    sb.append(entry.getKey());
                    sb.append(" : \n");
                    for (Match<S, D> match : entry.getValue()) {
                        sb.append("    - ");
                        sb.append(match);
                        sb.append("\n");
                    }
                }
                sb.append("  }\n");
            }
            sb.append("}\n");
            return sb.toString();
        }
    }
}

