/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util.graph.graphimpl;

import com.google.common.collect.Maps;
import io.usethesource.capsule.Map;
import io.usethesource.capsule.Set;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import mb.nabl2.util.graph.alg.misc.memory.EmptyMemory;
import mb.nabl2.util.graph.alg.misc.memory.IMemoryView;
import mb.nabl2.util.graph.alg.misc.memory.MapBackedMemoryView;
import mb.nabl2.util.graph.igraph.IBiDirectionalGraphDataSource;
import mb.nabl2.util.graph.igraph.IGraphObserver;
import org.metaborg.util.collection.CapsuleUtil;

public class LazySubGraph<V>
implements IBiDirectionalGraphDataSource<V> {
    private final IBiDirectionalGraphDataSource<V> graph;
    private final Set.Immutable<V> nodesInSubGraph;
    private final Map<V, IMemoryView<V>> targetNodes;
    private final Map<V, IMemoryView<V>> sourceNodes;

    public LazySubGraph(IBiDirectionalGraphDataSource<V> graph, Iterable<V> nodesInSubGraph) {
        this.graph = graph;
        this.nodesInSubGraph = CapsuleUtil.toSet(nodesInSubGraph);
        this.targetNodes = Maps.newHashMap();
        this.sourceNodes = Maps.newHashMap();
    }

    @Override
    public void attachObserver(IGraphObserver<V> observer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void attachAsFirstObserver(IGraphObserver<V> observer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void detachObserver(IGraphObserver<V> observer) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<V> getAllNodes() {
        return this.nodesInSubGraph;
    }

    @Override
    public IMemoryView<V> getTargetNodes(V source) {
        if (!this.nodesInSubGraph.contains(source)) {
            return EmptyMemory.instance();
        }
        return this.targetNodes.computeIfAbsent((IMemoryView)source, (Function<IMemoryView, IMemoryView<IMemoryView>>)((Function<Object, IMemoryView>)src -> {
            Map.Transient targetNodes = this.graph.getTargetNodes(src).asMap().asTransient();
            CapsuleUtil.filter(targetNodes, node -> this.nodesInSubGraph.contains(node));
            return new MapBackedMemoryView(targetNodes.freeze());
        }));
    }

    @Override
    public IMemoryView<V> getSourceNodes(V target) {
        if (!this.nodesInSubGraph.contains(target)) {
            return EmptyMemory.instance();
        }
        return this.sourceNodes.computeIfAbsent((IMemoryView)target, (Function<IMemoryView, IMemoryView<IMemoryView>>)((Function<Object, IMemoryView>)tgt -> {
            Map.Transient sourceNodes = this.graph.getSourceNodes(tgt).asMap().asTransient();
            CapsuleUtil.filter(sourceNodes, node -> this.nodesInSubGraph.contains(node));
            return new MapBackedMemoryView(sourceNodes.freeze());
        }));
    }
}

