/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import io.usethesource.capsule.Set;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import mb.nabl2.util.collections.IndexedDeque;
import org.metaborg.util.functions.Function1;
import org.metaborg.util.functions.Predicate1;

public class TopoSorter {
    private TopoSorter() {
    }

    public static <E> TopoSortedComponents<E> toposort(Iterable<? extends E> nodes, Function1<E, Iterable<? extends E>> nextNodes, boolean implicitAdd) {
        ImmutableSet nodeSet = ImmutableSet.copyOf(nodes);
        ImmutableList.Builder components = ImmutableList.builder();
        AtomicInteger index = new AtomicInteger(0);
        IndexedDeque<Node<E>> stack = new IndexedDeque<Node<E>>();
        HashMap visited = Maps.newHashMap();
        Predicate1<Object> include = arg_0 -> TopoSorter.lambda$0(implicitAdd, (Set)nodeSet, arg_0);
        for (Object current : nodeSet) {
            if (visited.containsKey(current)) continue;
            TopoSorter.strongconnect(current, index, stack, visited, components, nextNodes, include);
        }
        return new TopoSortedComponents((List)components.build().reverse());
    }

    private static <E> Node<E> strongconnect(E current, AtomicInteger index, Deque<Node<E>> stack, Map<E, Node<E>> visited, ImmutableList.Builder<Set.Immutable<E>> components, Function1<E, Iterable<? extends E>> nextNodes, Predicate1<E> include) {
        Node<E> v = new Node<E>(current, index.getAndIncrement());
        visited.put(current, v);
        stack.push(v);
        for (E next : nextNodes.apply(current)) {
            if (!include.test(next)) continue;
            Node<Object> w = visited.get(next);
            if (w == null) {
                w = TopoSorter.strongconnect(next, index, stack, visited, components, nextNodes, include);
                v.update(w.lowlink());
                continue;
            }
            if (!stack.contains(w)) continue;
            v.update(w.index());
        }
        if (v.isRoot()) {
            Node<E> w;
            Set.Transient component = Set.Transient.of();
            do {
                w = stack.pop();
                component.__insert(w.elem());
            } while (!w.elem().equals(v.elem()));
            components.add((Object)component.freeze());
        }
        return v;
    }

    private static /* synthetic */ boolean lambda$0(boolean bl, Set set, Object n) {
        return bl || set.contains(n);
    }

    private static class Node<E> {
        private final E elem;
        private final int index;
        private int lowlink;

        public Node(E elem, int index) {
            this.elem = elem;
            this.index = index;
            this.lowlink = index;
        }

        public E elem() {
            return this.elem;
        }

        public int index() {
            return this.index;
        }

        public int lowlink() {
            return this.lowlink;
        }

        public int update(int lowlink) {
            this.lowlink = Math.min(this.lowlink, lowlink);
            return this.lowlink;
        }

        public boolean isRoot() {
            return this.lowlink == this.index;
        }

        public String toString() {
            return String.valueOf(this.elem.toString()) + "(" + this.index + ", " + this.lowlink + ")";
        }
    }

    public static class TopoSortedComponents<E>
    implements Iterable<Set.Immutable<E>> {
        private final ImmutableList<Set.Immutable<E>> components;
        private final Map<E, Set.Immutable<E>> index;

        private TopoSortedComponents(List<Set.Immutable<E>> components) {
            this(ImmutableList.copyOf(components), TopoSortedComponents.index(components));
        }

        private static <E> Map<E, Set.Immutable<E>> index(List<Set.Immutable<E>> components) {
            ImmutableMap.Builder index = ImmutableMap.builder();
            for (Set.Immutable<E> component : components) {
                for (Object elem : component) {
                    index.put(elem, component);
                }
            }
            return index.build();
        }

        private TopoSortedComponents(ImmutableList<Set.Immutable<E>> components, Map<E, Set.Immutable<E>> index) {
            this.components = components;
            this.index = index;
        }

        public Set<E> nodes() {
            return this.index.keySet();
        }

        @Override
        public Iterator<Set.Immutable<E>> iterator() {
            return this.components.iterator();
        }

        public ImmutableList<Set.Immutable<E>> components() {
            return this.components;
        }

        public Set.Immutable<E> component(E elem) {
            return this.index.get(elem);
        }

        public TopoSortedComponents<E> reverse() {
            return new TopoSortedComponents<E>(this.components.reverse(), this.index);
        }
    }
}

