/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.terms.build;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Objects;
import mb.nabl2.terms.IAttachments;
import mb.nabl2.terms.IStringTerm;
import mb.nabl2.terms.ITerm;
import mb.nabl2.terms.build.AStringTerm;
import mb.nabl2.terms.build.AbstractTerm;

final class StringTerm
extends AStringTerm
implements Serializable {
    private final IAttachments attachments;
    private final String value;
    private static final long serialVersionUID = 42L;

    private StringTerm(String value) {
        this.value = Objects.requireNonNull(value, "value");
        this.attachments = Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private StringTerm(Builder builder) {
        this.value = builder.value;
        this.attachments = builder.attachments != null ? builder.attachments : Objects.requireNonNull(super.getAttachments(), "attachments");
    }

    private StringTerm(IAttachments attachments, String value) {
        this.attachments = attachments;
        this.value = value;
    }

    @Override
    public IAttachments getAttachments() {
        return this.attachments;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public final StringTerm withAttachments(IAttachments value) {
        if (this.attachments == value) {
            return this;
        }
        IAttachments newValue = Objects.requireNonNull(value, "attachments");
        return new StringTerm(newValue, this.value);
    }

    public final StringTerm withValue(String value) {
        String newValue = Objects.requireNonNull(value, "value");
        if (this.value.equals(newValue)) {
            return this;
        }
        return new StringTerm(this.attachments, newValue);
    }

    public static StringTerm of(String value) {
        return new StringTerm(value);
    }

    public static StringTerm copyOf(AStringTerm instance) {
        if (instance instanceof StringTerm) {
            return (StringTerm)instance;
        }
        return StringTerm.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    /* synthetic */ StringTerm(Builder builder, StringTerm stringTerm) {
        this(builder);
    }

    public static final class Builder {
        private static final long INIT_BIT_VALUE = 1L;
        private long initBits = 1L;
        private IAttachments attachments;
        private String value;

        private Builder() {
        }

        public final Builder from(ITerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AStringTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AbstractTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(IStringTerm instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ITerm instance;
            long bits = 0L;
            if (object instanceof ITerm) {
                instance = (ITerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(instance.getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof AStringTerm) {
                instance = (AStringTerm)object;
                if ((bits & 2L) == 0L) {
                    this.value(((AStringTerm)instance).getValue());
                    bits |= 2L;
                }
            }
            if (object instanceof AbstractTerm) {
                instance = (AbstractTerm)object;
                if ((bits & 1L) == 0L) {
                    this.attachments(((AbstractTerm)instance).getAttachments());
                    bits |= 1L;
                }
            }
            if (object instanceof IStringTerm) {
                instance = (IStringTerm)object;
                if ((bits & 2L) == 0L) {
                    this.value(instance.getValue());
                    bits |= 2L;
                }
            }
        }

        public final Builder attachments(IAttachments attachments) {
            this.attachments = Objects.requireNonNull(attachments, "attachments");
            return this;
        }

        public final Builder value(String value) {
            this.value = Objects.requireNonNull(value, "value");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public StringTerm build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new StringTerm(this, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("value");
            }
            return "Cannot build StringTerm, some of required attributes are not set " + attributes;
        }
    }
}

