/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.solver.components;

import io.usethesource.capsule.Set;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.sym.ISymbolicConstraint;
import mb.nabl2.solver.ASolver;
import mb.nabl2.solver.SeedResult;
import mb.nabl2.solver.SolveResult;
import mb.nabl2.solver.SolverCore;
import mb.nabl2.symbolic.ISymbolicConstraints;
import mb.nabl2.symbolic.SymbolicConstraints;
import mb.nabl2.terms.ITerm;

public class SymbolicComponent
extends ASolver {
    private final Set.Transient<ITerm> facts;
    private final Set.Transient<ITerm> goals;

    public SymbolicComponent(SolverCore core, ISymbolicConstraints initial) {
        super(core);
        this.facts = initial.getFacts().asTransient();
        this.goals = initial.getGoals().asTransient();
    }

    public SeedResult seed(ISymbolicConstraints solution, IMessageInfo message) throws InterruptedException {
        this.facts.__insertAll(solution.getFacts());
        this.goals.__insertAll(solution.getGoals());
        return SeedResult.empty();
    }

    public SolveResult solve(ISymbolicConstraint constraint) {
        constraint.match(ISymbolicConstraint.Cases.of(fact -> this.facts.__insert((Object)fact.getFact()), goal -> this.goals.__insert((Object)goal.getGoal())));
        return SolveResult.empty();
    }

    public ISymbolicConstraints finish() {
        return SymbolicConstraints.of((Set.Immutable<ITerm>)this.facts.freeze(), (Set.Immutable<ITerm>)this.goals.freeze());
    }
}

