/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.sym;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.sym.ACFact;
import mb.nabl2.terms.ITerm;

public final class CFact
extends ACFact
implements Serializable {
    private final ITerm fact;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CFact(ITerm fact, IMessageInfo messageInfo) {
        this.fact = Objects.requireNonNull(fact, "fact");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CFact(CFact original, ITerm fact, IMessageInfo messageInfo) {
        this.fact = fact;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getFact() {
        return this.fact;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CFact withFact(ITerm value) {
        if (this.fact == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "fact");
        return new CFact(this, newValue, this.messageInfo);
    }

    public final CFact withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CFact(this, this.fact, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CFact && this.equalTo((CFact)another);
    }

    private boolean equalTo(CFact another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.fact.equals(another.fact) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.fact.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CFact of(ITerm fact, IMessageInfo messageInfo) {
        return new CFact(fact, messageInfo);
    }

    public static CFact copyOf(ACFact instance) {
        if (instance instanceof CFact) {
            return (CFact)instance;
        }
        return CFact.of(instance.getFact(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CFact(this, this.fact, this.messageInfo);
    }
}

