/*
 * Decompiled with CFR 0.152.
 */
package mb.nabl2.constraints.sets;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Objects;
import mb.nabl2.constraints.messages.IMessageInfo;
import mb.nabl2.constraints.sets.ACEvalSet;
import mb.nabl2.terms.ITerm;

public final class CEvalSet
extends ACEvalSet
implements Serializable {
    private final ITerm result;
    private final ITerm set;
    private final IMessageInfo messageInfo;
    private final int hashCode;
    private static final long serialVersionUID = 42L;

    private CEvalSet(ITerm result, ITerm set, IMessageInfo messageInfo) {
        this.result = Objects.requireNonNull(result, "result");
        this.set = Objects.requireNonNull(set, "set");
        this.messageInfo = Objects.requireNonNull(messageInfo, "messageInfo");
        this.hashCode = this.computeHashCode();
    }

    private CEvalSet(CEvalSet original, ITerm result, ITerm set, IMessageInfo messageInfo) {
        this.result = result;
        this.set = set;
        this.messageInfo = messageInfo;
        this.hashCode = this.computeHashCode();
    }

    @Override
    public ITerm getResult() {
        return this.result;
    }

    @Override
    public ITerm getSet() {
        return this.set;
    }

    @Override
    public IMessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public final CEvalSet withResult(ITerm value) {
        if (this.result == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "result");
        return new CEvalSet(this, newValue, this.set, this.messageInfo);
    }

    public final CEvalSet withSet(ITerm value) {
        if (this.set == value) {
            return this;
        }
        ITerm newValue = Objects.requireNonNull(value, "set");
        return new CEvalSet(this, this.result, newValue, this.messageInfo);
    }

    public final CEvalSet withMessageInfo(IMessageInfo value) {
        if (this.messageInfo == value) {
            return this;
        }
        IMessageInfo newValue = Objects.requireNonNull(value, "messageInfo");
        return new CEvalSet(this, this.result, this.set, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CEvalSet && this.equalTo((CEvalSet)another);
    }

    private boolean equalTo(CEvalSet another) {
        if (this.hashCode != another.hashCode) {
            return false;
        }
        return this.result.equals(another.result) && this.set.equals(another.set) && this.messageInfo.equals(another.messageInfo);
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.result.hashCode();
        h += (h << 5) + this.set.hashCode();
        h += (h << 5) + this.messageInfo.hashCode();
        return h;
    }

    public static CEvalSet of(ITerm result, ITerm set, IMessageInfo messageInfo) {
        return new CEvalSet(result, set, messageInfo);
    }

    public static CEvalSet copyOf(ACEvalSet instance) {
        if (instance instanceof CEvalSet) {
            return (CEvalSet)instance;
        }
        return CEvalSet.of(instance.getResult(), instance.getSet(), instance.getMessageInfo());
    }

    private Object readResolve() throws ObjectStreamException {
        return new CEvalSet(this, this.result, this.set, this.messageInfo);
    }
}

